<!-- history begin -->
<%@include file="top.jsp"%>
<c:out value="${topArea}" escapeXml="false"/>
<table border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td>
      <div class="navbar">
        <%@ include file="navbar-virtual-wiki.jsp"%>
        <%@ include file="navbar-history-list.jsp"%>
        &nbsp; <!-- to render the bar even when empty -->
      </div>
    </td>
  </tr>
</table>
<table border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <c:if test="${!empty leftMenu && leftMenu != '<br/><br/>'}">
      <td nowrap class="leftMenu" valign="top" width="10%">
        <c:out value="${leftMenu}" escapeXml="false"/>
      </td>
    </c:if>
    <td valign="top">
      <div class="menu"  align="right">
      <a href="Wiki?RecentChanges"><f:message key="generalmenu.recentchanges"/></a> |
      <a href="Wiki?WikiSearch"><f:message key="generalmenu.search"/></a> |
      <vqwiki:encode value="${param.topic}" var="encodedTopic"/>
      <a href='Wiki?<c:out value="${encodedTopic}"/>'><f:message key="history.current"/></a> |
      <c:if test="${param.type=='version'}">
        <c:url value="Wiki" var="nextVersionUrl">
          <c:param name="action" value="action_history"/>
          <c:param name="type" value="version"/>
          <c:param name="versionNumber" value="${topicVersion.versionNumber-1}"/>
          <c:param name="topic" value="${topicVersion.topicName}"/>
        </c:url>
        <c:url value="Wiki" var="previousVersionUrl">
          <c:param name="action" value="action_history"/>
          <c:param name="type" value="version"/>
          <c:param name="versionNumber" value="${topicVersion.versionNumber+1}"/>
          <c:param name="topic" value="${topicVersion.topicName}"/>
        </c:url>
        <c:url value="Wiki" var="historyUrl">
          <c:param name="action" value="action_history"/>
          <c:param name="type" value="all"/>
          <vqwiki:encode value="${topicVersion.topicName}" var="encodedTopic"/>
          <c:param name="topic" value="${encodedTopic}"/>
        </c:url>
        <c:if test="${param.versionNumber < (numberOfVersions-1)}">
          <a href='Wiki?action=action_history&type=version&versionNumber=<c:out value="${topicVersion.versionNumber+1}"/>&topic=<c:out value="${encodedTopic}"/>
'><f:message key="history.prev"/></a> |
        </c:if>
        <c:if test="${param.versionNumber > 0}">
          <a href='Wiki?action=action_history&type=version&versionNumber=<c:out value="${topicVersion.versionNumber-1}"/>&topic=<c:out value="${encodedTopic}"/>
'><f:message key="history.next"/></a> |
        </c:if>
        <a href='Wiki?action=action_history&type=all&topic=<c:out value="${encodedTopic}"/>'><f:message key="menu.history"/></a>
      </c:if>
      </div>
          <div class="contents">
          <span class="pageHeader">
          <c:out value="${title}"/>
          </span><p/>
      <c:choose>
        <c:when test="${param.type=='all'}">
          <form action="Wiki" method="post">
          <input type="hidden" name="action" value="action_diff"/>
          <input type="hidden" name="type" value="arbitrary"/>
          <input type="submit" value='<f:message key="history.diff"/>'/>
          <vqwiki:encode value="${param.topic}" var="encodedTopic"/>
          <input type="hidden" name="topic" value='<c:out value="${encodedTopic}"/>'/>
          <c:forEach items="${versions}" var="version">
            <f:formatDate
              value="${version.revisionDate}"
              type="both"
              dateStyle="MEDIUM"
              timeStyle="MEDIUM"
              var="revisionDate"
            />
            <c:url value="Wiki" var="versionURL">
              <c:param name="action" value="action_history"/>
              <c:param name="type" value="version"/>
              <c:param name="versionNumber" value="${version.versionNumber}"/>
              <c:param name="topic" value="${version.topicName}"/>
            </c:url>
            <p>
              <vqwiki:encode value="${version.topicName}" var="encodedTopic"/>
              <a href='Wiki?action=action_history&type=version&versionNumber=<c:out value="${version.versionNumber}"/>&topic=<c:out value="${encodedTopic}"/>'>
                <c:out value="${revisionDate}"/> </a> <input type="checkbox" name='<c:out value="diff:${version.versionNumber}"/>'/>
            </p>
          </c:forEach>
          <input type="submit" value='<f:message key="history.diff"/>'/>
          </form>
        </c:when>
        <c:when test="${param.type=='version'}">
            <c:out value="${topicVersion.cookedContents}" escapeXml="${false}"/>
          <hr/>
          <form>
            <textarea readonly="true" cols="80" rows="26"><c:out value="${topicVersion.rawContents}" escapeXml="${false}"/></textarea>
          </form>
        </c:when>
      </c:choose>
      </div>
      <div class="menu" align="right">
      <a href="Wiki?RecentChanges"><f:message key="generalmenu.recentchanges"/></a> |
      <a href="Wiki?WikiSearch"><f:message key="generalmenu.search"/></a> |
      <vqwiki:encode value="${param.topic}" var="encodedTopic"/>
      <a href='Wiki?<c:out value="${encodedTopic}"/>'><f:message key="history.current"/></a> |
      <c:if test="${param.type=='version'}">
        <c:if test="${param.versionNumber < (numberOfVersions-1)}">
          <a href='Wiki?action=action_history&type=version&versionNumber=<c:out value="${topicVersion.versionNumber+1}"/>&topic=<c:out value="${encodedTopic}"/>
'><f:message key="history.prev"/></a> |
        </c:if>
        <c:if test="${param.versionNumber > 0}">
          <a href='Wiki?action=action_history&type=version&versionNumber=<c:out value="${topicVersion.versionNumber-1}"/>&topic=<c:out value="${encodedTopic}"/>
'><f:message key="history.next"/></a> |
        </c:if>
        <a href='Wiki?action=action_history&type=all&topic=<c:out value="${encodedTopic}"/>'><f:message key="menu.history"/></a>
      </c:if>
      </div>
    </td>
  </tr>
</table>
<%@ include file="close-document.jsp"%>
<!-- history end -->
