<!-- admin begin -->
<%--
Very Quick Wiki - WikiWikiWeb clone
Copyright (C) 2001-2003 Gareth Cronin

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program (gpl.txt); if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<html>
<head>
<%@ taglib uri="/WEB-INF/classes/vqwiki.tld" prefix="vqwiki" %>
<%@ taglib uri="/WEB-INF/classes/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/classes/fmt.tld" prefix="f" %>
<f:setBundle basename="ApplicationResources"/>
<vqwiki:is-admin var="admin"/>

<title><f:message key="admin.title"/></title>
<META HTTP-EQUIV="Expires" CONTENT="Mon, 06 Jan 1990 00:00:01 GMT">
<link rel="stylesheet" href="../vqwiki.css" type="text/css">

<%@page import="vqwiki.*,vqwiki.utils.*,java.util.*,org.apache.commons.pool.impl.*,
                java.sql.SQLException" errorPage="error.jsp"%>
<%
  String message = "";

  if( request.getParameter("message") != null ){
    message = request.getParameter("message");
  }
  Collection readOnlyTopics = new ArrayList();
  try{
    WikiBase wb = WikiBase.getInstance();
    readOnlyTopics = wb.getReadOnlyTopics( (String)request.getAttribute("virtualWiki") );
  } catch( Exception err ){
    // Ignore database error - probably just an invalid setting, the
    // user may not have config'd yet
  }
  Environment en = Environment.getInstance();
  String editTimeout = String.valueOf( en.getEditTimeOut() );
  String indexInterval = String.valueOf( en.getIndexRefreshInterval() );
  String recentChangesInterval = String.valueOf(en.getRecentChangesRefreshInterval());
  boolean versioning = en.isVersioningOn();
  boolean allowHTML = en.getAllowHTML();
  boolean allowBackTick = en.isAllowBackTick();
  boolean forceUserName = en.isForceUsername();
  String uploadDir = en.getUploadDir();
  boolean attachmentsToDatabase = en.isAttachmentsToDatabase();
  String homeDir = en.getHomeDir();
  String url = en.getUrl();
  String username = en.getUserName();
  String password = en.getPassword();
  String driver = en.getDriver();
  boolean allowTemplates = en.getBooleanSetting(Environment.PROPERTY_ALLOW_TEMPLATES);
  String smtp = en.getStringSetting(Environment.PROPERTY_SMTP_HOST);
  String replyAddress = en.getStringSetting(Environment.PROPERTY_REPLY_ADDRESS);
  int persistenceType = en.getPersistenceType();
  String smtpUsername = en.getStringSetting(Environment.PROPERTY_SMTP_USERNAME);
  String smtpPassword = en.getStringSetting(Environment.PROPERTY_SMTP_PASSWORD);
  String formatLexer = en.getStringSetting(Environment.PROPERTY_FORMAT_LEXER);
  String linkLexer = en.getStringSetting(Environment.PROPERTY_LINK_LEXER);
  String layoutLexer = en.getStringSetting(Environment.PROPERTY_LAYOUT_LEXER);
  int recentChangesDays = en.getIntSetting(Environment.PROPERTY_RECENT_CHANGES_DAYS);
  int maximumBacklinks = en.getIntSetting(Environment.PROPERTY_MAXIMUM_BACKLINKS);
  int newLineBreaks = en.getIntSetting(Environment.PROPERTY_NEW_LINE_BREAKS);
  int maximumFileSize = (int)((float)en.getIntSetting(Environment.PROPERTY_MAX_FILE_SIZE)/1000);
  String attachmentType = en.getStringSetting(Environment.PROPERTY_ATTACHMENT_TYPE);
  boolean convertTabs = en.getBooleanSetting(Environment.PROPERTY_CONVERT_TABS);
  boolean convertEntities = en.getBooleanSetting(Environment.PROPERTY_CONVERT_ENTITIES);
  String defaultTopic = en.getStringSetting(Environment.PROPERTY_DEFAULT_TOPIC);
  String databaseType = en.getStringSetting(Environment.PROPERTY_DATABASE_TYPE);
  boolean allowVirtualWikiList = en.isAllowVirtualWikiList();
  int dbcpMaxActive = en.getIntSetting(Environment.PROPERTY_DBCP_MAX_ACTIVE);
  int dbcpMaxIdle = en.getIntSetting(Environment.PROPERTY_DBCP_MAX_IDLE);
  boolean dbcpTestOnBorrow = en.getBooleanSetting(Environment.PROPERTY_DBCP_TEST_ON_BORROW);
  boolean dbcpTestOnReturn = en.getBooleanSetting(Environment.PROPERTY_DBCP_TEST_ON_RETURN);
  boolean dbcpTestWhileIdle = en.getBooleanSetting(Environment.PROPERTY_DBCP_TEST_WHILE_IDLE);
  int dbcpMinEvictableIdleTime = en.getIntSetting(Environment.PROPERTY_DBCP_MIN_EVICTABLE_IDLE_TIME);
  int dbcpTimeBetweenEvictionRuns = en.getIntSetting(Environment.PROPERTY_DBCP_TIME_BETWEEN_EVICTION_RUNS);
  int dbcpNumTestsPerEvictionRun = en.getIntSetting(Environment.PROPERTY_DBCP_NUM_TESTS_PER_EVICTION_RUN);
  int dbcpWhenExhaustedAction = en.getIntSetting(Environment.PROPERTY_DBCP_WHEN_EXHAUSTED_ACTION);
  String dbcpValidationQuery = en.getStringSetting(Environment.PROPERTY_DBCP_VALIDATION_QUERY);
  boolean dbcpRemoveAbandoned = en.getBooleanSetting(Environment.PROPERTY_DBCP_REMOVE_ABANDONED);
  boolean dbcpLogAbandoned = en.getBooleanSetting(Environment.PROPERTY_DBCP_LOG_ABANDONED);
  int dbcpRemoveAbandonedTimeout = en.getIntSetting(Environment.PROPERTY_DBCP_REMOVE_ABANDONED_TIMEOUT);
  String wikiServerHostname = en.getStringSetting(Environment.PROPERTY_WIKI_SERVER_HOSTNAME);
  String fileEncoding = en.getStringSetting(Environment.PROPERTY_FILE_ENCODING);
  boolean attachmentIndexingEnabled = en.isAttachmentIndexingEnabled();
  boolean separateWikiTitleWords = en.isSeparateWikiTitleWords() ;
  boolean suppressNotifyWithinSameDay = en.getBooleanSetting(Environment.PROPERTY_SUPPRESS_NOTIFY_WITHIN_SAME_DAY);
%>
</head>

<body text="#000000">
<p class="pageHeader">
<img class="logo" width="147" height="35" src="../images/logo.jpg" alt="Starting Point"/><f:message key="admin.title"/></p>
<%@include file="generalmenu.jsp"%>
<form action="Wiki" method="get">
  <input type="hidden" name="function" value="logout"/>
  <input type="hidden" name="action" value="action_admin"/>
  <table>
    <tr>
      <td><input type="submit" value="<f:message key="admin.action.logout"/>"/></td>
    </tr>
  </table>
</form>
<form name="form1" method="post" action="Wiki">
<% if( !message.equals("") ){%>
<p class="red"><%=message%></p>
<%}%>
  <p class="subHeader"><f:message key="admin.title.settings"/></p>
  <table border="0" class="contents">
    <tr>
      <td class="normal"><f:message key="admin.caption.edittimeout"/></td>
      <td class="normal">
        <input type="text" name="editTimeout" size="3" maxlength="10" value="<%=editTimeout%>">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.recentchangesdays"/></td>
      <td class="normal">
        <input type="text" name="recentChangesDays" size="3" maxlength="3" value="<%=recentChangesDays%>">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.maxbacklinks"/></td>
      <td class="normal">
        <input type="text" name="maximumBacklinks" size="3" maxlength="3" value="<%=maximumBacklinks%>">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.indexinterval"/></td>
      <td class="normal">
        <input type="text" name="indexInterval" size="5" maxlength="10" value="<%=indexInterval%>">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.indexattachments"/></td>
      <td class="normal">
        <input type="checkbox" name="indexAttachments" value="true"
				<%=attachmentIndexingEnabled?"checked":""%>>
      </td>
    </tr>
    <tr>
	  <td class="normal"><f:message key="admin.caption.recentchangesinterval"/></td>
	  <td class="normal">
	    <input type="text" name="recentChangesInterval" size="5" maxlength="10" value="<%=recentChangesInterval%>">
	  </td>    
    </tr>    
    <tr>
      <td class="normal"><f:message key="admin.caption.newlinebreaks"/></td>
      <td class="normal">
        <input type="text" name="newLineBreaks" size="2" maxlength="2" value="<%=newLineBreaks%>">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.defaulttopic"/></td>
      <td class="normal">
        <input type="text" name="defaultTopic" value="<%=defaultTopic==null?"":defaultTopic%>">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.useversioning"/></td>
      <td class="normal">
        <input type="checkbox" name="versioning" value="true"
				<%=versioning?"checked":""%>>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.usetemplates"/></td>
      <td class="normal">
        <input type="checkbox" name="allowTemplates" value="true"
				<%=allowTemplates?"checked":""%>>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.allowhtml"/></td>
      <td class="normal">
        <input type="checkbox" name="allowHtml" value="true"
				<%=allowHTML?"checked":""%>>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.allowbacktick"/></td>
      <td class="normal">
        <input type="checkbox" name="allowBackTick" value="true"
				<%=allowBackTick?"checked":""%>>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.forceusername"/></td>
      <td class="normal">
        <input type="checkbox" name="forceUserName" value="true"
				<%=forceUserName?"checked":""%>>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.allowvirtualwikilist"/></td>
      <td class="normal">
        <input type="checkbox" name="allowVirtualWikiList" value="true"
				<%=allowVirtualWikiList?"checked":""%>>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.separatewikititlewords"/></td>
      <td class="normal">
        <input type="checkbox" name="separateWikiTitleWords" value="true"
        <%=separateWikiTitleWords?"checked":""%>>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.converttabs"/></td>
      <td class="normal">
        <input type="checkbox" name="convertTabs" value="true"
				<%=convertTabs?"checked":""%>>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.formatlexer"/></td>
      <td class="normal">
        <input type="text" name="formatLexer" value="<%=formatLexer%>" size="15">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.layoutlexer"/></td>
      <td class="normal">
        <input type="text" name="layoutLexer" value="<%=layoutLexer%>" size="15"> <f:message key="admin.caption.nulllex"/>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.linklexer"/></td>
      <td class="normal">
        <input type="text" name="linkLexer" value="<%=linkLexer%>" size="15"> <f:message key="admin.caption.nulllex"/>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.uploaddir"/></td>
      <td class="normal">
        <input type="text" name="uploadDir" value="<%=uploadDir%>" size="50">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.maxfilesize"/></td>
      <td class="normal">
        <input type="text" name="maximumFileSize" value="<%=maximumFileSize%>" size="10">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.attachment"/></td>
      <td class="normal">
        <select name="attachmentType">
           <option value="inline" <%=attachmentType.equals("inline")?"selected":""%>><f:message key="admin.caption.attachment.inline"/></option>
           <option value="attachment" <%=attachmentType.equals("attachment")?"selected":""%>><f:message key="admin.caption.attachment.attachment"/></option>
        </select>
      </td>
    </tr>
   <tr>
      <td class="normal"><f:message key="admin.caption.filedir"/></td>
      <td class="normal">
        <input type="text" name="homeDir" value="<%=homeDir%>" size="50">
      </td>
    </tr>
   <tr>
      <td class="normal"><f:message key="admin.caption.fileEncoding"/></td>
      <td class="normal">
      
        <select name="fileEncoding">
           <option value="utf-8" <%=fileEncoding.equals("utf-8")?"selected":""%>>utf-8</option>
           <option value="iso-8859-1" <%=fileEncoding.equals("iso-8859-1")?"selected":""%>>iso-8859-1</option>
        </select>
        <!--<input type="text" name="fileEncoding" value="<%=fileEncoding%>">-->
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.smtp"/></td>
      <td class="normal">
        <table>
        <tr>
        <td><f:message key="admin.caption.smtp.host"/></td>
        <td><input type="text" name="smtp" value="<%=smtp%>" size="30"></td>
        </tr>
        <tr>
        <td><f:message key="admin.caption.smtp.user"/></td>
        <td><input type="text" name="smtpUsername" value="<%=smtpUsername%>" size="10"></td>
        </tr>
        <tr>
        <td><f:message key="admin.caption.smtp.pass"/></td>
        <td><input type="text" name="smtpPassword" value="<%=smtpPassword%>" size="10"></td>
        </tr>
        <tr>
        <td><f:message key="admin.caption.wikiserverhostname"/></td>
        <td><input type="text" name="wikiServerHostname" value='<%=wikiServerHostname==null?"":wikiServerHostname%>' size="10"></td>
        </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.reply"/></td>
      <td class="normal">
        <input type="text" name="replyAddress" value="<%=replyAddress%>" size="50">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.suppressnotifywithinsameday"/></td>
      <td class="normal">
        <input type="checkbox" name="suppressNotifyWithinSameDay" value="true"
        <%=suppressNotifyWithinSameDay?"checked":""%>>
      </td>
    </tr>

    <tr>
      <td class="normal"><f:message key="admin.caption.persistence"/></td>
      <td class="normal">
        <select name="persistenceType">
           <option value="<%=WikiBase.FILE%>" <%=persistenceType==WikiBase.FILE?"selected":""%>><f:message key="admin.persistencetype.flatfile"/></option>
           <option value="<%=WikiBase.DATABASE%>" <%=persistenceType==WikiBase.DATABASE?"selected":""%>><f:message key="admin.persistencetype.database"/></option>
        </select>
      </td>
    </tr>
<%
  if( persistenceType == WikiBase.DATABASE ){
%>
    <tr>
      <td class="normal"><f:message key="admin.caption.databasedriver"/></td>
      <td class="normal">
        <input type="text" name="driver" value="<%=driver%>" size="50">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.databasetype"/></td>
      <td class="normal">
<%--        <input type="text" name="databaseType" value="<%=databaseType%>" size="10">--%>
        <select name="databaseType">
           <option value="mysql" <%="mysql".equals(databaseType)?"selected":""%>>mysql</option>
           <option value="ansi" <%="ansi".equals(databaseType)?"selected":""%>>ansi</option>
           <option value="oracle" <%="oracle".equals(databaseType)?"selected":""%>>oracle</option>
           <option value="postgres" <%="postgres".equals(databaseType)?"selected":""%>>postgres</option>
        </select>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.databaseurl"/></td>
      <td class="normal">
        <input type="text" name="url" value="<%=url%>" size="50">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.databaseuser"/></td>
      <td class="normal">
        <input type="text" name="username" value="<%=username%>" size="15">
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.databasepass"/></td>
      <td class="normal">
        <input type="text" name="password" value="<%=password%>" size="15">
      </td>
    </tr>
    <tr><td colspan="2">&nbsp;</td></tr>
    <tr>
      <td class="normal" colspan="2" align="center"><f:message key="admin.caption.dbcp.header"/></td>
    </tr>
    <tr><td colspan="2">&nbsp;</td></tr>
	<tr>
	  <td class="normal"><f:message key="admin.caption.dbcp.maxactive"/></td>
	  <td class="normal">
	    <input type="text" name="dbcp_max_active" value="<%=dbcpMaxActive%>" size="5"/>
	  </td>
	</tr>
	<tr>
	  <td class="normal"><f:message key="admin.caption.dbcp.maxidle"/></td>
	  <td class="normal">
	    <input type="text" name="dbcp_max_idle" value="<%=dbcpMaxIdle%>" size="5"/>
	  </td>
	</tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.dbcp.testonborrow"/></td>
      <td class="normal">
        <input type="checkbox" name="dbcp_test_on_borrow" value="true"
				<%=dbcpTestOnBorrow?"checked":""%>>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.dbcp.testonreturn"/></td>
      <td class="normal">
        <input type="checkbox" name="dbcp_test_on_return" value="true"
				<%=dbcpTestOnReturn?"checked":""%>>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.dbcp.testwhileidle"/></td>
      <td class="normal">
        <input type="checkbox" name="dbcp_test_while_idle" value="true"
				<%=dbcpTestWhileIdle?"checked":""%>>
      </td>
    </tr>
	<tr>
	  <td class="normal"><f:message key="admin.caption.dbcp.minevictableidletime"/></td>
	  <td class="normal">
	    <input type="text" name="dbcp_min_evictable_idle_time" value="<%=dbcpMinEvictableIdleTime%>" size="5"/>
	  </td>
	</tr>
	<tr>
	  <td class="normal"><f:message key="admin.caption.dbcp.timebetweenevictionruns"/></td>
	  <td class="normal">
	    <input type="text" name="dbcp_time_between_eviction_runs" value="<%=dbcpTimeBetweenEvictionRuns%>" size="5"/>
	  </td>
	</tr>
	<tr>
	  <td class="normal"><f:message key="admin.caption.dbcp.numtestsperevictionrun"/></td>
	  <td class="normal">
	    <input type="text" name="dbcp_num_tests_per_eviction_run" value="<%=dbcpNumTestsPerEvictionRun%>" size="5"/>
	  </td>
	</tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.dbcp.whenexhaustedaction"/></td>
      <td class="normal">
        <select name="dbcp_when_exhausted_action">
           <option value="<%=GenericObjectPool.WHEN_EXHAUSTED_FAIL%>" <%=dbcpWhenExhaustedAction==GenericObjectPool.WHEN_EXHAUSTED_FAIL?"selected":""%>><f:message key="admin.caption.dbcp.whenexhaustedaction.fail"/></option>
           <option value="<%=GenericObjectPool.WHEN_EXHAUSTED_BLOCK%>" <%=dbcpWhenExhaustedAction==GenericObjectPool.WHEN_EXHAUSTED_BLOCK?"selected":""%>><f:message key="admin.caption.dbcp.whenexhaustedaction.block"/></option>
           <option value="<%=GenericObjectPool.WHEN_EXHAUSTED_GROW%>" <%=dbcpWhenExhaustedAction==GenericObjectPool.WHEN_EXHAUSTED_GROW?"selected":""%>><f:message key="admin.caption.dbcp.whenexhaustedaction.grow"/></option>
        </select>
      </td>
    </tr>
	<tr>
	  <td class="normal"><f:message key="admin.caption.dbcp.validationquery"/></td>
	  <td class="normal">
	    <input type="text" name="dbcp_validation_query" value="<%=dbcpValidationQuery%>" size="30"/>
	  </td>
	</tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.dbcp.removeabandoned"/></td>
      <td class="normal">
        <input type="checkbox" name="dbcp_remove_abandoned" value="true"
				<%=dbcpRemoveAbandoned?"checked":""%>>
      </td>
    </tr>
    <tr>
      <td class="normal"><f:message key="admin.caption.dbcp.logabandoned"/></td>
      <td class="normal">
        <input type="checkbox" name="dbcp_log_abandoned" value="true"
				<%=dbcpLogAbandoned?"checked":""%>>
      </td>
    </tr>
	<tr>
	  <td class="normal"><f:message key="admin.caption.dbcp.removeabandonedtimeout"/></td>
	  <td class="normal">
	    <input type="text" name="dbcp_remove_abandoned_timeout" value="<%=dbcpRemoveAbandonedTimeout%>" size="5"/>
	  </td>
	</tr>
<%
  }
%>
    <tr>
      <td class="normal">
        <input type="submit" name="Submit" value="<f:message key="admin.action.save"/>">
      </td>
      <td class="normal">&nbsp;</td>
    </tr>
  </table>
  <input type="hidden" name="function" value="properties">
  <input type="hidden" name="action" value="action_admin"/>
</form>
<hr/>
<p class="subHeader"><f:message key="admin.title.refresh"/></p>
<form name="refreshform" method="post" action="Wiki">
  <input type="submit" name="submit" value="<f:message key="admin.action.refresh"/>"/>
  <f:message key="admin.message.filemodeonly"/>
  <input type="hidden" name="function" value="refreshIndex"/>
  <input type="hidden" name="action" value="action_admin"/>
</form>
<hr/>
<p class="subHeader"><f:message key="admin.title.purge"/></p>
<form name="purgeform" method="post" action="Wiki">
<f:message key="admin.caption.virtualwiki"/>
<select name="virtual-wiki">
<option value="jsp"><f:message key="common.default"/></option>
<%
  Collection virtualWikis = null;
  try {
    virtualWikis = WikiBase.getInstance().getVirtualWikiList();
  } catch (Exception e) {
    virtualWikis = new ArrayList();
  }
  for (Iterator iterator = virtualWikis.iterator(); iterator.hasNext();) {
    String wikiName = (String) iterator.next();
%>
  <option value='<%=wikiName%>'><%=wikiName%></option>
<%
  }
%>
  </select>
  <input type="submit" name="submit" value="<f:message key="admin.action.purge"/>"/>
  <input type="hidden" name="function" value="purge"/>
  <input type="hidden" name="action" value="action_admin"/>
</form>
<hr/>
<p class="subHeader"><f:message key="admin.title.readonly"/> (<c:out value="${virtualWiki}"/>)</p>
<form name="readOnlyTopics" method="post" action="Wiki" class="contents">
  <input type="hidden" name="action" value="action_admin"/>
  <table border="0">
    <tr>
      <td>
        <input type="text" name="readOnlyTopic">
      </td>
      <td>
        <input type="submit" name="addReadOnly" value="<f:message key="admin.action.add"/>">
      </td>
    </tr>
  </table>
  <table border="0">
    <tr>
      <td><f:message key="common.topic"/></td>
      <td><f:message key="admin.caption.mark"/></td>
    </tr>
    <%
	if( readOnlyTopics != null ){
      Iterator it = readOnlyTopics.iterator();
      while( it.hasNext() ){
          String topic = (String)it.next();
%>
    <tr>
      <td><%=topic%></td>
      <td>
        <input type="checkbox" name="markRemove" value="<%=topic%>">
      </td>
    </tr>
    <%}
    }%>
    <tr>
      <td>
        <input type="submit" name="removeReadOnly" value="<f:message key="admin.action.remove"/>">
      </td>
      <td>&nbsp;</td>
    </tr>
  </table>
</form>
<hr/>
<p class="subHeader"><f:message key="admin.title.virtualwiki"/></p>
<form action="Wiki" method="post">
  <table class="contents">
    <tr>
      <td><p><f:message key="common.name"/></p></td><td><input type="textfield" name="newVirtualWiki"/></td>
      <td><input type="submit" value='<f:message key="common.add"/>'/></td>
    </tr>
  </table>
  <input type="hidden" name="function" value="addVirtualWiki">
  <input type="hidden" name="action" value="action_admin"/>
</form>
<hr/>
<p class="subHeader"><f:message key="admin.title.changepassword"/></p>
<form action="Wiki" method="post">
  <table class="contents">
    <tr>
      <td><f:message key="admin.caption.oldpassword"/></td>
      <td><input type="password" name="oldPassword"/></td>
    </tr>
    <tr>
      <td><f:message key="admin.caption.newpassword"/></td>
      <td><input type="password" name="newPassword"/></td>
    </tr>
    <tr>
      <td><f:message key="admin.caption.confirmpassword"/></td>
      <td><input type="password" name="confirmPassword"/></td>
    </tr>
    <tr>
    <td><input type="submit" value='<f:message key="common.change"/>'/></td>
    </tr>
  </table>
  <input type="hidden" name="function" value="changePassword">
  <input type="hidden" name="action" value="action_admin"/>
</form>
<hr/>
<p class="subHeader"><f:message key="admin.title.import"/></p>
<a href="Wiki?action=action_import"><f:message key="admin.caption.startimport"/></a>
<hr/>
<p class="subHeader"><f:message key="admin.title.panic"/></p>
<form action="Wiki" method="post">
  <table class="contents">
    <tr>
      <td><f:message key="admin.caption.panic"/></td>
    </tr>
    <tr>
      <td><input type="submit" value='<f:message key="admin.caption.reset"/>'/></td>
    </tr>
  </table>
  <input type="hidden" name="function" value="panic">
  <input type="hidden" name="action" value="action_admin"/>
</form>
<hr/>
<%@include file="generalmenu.jsp"%>
</body>
</html>
<!-- admin end -->
