/* Generated By:JavaCC: Do not edit this line. SimpleCharStream.java Version 2.1 */
// package com.tchibo.misc.lucene;
package vqwiki.utils.lucene;


/**
 * An implementation of interface CharStream, where the stream is assumed to
 * contain only ASCII characters (without unicode processing).
 *
 * @version $Id: SimpleCharStream.java,v 1.3 2003/10/05 05:07:32 garethc Exp $
 */

public final class SimpleCharStream {
  /**
   * TODO: Document this field.
   */
  int available;
  /**
   * TODO: Document this field.
   */
  private int bufcolumn[];

  /**
   * TODO: Document this field.
   */
  private char[] buffer;
  /**
   * TODO: Document this field.
   */
  private int bufline[];
  /**
   * TODO: Document this field.
   */
  public int bufpos = -1;
  /**
   * TODO: Document this field.
   */
  int bufsize;

  /**
   * TODO: Document this field.
   */
  private int column = 0;
  /**
   * TODO: Document this field.
   */
  private int inBuf = 0;

  /**
   * TODO: Document this field.
   */
  private java.io.Reader inputStream;
  /**
   * TODO: Document this field.
   */
  private int line = 1;
  /**
   * TODO: Document this field.
   */
  private int maxNextCharInd = 0;

  /**
   * TODO: Document this field.
   */
  private boolean prevCharIsCR = false;
  /**
   * TODO: Document this field.
   */
  private boolean prevCharIsLF = false;
  /**
   * TODO: Document this field.
   */
  public final static boolean staticFlag = false;
  /**
   * TODO: Document this field.
   */
  int tokenBegin;

  /**
   *Creates a new SimpleCharStream.
   *
   * @param dstream TODO: Document this parameter.
   * @param startline TODO: Document this parameter.
   * @param startcolumn TODO: Document this parameter.
   * @param buffersize TODO: Document this parameter.
   */
  public SimpleCharStream(java.io.Reader dstream, int startline,
                          int startcolumn, int buffersize) {
    inputStream = dstream;
    line = startline;
    column = startcolumn - 1;

    available = bufsize = buffersize;
    buffer = new char[buffersize];
    bufline = new int[buffersize];
    bufcolumn = new int[buffersize];
  }

  /**
   *Creates a new SimpleCharStream.
   *
   * @param dstream TODO: Document this parameter.
   * @param startline TODO: Document this parameter.
   * @param startcolumn TODO: Document this parameter.
   */
  public SimpleCharStream(java.io.Reader dstream, int startline,
                          int startcolumn) {
    this(dstream, startline, startcolumn, 4096);
  }

  /**
   *Creates a new SimpleCharStream.
   *
   * @param dstream TODO: Document this parameter.
   */
  public SimpleCharStream(java.io.Reader dstream) {
    this(dstream, 1, 1, 4096);
  }

  /**
   *Creates a new SimpleCharStream.
   *
   * @param dstream TODO: Document this parameter.
   * @param startline TODO: Document this parameter.
   * @param startcolumn TODO: Document this parameter.
   * @param buffersize TODO: Document this parameter.
   */
  public SimpleCharStream(java.io.InputStream dstream, int startline,
                          int startcolumn, int buffersize) {
    this(new java.io.InputStreamReader(dstream), startline, startcolumn, 4096);
  }

  /**
   *Creates a new SimpleCharStream.
   *
   * @param dstream TODO: Document this parameter.
   * @param startline TODO: Document this parameter.
   * @param startcolumn TODO: Document this parameter.
   */
  public SimpleCharStream(java.io.InputStream dstream, int startline,
                          int startcolumn) {
    this(dstream, startline, startcolumn, 4096);
  }

  /**
   *Creates a new SimpleCharStream.
   *
   * @param dstream TODO: Document this parameter.
   */
  public SimpleCharStream(java.io.InputStream dstream) {
    this(dstream, 1, 1, 4096);
  }

  /**
   * TODO: Document this method.
   *
   * @return TODO: Document the result.
   * @exception java.io.IOException TODO: Document this exception.
   */
  public final char BeginToken()
      throws java.io.IOException {
    tokenBegin = -1;
    char c = readChar();
    tokenBegin = bufpos;

    return c;
  }

  /**
   * TODO: Document this method.
   */
  public void Done() {
    buffer = null;
    bufline = null;
    bufcolumn = null;
  }

  /**
   * TODO: Document this method.
   *
   * @param wrapAround TODO: Document this parameter.
   */
  private final void ExpandBuff(boolean wrapAround) {
    char[] newbuffer = new char[bufsize + 2048];
    int newbufline[] = new int[bufsize + 2048];
    int newbufcolumn[] = new int[bufsize + 2048];

    try {
      if (wrapAround) {
        System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
        System.arraycopy(buffer, 0, newbuffer,
                         bufsize - tokenBegin, bufpos);
        buffer = newbuffer;

        System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
        System.arraycopy(bufline, 0, newbufline, bufsize - tokenBegin, bufpos);
        bufline = newbufline;

        System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
        System.arraycopy(bufcolumn, 0, newbufcolumn, bufsize - tokenBegin, bufpos);
        bufcolumn = newbufcolumn;

        maxNextCharInd = (bufpos += (bufsize - tokenBegin));
      }
      else {
        System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
        buffer = newbuffer;

        System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
        bufline = newbufline;

        System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
        bufcolumn = newbufcolumn;

        maxNextCharInd = (bufpos -= tokenBegin);
      }
    }
    catch (Throwable t) {
      throw new Error(t.getMessage());
    }

    bufsize += 2048;
    available = bufsize;
    tokenBegin = 0;
  }

  /**
   * TODO: Document this method.
   *
   * @exception java.io.IOException TODO: Document this exception.
   */
  private final void FillBuff()
      throws java.io.IOException {
    if (maxNextCharInd == available) {
      if (available == bufsize) {
        if (tokenBegin > 2048) {
          bufpos = maxNextCharInd = 0;
          available = tokenBegin;
        }
        else if (tokenBegin < 0) {
          bufpos = maxNextCharInd = 0;
        }
        else {
          ExpandBuff(false);
        }
      }
      else if (available > tokenBegin) {
        available = bufsize;
      }
      else if ((tokenBegin - available) < 2048) {
        ExpandBuff(true);
      }
      else {
        available = tokenBegin;
      }
    }

    int i;
    try {
      if ((i = inputStream.read(buffer, maxNextCharInd,
                                available - maxNextCharInd)) == -1) {
        inputStream.close();
        throw new java.io.IOException();
      }
      else {
        maxNextCharInd += i;
      }
      return;
    }
    catch (java.io.IOException e) {
      --bufpos;
      backup(0);
      if (tokenBegin == -1) {
        tokenBegin = bufpos;
      }
      throw e;
    }
  }

  /**
   * TODO: Document this method.
   *
   * @return TODO: Document the result.
   */
  public final String GetImage() {
    if (bufpos >= tokenBegin) {
      return new String(buffer, tokenBegin, bufpos - tokenBegin + 1);
    }
    else {
      return new String(buffer, tokenBegin, bufsize - tokenBegin) +
          new String(buffer, 0, bufpos + 1);
    }
  }

  /**
   * TODO: Document this method.
   *
   * @param len TODO: Document this parameter.
   * @return TODO: Document the result.
   */
  public final char[] GetSuffix(int len) {
    char[] ret = new char[len];

    if ((bufpos + 1) >= len) {
      System.arraycopy(buffer, bufpos - len + 1, ret, 0, len);
    }
    else {
      System.arraycopy(buffer, bufsize - (len - bufpos - 1), ret, 0,
                       len - bufpos - 1);
      System.arraycopy(buffer, 0, ret, len - bufpos - 1, bufpos + 1);
    }

    return ret;
  }

  /**
   * TODO: Document this method.
   *
   * @param dstream TODO: Document this parameter.
   * @param startline TODO: Document this parameter.
   * @param startcolumn TODO: Document this parameter.
   * @param buffersize TODO: Document this parameter.
   */
  public void ReInit(java.io.Reader dstream, int startline,
                     int startcolumn, int buffersize) {
    inputStream = dstream;
    line = startline;
    column = startcolumn - 1;

    if (buffer == null || buffersize != buffer.length) {
      available = bufsize = buffersize;
      buffer = new char[buffersize];
      bufline = new int[buffersize];
      bufcolumn = new int[buffersize];
    }
    prevCharIsLF = prevCharIsCR = false;
    tokenBegin = inBuf = maxNextCharInd = 0;
    bufpos = -1;
  }

  /**
   * TODO: Document this method.
   *
   * @param dstream TODO: Document this parameter.
   * @param startline TODO: Document this parameter.
   * @param startcolumn TODO: Document this parameter.
   */
  public void ReInit(java.io.Reader dstream, int startline,
                     int startcolumn) {
    ReInit(dstream, startline, startcolumn, 4096);
  }

  /**
   * TODO: Document this method.
   *
   * @param dstream TODO: Document this parameter.
   */
  public void ReInit(java.io.Reader dstream) {
    ReInit(dstream, 1, 1, 4096);
  }

  /**
   * TODO: Document this method.
   *
   * @param dstream TODO: Document this parameter.
   * @param startline TODO: Document this parameter.
   * @param startcolumn TODO: Document this parameter.
   * @param buffersize TODO: Document this parameter.
   */
  public void ReInit(java.io.InputStream dstream, int startline,
                     int startcolumn, int buffersize) {
    ReInit(new java.io.InputStreamReader(dstream), startline, startcolumn, 4096);
  }

  /**
   * TODO: Document this method.
   *
   * @param dstream TODO: Document this parameter.
   */
  public void ReInit(java.io.InputStream dstream) {
    ReInit(dstream, 1, 1, 4096);
  }

  /**
   * TODO: Document this method.
   *
   * @param dstream TODO: Document this parameter.
   * @param startline TODO: Document this parameter.
   * @param startcolumn TODO: Document this parameter.
   */
  public void ReInit(java.io.InputStream dstream, int startline,
                     int startcolumn) {
    ReInit(dstream, startline, startcolumn, 4096);
  }

  /**
   * TODO: Document this method.
   *
   * @param c TODO: Document this parameter.
   */
  private final void UpdateLineColumn(char c) {
    column++;

    if (prevCharIsLF) {
      prevCharIsLF = false;
      line += (column = 1);
    }
    else if (prevCharIsCR) {
      prevCharIsCR = false;
      if (c == '\n') {
        prevCharIsLF = true;
      }
      else {
        line += (column = 1);
      }
    }

    switch (c) {
      case '\r':
        prevCharIsCR = true;
        break;
      case '\n':
        prevCharIsLF = true;
        break;
      case '\t':
        column--;
        column += (8 - (column & 07));
        break;
      default:
        break;
    }

    bufline[bufpos] = line;
    bufcolumn[bufpos] = column;
  }

  /**
   * Method to adjust line and column numbers for the start of a token.<BR>
   *
   * @param newLine TODO: Document this parameter.
   * @param newCol TODO: Document this parameter.
   */
  public void adjustBeginLineColumn(int newLine, int newCol) {
    int start = tokenBegin;
    int len;

    if (bufpos >= tokenBegin) {
      len = bufpos - tokenBegin + inBuf + 1;
    }
    else {
      len = bufsize - tokenBegin + bufpos + 1 + inBuf;
    }

    int i = 0;

    int j = 0;

    int k = 0;
    int nextColDiff = 0;
    int columnDiff = 0;

    while (i < len &&
        bufline[j = start % bufsize] == bufline[k = ++start % bufsize]) {
      bufline[j] = newLine;
      nextColDiff = columnDiff + bufcolumn[k] - bufcolumn[j];
      bufcolumn[j] = newCol + columnDiff;
      columnDiff = nextColDiff;
      i++;
    }

    if (i < len) {
      bufline[j] = newLine++;
      bufcolumn[j] = newCol + columnDiff;

      while (i++ < len) {
        if (bufline[j = start % bufsize] != bufline[++start % bufsize]) {
          bufline[j] = newLine++;
        }
        else {
          bufline[j] = newLine;
        }
      }
    }

    line = bufline[j];
    column = bufcolumn[j];
  }

  /**
   * TODO: Document this method.
   *
   * @param amount TODO: Document this parameter.
   */
  public final void backup(int amount) {

    inBuf += amount;
    if ((bufpos -= amount) < 0) {
      bufpos += bufsize;
    }
  }

  /**
   * Returns the BeginColumn.
   *
   * @return The BeginColumn.
   */
  public final int getBeginColumn() {
    return bufcolumn[tokenBegin];
  }

  /**
   * Returns the BeginLine.
   *
   * @return The BeginLine.
   */
  public final int getBeginLine() {
    return bufline[tokenBegin];
  }

  /**
   * @return The Column.
   * @see #getEndColumn
   * @deprecated
   */

  public final int getColumn() {
    return bufcolumn[bufpos];
  }

  /**
   * Returns the EndColumn.
   *
   * @return The EndColumn.
   */
  public final int getEndColumn() {
    return bufcolumn[bufpos];
  }

  /**
   * Returns the EndLine.
   *
   * @return The EndLine.
   */
  public final int getEndLine() {
    return bufline[bufpos];
  }

  /**
   * @return The Line.
   * @see #getEndLine
   * @deprecated
   */

  public final int getLine() {
    return bufline[bufpos];
  }

  /**
   * TODO: Document this method.
   *
   * @return TODO: Document the result.
   * @exception java.io.IOException TODO: Document this exception.
   */
  public final char readChar()
      throws java.io.IOException {
    if (inBuf > 0) {
      --inBuf;

      if (++bufpos == bufsize) {
        bufpos = 0;
      }

      return buffer[bufpos];
    }

    if (++bufpos >= maxNextCharInd) {
      FillBuff();
    }

    char c = buffer[bufpos];

    UpdateLineColumn(c);
    return (c);
  }

}
