package vqwiki.utils;

import vqwiki.WikiBase;

import javax.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.io.UnsupportedEncodingException;

import org.apache.log4j.Logger;

/*
Very Quick Wiki - WikiWikiWeb clone
Copyright (C) 2001-2002 Gareth Cronin

This program is free software; you can redistribute it and/or modify
it under the terms of the latest version of the GNU Lesser General
Public License as published by the Free Software Foundation;

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program (gpl.txt); if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class JSPUtils {

  /**
   * Logger
   */
  public static final Logger logger = Logger.getLogger(JSPUtils.class);

  protected static DecimalFormat decFormat = new DecimalFormat("0.00");
  
  public static final String DEFAULTENCODING = "ISO-8859-1";

  
  public JSPUtils() {
  }

  public static String encodeURL(String url, String charset) {
      try {
      	  return URLEncoder.encode(url,charset);
      } catch (java.io.UnsupportedEncodingException ex) { 
      	try {
        	  return URLEncoder.encode(url,DEFAULTENCODING);
       	} catch (UnsupportedEncodingException ex2) {
      		return url;       		
      	}
      }
  }

 
  public static String decodeURL(String url,String charset) {
      try {
    	  return URLDecoder.decode(url,charset);
      } catch (java.io.UnsupportedEncodingException ex) {
      	try {
      	  return URLDecoder.decode(url,DEFAULTENCODING);
     	} catch (UnsupportedEncodingException ex2) {
    		return url;       		
    	}
      }
  }

  public static String decimalFormat(double number) {
    return decFormat.format(number);
  }

  public static String convertToHTML(char character) {
    switch (character) {
      case ('<'):
        return "&lt";
      case ('>'):
        return "&gt";
      case ('&'):
        return "&amp";
    }
    return String.valueOf(character);
  }

  public static boolean containsSpecial(String text) {
    if (text.indexOf('<') >= 0)
      return true;
    else if (text.indexOf('>') >= 0)
      return true;
    else if (text.indexOf('&') >= 0)
      return true;
    return false;
  }

  /**
   * Create the root path for a specific WIKI
   * @param request The HttpServletRequest
   * @param virtualWiki The name of the current virtual Wiki
   * @param includeServer true, if servername should be included; false otherwise
   * @return the root path for this viki
   */
  public static String createRootPath(HttpServletRequest request, String virtualWiki, boolean includeServer) {
    String contextPath = "";
    if (includeServer) {
      contextPath = "http://" + request.getServerName();
      if (request.getServerPort() != 80) {
        contextPath += ":" + request.getServerPort();
      }
    }
    contextPath += request.getContextPath();
    if (virtualWiki == null || virtualWiki.length() < 1) {
      virtualWiki = WikiBase.DEFAULT_VWIKI;
    }
    return contextPath + "/" + virtualWiki + "/";
  }


  public static String createRedirectURL(HttpServletRequest request, String url) {
    String rootPath = JSPUtils.createRootPath(request, (String) request.getAttribute("virtualWiki"), false);
    StringBuffer buffer = new StringBuffer();
    buffer.append(rootPath);
    buffer.append(url);
    return buffer.toString();
  }
}
