package vqwiki.tags;

import vqwiki.Environment;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.log4j.Logger;

/**
 * @author garethc
 * Date: Jan 7, 2003
 */
public class EnvironmentTag extends TagSupport {

  private static final Logger logger = Logger.getLogger( EnvironmentTag.class );

  private String var;

  public int doEndTag() throws JspException {
    try {
      this.pageContext.setAttribute(var, Environment.getInstance());
    }
    catch (Exception e) {
      logger.error("", e);
      throw new JspException("Exception getting environment: " + e);
    }
    return SKIP_BODY;
  }

  public String getVar() {
    return var;
  }

  public void setVar(String var) {
    this.var = var;
  }
}
