/**
 * @author garethc
 * 25/10/2002 12:21:23
 */
package vqwiki.servlets;

import org.apache.log4j.Logger;

import vqwiki.utils.Utilities;

import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class VQWikiServlet extends HttpServlet {
  private static final Logger logger = Logger.getLogger(VQWikiServlet.class);
  private static final SimpleDateFormat dateFormat = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss ZZZZZ");
  private static final Map hosts = new HashMap ();

  public static synchronized boolean checkAccess(HttpServletRequest request) {
  	return checkAccess(request, null);
  }
  public static synchronized boolean checkAccess(HttpServletRequest request, String virtualWiki) {
  	if (virtualWiki == null) {
	  	try {
	  		virtualWiki = Utilities.extractVirtualWiki(request);
	  	} catch (Exception e) {}
  	}
  	String address = request.getRemoteAddr().toLowerCase();
    String host = request.getRemoteHost().toLowerCase();
    try {
    	host = InetAddress.getByName(address).getHostName().toLowerCase();
    } catch (Exception e) {}
  	ResourceBundle blackList = Utilities.getBlackList(virtualWiki);;
  	ResourceBundle whiteList = Utilities.getWhiteList(virtualWiki);
  	
  	boolean isBlack = false;
  	List blackRules = new ArrayList();
  	if (blackList != null) {
	  	for (Enumeration enums = blackList.getKeys(); enums.hasMoreElements();) {
	  		String blackElement = ((String) enums.nextElement()).toLowerCase();
	  		if (address.startsWith(blackElement) | host.startsWith(blackElement)) {
	  			isBlack = true;
	  			blackRules.add(blackElement);
	  		}
	  	}
  	}

  	boolean isWhite = false;
  	List whiteRules = new ArrayList();
  	if (whiteList != null) {
	  	for (Enumeration enums = whiteList.getKeys(); enums.hasMoreElements();) {
	  		String whiteElement = ((String) enums.nextElement()).toLowerCase();
	  		if (address.startsWith(whiteElement) | host.startsWith(whiteElement)) {
	  			isWhite = true;
	  			whiteRules.add(whiteElement);
	  		}
	  	}
  	}
  	
  	if ((blackList == null) & (whiteList == null)) return true;
  	if ((blackList == null) & (whiteList != null)) return isWhite;
  	if ((blackList != null) & (whiteList == null)) return !isBlack;
  	if ((blackList != null) & (whiteList != null)) {
  		if (isWhite & isBlack) {
  			for (int i = 0; i < blackRules.size(); i++) {
  				if (host.startsWith((String)blackRules.get(i))) return false;
  				if (address.equals((String)blackRules.get(i))) return false;
  			}
  			for (int i = 0; i < whiteRules.size(); i++) {
  				if (host.startsWith((String)whiteRules.get(i))) return true;
  				if (address.equals((String)whiteRules.get(i))) return true;
  			}
  			boolean whiter = false;
  			for (int i = 0; i < whiteRules.size(); i++) {
  				boolean localWhite = true;
  				for (int j = 0; j < blackRules.size (); j++) {
  					localWhite = localWhite & ((String)whiteRules.get(i)).startsWith((String)blackRules.get(j)); 
  				}
  				whiter = whiter | localWhite;
  			}
			return whiter;
  		}
  		return (isWhite & !isBlack);
  	}
  	return true;
  }
  
  protected synchronized void logAccess(HttpServletRequest request) {
  	logAccess(request, null);
  }
  
  protected synchronized void logAccess(HttpServletRequest request, String message) {
  	String virtualWiki = null;
  	try {
  		virtualWiki = Utilities.extractVirtualWiki(request);
  	} catch (Exception e) {}
  	String dateString = dateFormat.format(new Date ());
  	String requestQuery = request.getQueryString();
  	if (requestQuery == null) requestQuery = "";
  	String address = request.getRemoteAddr();
  	String host = request.getRemoteHost();
  	if (host.equals(address)) {
  		if (hosts.containsKey(address)) {
  			host = (String) hosts.get(address);
  		} else {
  			try {
  				host = InetAddress.getByName(address).getHostName();
  				if (!host.equals(address)) {
  					hosts.put(address, host);
  				}
  			} catch (UnknownHostException e) {}		
  		}
  	}
  	
  	if (message == null) message = "";
  	System.out.println (dateString + " | " + address + " | " + host + " | " + virtualWiki + " | " + requestQuery + " | " + message);
  }
  
  protected void error(HttpServletRequest request, HttpServletResponse response, Exception err) {
    request.setAttribute("exception", err);
    request.setAttribute("title", "Error");

    if (!(err instanceof WikiServletException)) {
    	err.printStackTrace();
    	logger.error(err.getMessage(), err);
    	log("Error in " + this.getClass(), err);
    } else {     
    	request.setAttribute("javax.servlet.jsp.jspException", err);
    }
   	dispatch("/jsp/servlet-error.jsp", request, response);
  }

  protected void dispatch(String destination, HttpServletRequest request, HttpServletResponse response) {
//  logger.debug("getting dispatcher for " + destination + ", current URL: " + HttpUtils.getRequestURL(request));
	logger.debug("getting dispatcher for " + destination + ", current URL: " + request.getRequestURL());
    RequestDispatcher dispatcher = request.getRequestDispatcher(destination);
    if (dispatcher == null) {
      logger.error("No dispatcher available for " + destination + " (request=" + request +
                   ", response=" + response + ")");
      return;
    }
    try {
      dispatcher.forward(request, response);
    }
    catch (Exception e) {
      log("Dispatch error: " + e.getMessage(), e);
      e.printStackTrace();
      logger.error("dispatch error", e);
      try {
        dispatcher = request.getRequestDispatcher("/jsp/servlet-error.jsp");
        dispatcher.forward(request, response);
      }
      catch (Exception e1) {
        log("Error within dispatch error" + e1);
      }
    }
  }

  protected void include(String destination, HttpServletRequest request, HttpServletResponse response) {
    RequestDispatcher dispatcher = request.getRequestDispatcher(destination);
    if (dispatcher == null) {
      log("No dispatcher available for " + destination + " (request=" + request +
          ", response=" + response + ")");
      return;
    }
    try {
      dispatcher.include(request, response);
    }
    catch (Exception e) {
      log("Dispatch error: " + e.getMessage(), e);
      e.printStackTrace();
      logger.error(e);
      try {
        dispatcher = request.getRequestDispatcher("/jsp/servlet-error.jsp");
        dispatcher.forward(request, response);
      }
      catch (Exception e1) {
        log("Error within dispatch error" + e1);
      }
    }
  }

  protected void redirect(String destination, HttpServletResponse response) {
    String url = response.encodeRedirectURL(destination);
    try {
      response.sendRedirect(url);
    }
    catch (IOException e) {
      logger.error(e);
    }
  }

}

// $Log: VQWikiServlet.java,v $
// Revision 1.9  2003/10/05 05:07:32  garethc
// fixes and admin file encoding option + merge with contributions
//
// Revision 1.8  2003/06/12 20:37:37  garethc
// merge
//
// Revision 1.7  2003/05/18 21:16:07  garethc
// lex fixes
//
// Revision 1.6  2003/04/15 23:11:04  garethc
// lucene fixes
//
// Revision 1.5  2003/04/15 08:33:11  mrgadget4711
// ADD: Search using Lucene
// ADD: RSS feed
//
// Revision 1.4  2003/04/09 20:44:29  garethc
// package org
//
// Revision 1.3  2003/03/11 20:21:16  garethc
// fixes and 2.5 enhancements
//
// Revision 1.2  2003/03/05 00:56:18  garethc
// lock list
//
// Revision 1.1  2003/02/02 19:41:25  garethc
// servlets
//
// Revision 1.5  2003/01/07 03:11:53  garethc
// beginning of big cleanup, taglibs etc
//
// Revision 1.4  2002/11/26 00:26:19  garethc
// fixes
//
// Revision 1.3  2002/11/15 03:31:44  garethc
// small fixes
//
// Revision 1.2  2002/11/10 23:53:02  garethc
// manual and plugins
//
// Revision 1.1  2002/11/01 03:12:43  garethc
// starting work on new two pass lexer
//