/**
 * Servlet for handling the uploading of attachments for topics. It's behaviour is
 * a bit different to the other servlets, in that the request parameters are hidden
 * in the multipart upload and forwarding through the WikiServlet doesn't work, so
 * the virtual wiki is extracted from a hidden input parameter in the form in attach.jsp.
 *
 * Copyright 2002 Gareth Cronin
 * This software is subject to the GNU Lesser General Public Licence (LGPL)
 */
package vqwiki.servlets;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.log4j.Logger;

import vqwiki.*;
import vqwiki.utils.JSPUtils;
import vqwiki.utils.Utilities;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SaveAttachmentServlet extends VQWikiServlet {
//protected static org.apache.log4j.Category cat = org.apache.log4j.Category.getInstance(SaveAttachmentServlet.class);
  protected static Logger cat = Logger.getLogger(SaveAttachmentServlet.class);

  private ServletConfig config;

  /**
   * Init the servlet
   */
  final public void init(ServletConfig config) throws ServletException {
    super.init(config);
    this.config = config;
  }

  protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
  	String requestCharacterEncoding = Utilities.extractCharacterEncoding(request);
  	String responseCharacterEncoding = Utilities.extractCharacterEncoding(response);

  	Environment en = Environment.getInstance();

    DiskFileUpload upload = new DiskFileUpload();
    String tempDir = Environment.relativeDirIfNecessary(en.getStringSetting(Environment.PROPERTY_TEMP_DIR));
    File tempDirFile = new File(tempDir);
    tempDirFile.mkdirs();
    upload.setRepositoryPath(
        tempDir
    );
    upload.setSizeMax(en.getIntSetting(Environment.PROPERTY_MAX_FILE_SIZE));
    List fileList = null;
    try {
      fileList = upload.parseRequest(request);
    }
    catch (FileUploadException e) {
      error(request, response, new WikiServletException(e.getMessage()));
      return;
    }

    String virtualWiki = null;
    String topic = null;
    String user = null;
    Topic t = null;
    boolean cancel = false;
    boolean update = false;
    String upType = null;
    
    try {
      for (Iterator iterator = fileList.iterator(); iterator.hasNext();) {
        FileItem item = (FileItem) iterator.next();
        if (item.isFormField()) {
          if (item.getFieldName().equals("topic")) {
            topic = JSPUtils.decodeURL(item.getString(), requestCharacterEncoding);
            t = new Topic(topic);
            if (t.isReadOnlyTopic(virtualWiki))
              throw new WikiException(WikiException.READ_ONLY);
          } else if (item.getFieldName().equals("user")) {
            user = item.getString();
          } else if (item.getFieldName().equals("virtualwiki")) {
            virtualWiki = item.getString();
          } else if (item.getFieldName().equals("update")) {
            update = true;
          } else if(item.getFieldName().equals("cancel")) {
            cancel = true;
          } else if (item.getFieldName().equals("attach") | item.getFieldName().equals("include") | item.getFieldName().equals("upload")) {
          	upType = item.getFieldName();
          }
        }
      }
      WikiBase base = WikiBase.getInstance();

      List notStored = null;
      if(!cancel) {
      	notStored = storeFiles(fileList, virtualWiki, en, update);
        // Update the topic
        StringBuffer contents = new StringBuffer(base.readRaw(virtualWiki, topic));
        for (Iterator iterator = fileList.iterator(); iterator.hasNext();) {
          FileItem item = (FileItem) iterator.next();
          if (!upType.equals("upload") & !item.isFormField() && !item.getName().equals("") && !notStored.contains(getNameOnly(item))) {
          	StringBuffer sb = new StringBuffer ();
          	if (upType.equals("attach")) {
          		sb.append("attach:");
          	} else {
          		sb.append("include:");
          	}
            if(item.getName().indexOf(' ') >= 0)
              sb.append("\"");
            sb.append(getNameOnly(item));
            if(item.getName().indexOf(' ') >= 0)
              sb.append("\"");
            String atString = sb.toString();
            if (contents.indexOf(atString) < 0) {
            	contents.append("\n");
            	contents.append(atString);
            	contents.append("\n");
            }
          }
        }
        Change change = new Change(virtualWiki, topic, user, new java.util.Date());
        ChangeLog cl = WikiBase.getInstance().getChangeLogInstance();
        base.write(virtualWiki, contents.toString(), false, topic, user);
        cl.logChange(change, request);
      }


     // Unlock and return
      base.unlockTopic(virtualWiki, topic);
      if ((notStored != null) && (notStored.size()>0)) {
      	throw new WikiServletException(WikiException.FILE_EXISTS, notStored.toString());
      }
      StringBuffer next = new StringBuffer();
      next.append(JSPUtils.createRootPath(request, virtualWiki, false));
      next.append("Wiki?");
      next.append(JSPUtils.encodeURL(topic, responseCharacterEncoding));
      response.sendRedirect(response.encodeRedirectURL(next.toString()));

    } catch(WikiServletException e) {
    	error(request, response, e);
    } catch (Exception e) {
    	e.printStackTrace();
    	throw new WikiServletException(e.toString());
    }  // end catch

  } // end doPost

  private List storeFiles(List fileList, String virtualWiki, Environment en, boolean update) throws IOException {
  	List notStored = new ArrayList ();
    for (Iterator iterator = fileList.iterator(); iterator.hasNext();) {
      FileItem item = (FileItem) iterator.next();
      log("FileItem: " + item);
      if (!item.isFormField() && !item.getName().equals("")) {
        String name = getNameOnly(item);
        File uploadedFile = en.uploadPath(virtualWiki, name);
        if (!update & uploadedFile.exists()) {
        	notStored.add(getNameOnly(item));
        }
        InputStream stream = item.getInputStream();
        FileOutputStream out = new FileOutputStream(uploadedFile);
        while (true) {
          int nextByte = stream.read();
          if (nextByte == -1) break;
          out.write(nextByte);
        }
        out.close();
        stream.close();
      }
    }
    return notStored;
  }

  private String getNameOnly(FileItem item) {
    String name = item.getName();
    // the absolute path seems to get uploaded in IE
    char lastChar = name.charAt(name.length() - 1);
    if (lastChar == '/' || lastChar == '\\')
      name = name.substring(0, name.length() - 1);
    if (name.indexOf('/') >= 0)
      name = name.substring(name.lastIndexOf('/') + 1);
    else if (name.indexOf('\\') >= 0)
      name = name.substring(name.lastIndexOf('\\') + 1);
    return name;
  }


}
