package vqwiki.servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import vqwiki.Environment;
import vqwiki.PrintableEntry;
import vqwiki.WikiBase;
import vqwiki.PseudoTopicHandler;
import vqwiki.utils.Utilities;
import vqwiki.utils.JSPUtils;


/**
 * Create a printable view of one servlet.
 *
 * @author garethc, Tobias Schulz-Hess (sourcefoge@schulz-hess.de)
 * Date: Jan 8, 2003
 */
public class PrintableServlet
    extends VQWikiServlet {

  /**
   * Handle get request
   *
   * @param request The servlet request
   * @param response The servlet response
   *
   * @throws ServletException If something went wrong with the servlet
   * @throws IOException If the servlet cannot print
   */
  protected void doGet(HttpServletRequest request,
                       HttpServletResponse response)
      throws ServletException, IOException {
    String topic = request.getParameter("topic");
    String virtualWiki = (String) request.getAttribute("virtualWiki");
    request.setAttribute("topic", topic);
    request.setAttribute("title", topic);
    String strDepth = request.getParameter("depth");

    if(request.getParameter("hideform") != null){
      request.setAttribute("hideform", "true");
    }

    int depth = 0;

    try {
      depth = Integer.parseInt(strDepth);
    }
    catch (NumberFormatException e1) {
      depth = 0;
    }
    request.setAttribute("depth", String.valueOf(depth));
    
    Environment en = Environment.getInstance();

    String contextPath = request.getContextPath();
    en.setBaseContext(contextPath);

    ArrayList result = new ArrayList();

    Vector alreadyVisited = new Vector();

    try {
      result.addAll(parsePage(Utilities.getMessages(request.getLocale()), en, virtualWiki, topic, depth, alreadyVisited));

    }
    catch (Exception e) {
      error(request, response, e);
      return;
    }

    // now go through all pages and replace
    // all href=Wiki? with href=# for the
    // pages in the alreadyVisited vector
    for (Iterator iter = result.iterator(); iter.hasNext();) {
      PrintableEntry element = (PrintableEntry) iter.next();
      for (Iterator visitedIterator = alreadyVisited.iterator(); visitedIterator.hasNext();) {
        String visitedTopic = (String) visitedIterator.next();
        element.setContent(Utilities.replaceString(element.getContent(),
                                                   "href=\"Wiki?" + visitedTopic, "href=\"#" + visitedTopic));
      }
    }


    // put the result in the request
    request.setAttribute("contentList", result);
    
  	WikiBase wb = null;
  	try {
  		wb = WikiBase.getInstance();
  	} catch (Exception e) {};
    
    request.setAttribute("notEntryPage", Boolean.toString(!topic.equals(wb.getVirtualWikiHome(virtualWiki))));
    dispatch("/jsp/printable.jsp", request, response);
  }

  /**
   * Parse page and supages
   * @param virtualWiki The virutal wiki to use
   * @param topic The topic to start with
   * @param depth The depth to go into
   * @return Collection of pages
   */
  private Collection parsePage(ResourceBundle messages, Environment en, String virtualWiki, String topic, int depth, Vector alreadyVisited)
      throws Exception {
    WikiBase base = WikiBase.getInstance();
    String onepage = base.readCooked(virtualWiki, topic, WikiBase.PRINT);

    Collection result = new ArrayList();

    if (onepage != null) {
      PrintableEntry entry = new PrintableEntry();
      entry.setTopic(topic);
      entry.setTopicName(Utilities.replaceString(JSPUtils.encodeURL(topic, JSPUtils.DEFAULTENCODING), "%", "$"));
      entry.setContent(onepage);

      result.add(entry);
      alreadyVisited.add(topic);

      if (depth > 0) {
      	
//      String searchfor = "href=\"Wiki?";
        String searchfor = "<a href=\"#";
        int iPos = onepage.indexOf(searchfor);
        int iEndPos = onepage.indexOf(messages.getString("topic.ismentionedon"));
        if (iEndPos == -1) iEndPos = Integer.MAX_VALUE;

        while (iPos > -1 && iPos < iEndPos) {
          String link = onepage.substring(iPos + searchfor.length(),
                                          onepage.indexOf('"', iPos + searchfor.length()));
//        if (link.indexOf('&') > -1) {
//        link = link.substring(0, link.indexOf('&'));
//        }
          // link = Utilities.decodeSafeURL(link);
          // the <a href="#...">-link is encoded twice, otherwise ... will not work with <a name="...">
          link = Utilities.replaceString(link, "$", "%");
          link = JSPUtils.decodeURL(link, JSPUtils.DEFAULTENCODING);          
          if (link.length() > 3 &&
//            !link.startsWith("topic=") &&
//            !link.startsWith("action=") &&
              !alreadyVisited.contains(link) &&
              !PseudoTopicHandler.getInstance().isPseudoTopic(link)) {
            result.addAll(parsePage(messages, en, virtualWiki, link, (depth - 1), alreadyVisited));
          }

          iPos = onepage.indexOf(searchfor, iPos + 10);
        }
      }
    }

    return result;
  }
}
