/**
 * @author Tobias Schulz-Hess (sourceforge@schulz-hess.de)
 *  12/04/2003 20:33:31
 */
package vqwiki.servlets;
 
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
 
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
 
import org.apache.log4j.Logger;
 
import vqwiki.Environment;
import vqwiki.PseudoTopicHandler;
import vqwiki.SearchEngine;
import vqwiki.SearchResultEntry;
import vqwiki.Topic;
import vqwiki.WikiBase;
import vqwiki.servlets.beans.SitemapLineBean;
import vqwiki.utils.Utilities;
import TemplateEngine.Template;
 
/*
Very Quick Wiki - WikiWikiWeb clone
Copyright (C) 2001-2002 Gareth Cronin
 
This program is free software; you can redistribute it and/or modify
it under the terms of the latest version of the GNU Lesser General
Public License as published by the Free Software Foundation;
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public License
along with this program (gpl.txt); if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
 
/**
 * This servlet exports all pages as static HTML-pages.
 * You can add a parameter "virutal-wiki", which then generates
 * the HTML pages on a particular virtual wiki.<p>
 *
 * @author Tobias Schulz-Hess (sourceforge@schulz-hess.de)
 */
public class ExportHTMLServlet extends LongLastingOperationServlet {
 
      private File tempFile;
 
      private String tempdir;
 
      /** Logging */
      private static final Logger logger = Logger.getLogger(ExportHTMLServlet.class);
 
      private String virtualWiki = null;
 
      private String imageDir = null;
 
      private Exception exception;

      private static final String TOPAREA = "TOPAREA";
      private static final String TopArea = "TopArea";
      private static final String LEFTMENU = "LEFTMENU";
      private static final String LeftMenu = "LeftMenu";
      private static final String BOTTOMAREA = "BOTTOMAREA";
      private static final String BottomArea = "BottomArea";
      
      private static final String VERSION = "VERSION";
      private static final String TOPICNAME = "TOPICNAME";
      private static final String AUTHOR = "AUTHOR";
      private static final String MODIFYDATE = "MODIFYDATE";
      private static final String MODIFYHTMLDATE = "MODIFYHTMLDATE";
      private static final String MODIFYHTTPDATE = "MODIFYHTTPDATE";
      private static final String EXPORTDATE = "EXPORTDATE";
      private static final String SHOWVERSIONING1 = "SHOWVERSIONING1";
      private static final String SHOWVERSIONING2 = "SHOWVERSIONING2";
      private static final String TITLE = "TITLE";
      private static final String FILENAME = "FILENAME";
      private static final String WIKISEARCH = "WikiSearch";
      
      private static final String redirect = "redirect:";
      private static final String redirectQ = "redirect:\"";
      private static final String REDIRECT = "REDIRECT";
      
      private static final String dateFormatString = "yyyy-MM-dd HH:mm:ss";
      private static final String httpDateFormatString = "EEE, dd MMM yyyy HH:mm:ss z";
      private static final String htmlDateFormatString = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
  	  private static final String IMAGEATTACH = ".gif.jpg.png.jpeg.bmp";
  	  private static final String DOCSPATH = "docs/";
	  private static final String GRAPHSPATH = "graphics/";
      
      private static final String [] libs = {"vqapplets.jar", "log4j-1.2.12.jar", "lucene-1.2a.jar"};
      

      
      /**
       * Handle post request.
       * Generate a node file and send it back as text.
       *
       * @param request  The current http request
       * @param response What the servlet will send back as response
       *
       * @throws ServletException If something goes wrong during servlet execution
       * @throws IOException If the output stream cannot be accessed
       *
       */
      protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
       
      	virtualWiki = (String) request.getAttribute("virtualWiki");
 
        ServletContext ctx = getServletContext();
        try {
            File tmpDir = (File) ctx.getAttribute("javax.servlet.context.tempdir");
            tempdir = tmpDir.getPath();
        } catch (Throwable t) {
            logger.warn("'javax.servlet.context.tempdir' attribute undefined or invalid, using java.io.tmpdir", t);
            tempdir = System.getProperty("java.io.tmpdir");
        }
        imageDir = getServletContext().getRealPath("/images");
        super.doPost(request, response);
      }
 
      /**
       * Do the long lasting operation
       */
      public void run() {
            Environment en = Environment.getInstance();
            exception = null;
 
            BufferedOutputStream fos = null;
 
            try {

                  WikiBase.getInstance().getSearchEngineInstance().lockIndexer();
          	  
                  tempFile = File.createTempFile("HTML-Export-", ".zip", new File(tempdir));
 
                  fos = new BufferedOutputStream(new FileOutputStream(tempFile));
 
                  //bos = new ByteArrayOutputStream();
                  ZipOutputStream zipout = new ZipOutputStream(fos);
 
                  zipout.setMethod(ZipOutputStream.DEFLATED);

                  addAllTopicsAndUploaded(en, zipout, 0, 80);
                  addAllSpecialPages(en, zipout, 80, 10);
                  // addAllUploadedFiles(en, zipout, 60, 30);
                  addAllImages(en, zipout, 90, 10);
                  
                  zipout.flush();
 
                  zipout.close();
                  
                  fos.close();
                  
                  logger.debug("Closing zip and sending to user");

                  WikiBase.getInstance().getSearchEngineInstance().releaseIndexer();
 
            } catch (Exception e) {
                  logger.fatal("Exception", e);
                  exception = e;
                  try {
                    WikiBase.getInstance().getSearchEngineInstance().releaseIndexer();
                  } catch (Exception e2) {}
                  
            } finally {
                  ;
            }
 
            progress = PROGRESS_DONE;
      }
 
      private void setField (List templateList, String keyword, String value) {
      	for (int i = 0; i < templateList.size(); i++) {
      		Template tpl = (Template) templateList.get(i);
      		tpl.setFieldGlobal(keyword, value);
      	}
      }
      
      private void contentToZip (ZipOutputStream zipout, String filename, String content) {
      	try {
	        ZipEntry entry = new ZipEntry(filename);
	        StringReader contentIn = new StringReader(content);
	        zipout.putNextEntry(entry);
	
	        // Hinzufuegen der Daten zum neuen Eintrag
	        int read = 0;
	        while ((read = contentIn.read()) != -1)
	             zipout.write(read);
	        zipout.closeEntry(); // Neuen Eintrag abschliessen
	        zipout.flush();
	        contentIn.close();
        } catch (IOException e) {
            logger.warn("Content to ZIP: IOException!", e);
            try {
                 zipout.closeEntry();
                 zipout.flush();
            } catch (IOException e1) {}
      }
	        
 
      }
      
      private void addAllTopicsAndUploaded(Environment en, ZipOutputStream zipout, int progressStart, int progressLength) throws Exception, IOException {
	 
	            HashMap containingTopics = new HashMap();

	          	StringBuffer robots = new StringBuffer ();
	          	robots.append("# robots.txt"); robots.append("\n\n");
	          	robots.append("User-agent: *"); robots.append("\n");
           	 	robots.append("Disallow: /"); robots.append(WIKISEARCH); robots.append(".html\n");
	 
	            if (virtualWiki == null || virtualWiki.length() < 1) {
	                  virtualWiki = WikiBase.DEFAULT_VWIKI;
	            }
	 
	            WikiBase wb = WikiBase.getInstance();
	            SearchEngine sedb = wb.getSearchEngineInstance();
	             
	            String defaultTopic = wb.getVirtualWikiHome(virtualWiki);
	
	            Template tpl = null;
	            Template tplPrint = null;
	            
	            List templateList = new ArrayList ();
	            
	            logger.debug("Logging Wiki " + virtualWiki + " starting at " + defaultTopic);
	 
	            List ignoreTheseTopicsList = new ArrayList();
	            ignoreTheseTopicsList.add(WIKISEARCH);
	            ignoreTheseTopicsList.add("RecentChanges");
	            ignoreTheseTopicsList.add("WikiSiteMap");
	            ignoreTheseTopicsList.add("WikiSiteMapIE");
	            ignoreTheseTopicsList.add("WikiSiteMapNS");
	            
	            ignoreTheseTopicsList.add(LeftMenu);
	            ignoreTheseTopicsList.add(BottomArea);
	            ignoreTheseTopicsList.add(TopArea);
	 
	            int count = 0;
	
	            // get TopArea           
	            StringBuffer topArea = new StringBuffer();
	            try {
	                  topArea.append(wb.readCooked(virtualWiki, TopArea, en.getStringSetting(Environment.PROPERTY_FORMAT_LEXER), en.getStringSetting(Environment.PROPERTY_LAYOUT_LEXER), en.getStringSetting(Environment.PROPERTY_LINK_LEXER), WikiBase.EXPORT));
	                  logger.debug("TopArea read.");
	                  try {
	                        int logo = topArea.indexOf("../images/");
	                        topArea.replace(logo, logo + 3, "");
	                  } catch (RuntimeException e1) {
	                        //e1.printStackTrace();
	                  }
	            } catch (Exception e) {
	                  logger.debug("TopArea " + e.getMessage());
	            }
	            // get LeftMenu
	            StringBuffer leftMenu = new StringBuffer();
	            try {
	                  leftMenu.append(wb.readCooked(virtualWiki, LeftMenu, en.getStringSetting(Environment.PROPERTY_FORMAT_LEXER), en.getStringSetting(Environment.PROPERTY_LAYOUT_LEXER), en.getStringSetting(Environment.PROPERTY_LINK_LEXER), WikiBase.EXPORT));
	                  logger.debug("LeftMenu read");
	            } catch (Exception e) {
	                  logger.debug("LeftMenu " + e.getMessage());
	            }
	
	            // get BottomArea
	            StringBuffer bottomArea = new StringBuffer();
	            try {
	                  bottomArea.append(wb.readCooked(virtualWiki, BottomArea, en.getStringSetting(Environment.PROPERTY_FORMAT_LEXER), en.getStringSetting(Environment.PROPERTY_LAYOUT_LEXER), en.getStringSetting(Environment.PROPERTY_LINK_LEXER), WikiBase.EXPORT));
	                  logger.debug("BottomArea read");
	            } catch (Exception e) {
	                  logger.debug("BottomArea " + e.getMessage());
	            }
	            
	            List reachedTopics = new ArrayList ();
	            List reachedDocs = new ArrayList ();
	            wb.getEverythingFromStart (virtualWiki, WikiBase.EXPORT, reachedTopics, reachedDocs);
				int totalFiles = reachedTopics.size() + reachedDocs.size();

	            Collection all = reachedTopics;
	            Iterator allIterator = all.iterator();
	            
	            java.util.Date now = new Date ();
	            SimpleDateFormat sdf = new SimpleDateFormat (dateFormatString);
	            SimpleDateFormat htmlDf =  new SimpleDateFormat(htmlDateFormatString, Locale.US);
	            SimpleDateFormat httpDf = new SimpleDateFormat(httpDateFormatString, Locale.US);
	            
	            while (allIterator.hasNext()) {
	                  progress = Math.min(progressStart + (int) ((double) count * (double) progressLength / (double) totalFiles), 99);
	                  count++;
	                  String topicname = (String) allIterator.next();
	                  String filename = Utilities.encodeSafeURL(topicname) + ".html";
	                  
                      if (topicname.equals(defaultTopic)) {
                      	tpl = new Template (wb.readRaw(virtualWiki, "HomeTemplate").getBytes());
                      	tplPrint = new Template (wb.readRaw(virtualWiki, "HomeTemplatePrint").getBytes());
                      } else {
                      	tpl = new Template (wb.readRaw(virtualWiki, "MasterTemplate").getBytes());
                      	tplPrint = new Template (wb.readRaw(virtualWiki, "MasterTemplatePrint").getBytes());
                      }
                      templateList.add(tpl);
                      templateList.add(tplPrint);
                      
	                  setField(templateList, VERSION, Environment.WIKI_VERSION);
	                  setField(templateList, BOTTOMAREA, bottomArea.toString());
	                  setField(templateList, TOPAREA, topArea.toString());
	                  setField(templateList, LEFTMENU, leftMenu.toString());
	                  setField(templateList, FILENAME, filename);
	                  
	                  StringBuffer oneline = new StringBuffer();
	 
	                  if (!ignoreTheseTopicsList.contains(topicname)) {
	                        oneline.append(topicname);
	 
	                        if (!topicname.equals(defaultTopic)) {	 
	                        	setField(templateList, TOPICNAME, topicname);
	                        	setField(templateList, TITLE, topicname);
	                        } else {
	                        	setField(templateList, TOPICNAME, topicname);
	                        	setField(templateList, TITLE, wb.getVirtualWikiHomeTitle(virtualWiki));
	                        }
	 
	                        Topic topicObject = new Topic(topicname);
	 
	                        logger.debug("Adding topic " + topicname);
	 
	                        String author = null;
	                        java.util.Date lastRevisionDate = null;
	 
	                        setField(templateList, EXPORTDATE, sdf.format(now));
	                        setField(templateList, MODIFYHTTPDATE, httpDf.format(now));
	                        setField(templateList, MODIFYHTMLDATE, htmlDf.format(now));
	                        
	                        if (Environment.getInstance().isVersioningOn()) {
	                             lastRevisionDate = topicObject.getMostRecentRevisionDate(virtualWiki);
	                             author = topicObject.getMostRecentAuthor(virtualWiki);
	                             if (author != null || lastRevisionDate != null) {
	                             	setField(templateList, SHOWVERSIONING1, "-->");
	                                   if (author != null) {
	                                   		setField(templateList, AUTHOR, author);
	                                   }
	                                   if (lastRevisionDate != null) {
	                                   		setField(templateList, MODIFYDATE, sdf.format(lastRevisionDate));
	                                   }
	                                   setField(templateList, SHOWVERSIONING2, "<!--");
	                             }
	                        }
	 
	                        // get content
	                        StringBuffer content = new StringBuffer();
	 
	                        Map templateParams  = new HashMap ();
	                        content.append(wb.readCooked(virtualWiki, topicname, en.getStringSetting(Environment.PROPERTY_FORMAT_LEXER), en.getStringSetting(Environment.PROPERTY_LAYOUT_LEXER),  en.getStringSetting(Environment.PROPERTY_LINK_LEXER), WikiBase.EXPORT, templateParams));
	                        
	                        for (Iterator it = templateParams.keySet().iterator(); it.hasNext(); ) {
	                        	String key = (String) it.next();
	                        	String value = (String) templateParams.get(key);
	                        	setField(templateList, key, value);
	                        }
	 
	                        // handle redirects
	                        String tempCont = content.toString();
	                        String redirTopic = null;
	                        if (tempCont.startsWith(redirect)) {	                        	
		                         StringTokenizer st = new StringTokenizer(tempCont, "\n\r");
		                         tempCont = st.nextToken();
		                         if (tempCont.indexOf("<br/>") >= 0) {
		                         	tempCont = tempCont.substring(0, tempCont.indexOf("<br/>")).trim();
		                         }		                         
	                        	 if (tempCont.startsWith(redirectQ)) {
	                            	int first = tempCont.indexOf("\"");
	                           		int last = tempCont.lastIndexOf("\"");
	                            	if (first != last) {
	                            		redirTopic=tempCont.substring (first + 1, last);
	                            	} else {
	                            		redirTopic=null;
	                            	}    		
	                        	 } else if (tempCont.trim().indexOf(" ") < 0) { // watch out for case where a space has been left
	                        	 	redirTopic = tempCont.substring(tempCont.indexOf(":") + 1).trim();
	                        	 } else {
	                        	 	redirTopic = tempCont.substring(tempCont.indexOf(":") + 1, tempCont.indexOf(" ")).trim();    		
	                        	 }
		                         
		                      	 if (wb.exists(virtualWiki, redirTopic)) {
	          	                    String redirFilename = Utilities.encodeSafeURL(redirTopic) + ".html";
	                        	 	String nl = System.getProperty("line.separator");
	                        	 	setField(templateList, REDIRECT, "<script>" + nl + "location.replace(\"" + redirFilename + "\");" + nl + "</script>" + nl + "<meta http-equiv=\"refresh\" content=\"1; " + redirFilename + "\"/>" + nl);
	                        	 } else {
		                        	setField(templateList, REDIRECT, "");
	                        	 	
	                        	 }
	                        } else {
	                        	setField(templateList, REDIRECT, "");
	                        }
	                       
	                        // add referrer pages
	                        Collection searchresult = sedb.findLinkedTo(virtualWiki, topicname, WikiBase.EXPORT);
	                        if (searchresult != null && searchresult.size() > 0) {
	                             Iterator it = searchresult.iterator();
	                             String divider = "";
	                             StringBuffer backlinks = new StringBuffer();
	                             for (; it.hasNext();) {
	                                   SearchResultEntry result = (SearchResultEntry) it.next();
	                                   if ((!result.getTopic().equals(topicname)) && (reachedTopics.contains(result.getTopic())) && (!ignoreTheseTopicsList.contains(result.getTopic()))) {
	                                         backlinks.append(divider);
	                                         backlinks.append("<a href=\"");
	                                         backlinks.append(Utilities.encodeSafeURL(result.getTopic()));
	                                         backlinks.append(".html\">");
	                                         backlinks.append(result.getTopic());
	                                         backlinks.append("</a>");
	                                         divider = " | ";
	 
	                                         // add this topic to the containingTopics Map:
	                                         List l = (List) containingTopics.get(result.getTopic());
	                                         if (l == null)
	                                               l = new ArrayList();
	                                         if (!l.contains(topicname))
	                                               l.add(topicname);
	                                         containingTopics.put(result.getTopic(), l);
	                                   }
	                             }
	                             StringBuffer backContent = new StringBuffer();
	                             if (backlinks.length() > 0) {
	                                   ResourceBundle messages = Utilities.getMessages(locale);
	 
	                                   backContent.append("\"");
	                                   backContent.append(topicname);
	                                   backContent.append("\" ");
	                                   backContent.append(messages.getString("topic.ismentionedon"));
	                                   backContent.append(" ");                    
	                                   backContent.append(backlinks.toString());
	                             }
	 	                        setField(templateList, "BACKLINKS", backContent.toString());
	                        }
	 
	                        setField(templateList, "CONTENTS", content.toString());
	 
	                   	 	contentToZip (zipout, filename, tpl.getContent());
	                   	 	contentToZip (zipout, "$"+filename, tplPrint.getContent());
	                   	 	robots.append("Disallow: /$"); robots.append(filename); robots.append("\n");
	                   	 		 
	                        if (topicname.equals(defaultTopic)) {
		                   	 	contentToZip (zipout, "index.html", tpl.getContent());
		                   	 	contentToZip (zipout, "$index.html", tpl.getContent());
	                        }
	                  }
	            }
	            	 
	            logger.debug("Done adding all topics.");
	            
	            // contentToZip (zipout, "robots.txt", robots.toString());
	
	            // add all attachments
	            File uploadPath = en.uploadPath(virtualWiki, "");
	            int bytesRead = 0;
	            byte byteArray[] = new byte[4096];
	 
	            for (int i = 0; i < reachedDocs.size(); i++) {
	                  progress = Math.min(progressStart + (int) ((double) count   * (double) progressLength / (double) totalFiles), 99);
	                  count++;
	                  
	                  String doc = (String) reachedDocs.get(i);
	                  File docFile = new File (uploadPath.getAbsolutePath(), doc);
	                  logger.debug("Adding uploaded file " + doc);
	 
	                  StringTokenizer st = new StringTokenizer (doc, "/:\\");
	                  StringBuffer sb = new StringBuffer();
	                  boolean first = true;
	                  boolean slash = false;    
	              
	                  while (st.hasMoreElements()) {
	                  	if (!first) { 
	                  		sb.append("/");
	                  		slash = true;
	                  	} else { 
	                  		first = false; 
	                  	}
	                  	sb.append(Utilities.encodeSafeURL(st.nextToken()));
	                  }
	                  String docPath = sb.toString();
	                  if (!slash) {
	  				     if (docPath.lastIndexOf(".") < 0 ) {
	  		                   docPath = DOCSPATH + docPath;                   		  	                	  
	  				     } else if (IMAGEATTACH.indexOf(docPath.substring(docPath.lastIndexOf(".")).toLowerCase()) < 0) {
		                	  docPath = DOCSPATH + docPath;                   		  
	                	  } else {
	                		  docPath = GRAPHSPATH + docPath;
	                	  }
	                  }
	                  
	                  ZipEntry entry = new ZipEntry(docPath);                  
	 
	                  FileInputStream docFileIn = null;
	                  try {
	                  	docFileIn = new FileInputStream(docFile);
	                        zipout.putNextEntry(entry);
	 
	                        // Read in bytes through file stream, and write out through servlet stream
	                        while (docFileIn.available() > 0) {
	                             bytesRead = docFileIn.read(byteArray, 0, Math.min(4096, docFileIn.available()));
	                             zipout.write(byteArray, 0, bytesRead);
	                        }
	                        zipout.closeEntry();
	                        zipout.flush();
	                        docFileIn.close();
	                  } catch (FileNotFoundException e) {
	                        logger.warn("Could not open file!", e);
	                  } catch (IOException e) {
	                        logger.warn("IOException!", e);
	                        try {
	                             zipout.closeEntry();
	                             zipout.flush();
	                             docFileIn.close();
	                        } catch (IOException e1) {
	                             ;
	                        }
	                  }
	            }
	            
	            
	            
	      }
 
 
      /**
       * Parse the pages starting with startTopic. The results
       * are stored in the list sitemapLines. This functions is
       * called recursivly, but the list is filled in the
       * correct order.
       *
       * @param currentWiki  name of the wiki to refer to
       * @param startTopic  Start with this page
       * @param level   A list indicating the images to use to represent certain levels
       * @param group The group, we are representing
       * @param sitemapLines  A list of all lines, which results in the sitemap
       * @param visitedPages  A vector of all pages, which already have been visited
       * @param endString Beyond this text we do not search for links
       */
      private void parsePages(String topic, HashMap wiki, List levelsIn, String group, List sitemapLines, Vector visitedPages) {
            try {
                  List result = new ArrayList();
 
                  List levels = new ArrayList(levelsIn.size());
                  for (int i = 0; i < levelsIn.size(); i++) {
                        if ((i + 1) < levelsIn.size()) {
                             if (SitemapServlet.MORE_TO_COME.equals((String) levelsIn.get(i))) {
                                   levels.add(SitemapServlet.HORIZ_LINE);
                             } else if (SitemapServlet.LAST_IN_LIST.equals((String) levelsIn.get(i))) {
                                   levels.add(SitemapServlet.NOTHING);
                             } else {
                                   levels.add(levelsIn.get(i));
                             }
                        } else {
                             levels.add(levelsIn.get(i));
                        }
                  }
 
                  List l = (List) wiki.get(topic);
                  if (l == null) {
                        // topic is empty, but need to be shown!
                        l = new ArrayList();
                  }
 
                  for (Iterator listIterator = l.iterator(); listIterator.hasNext();) {
                        String link = (String) listIterator.next();
                        if (link.indexOf('&') > -1) {
                             link = link.substring(0, link.indexOf('&'));
                        }
                        if (link.length() > 3 && !link.startsWith("topic=") && !link.startsWith("action=") && !visitedPages.contains(link) && !PseudoTopicHandler.getInstance().isPseudoTopic(link)) {
                             result.add(link);
                             visitedPages.add(link);
                        }
 
                  }
 
                  // add a sitemap line
                  SitemapLineBean slb = new SitemapLineBean();
                  slb.setTopic(topic);
                  slb.setLevels(new ArrayList(levels));
                  slb.setGroup(group);
                  slb.setHasChildren(result.size() > 0);
                  sitemapLines.add(slb);
 
                  for (int i = 0; i < result.size(); i++) {
                        String link = (String) result.get(i);
                        String newGroup = group + "_" + String.valueOf(i);
                        boolean isLast = ((i + 1) == result.size());
                        if (isLast) {
                             levels.add(SitemapServlet.LAST_IN_LIST);
                        } else {
                             levels.add(SitemapServlet.MORE_TO_COME);
                        }
                        parsePages(link, wiki, levels, newGroup, sitemapLines, visitedPages);
                        levels.remove(levels.size() - 1);
                  }
            } catch (Exception e) {
                  logger.fatal("Exception", e);
            }
      }
 
      private void addAllSpecialPages(Environment en, ZipOutputStream zipout, int progressStart, int progressLength) throws Exception, IOException {
 
            if (virtualWiki == null || virtualWiki.length() < 1) {
                  virtualWiki = WikiBase.DEFAULT_VWIKI;
            }
 
            ResourceBundle messages = Utilities.getMessages(locale);
 
            WikiBase wb = WikiBase.getInstance();
            SearchEngine sedb = wb.getSearchEngineInstance();
 
            Template tpl;
 
            int count = 0;
            int numberOfSpecialPages = 7;
            int bytesRead = 0;
            byte[] byteArray = new byte[4096];
 
            // -----------------------------------------------------------
            // add style sheet
            progress = Math.min(progressStart + (int) ((double) count * (double) progressLength / (double) numberOfSpecialPages), 99);
            count++;
 
            ZipEntry entry = new ZipEntry("vqwiki.css");
            zipout.putNextEntry(entry);
 
            InputStream in = new BufferedInputStream(new FileInputStream(this.getServletContext().getRealPath("/vqwiki.css")));
            String styleSheet = wb.readRaw(virtualWiki, "StyleSheet");
            zipout.write(styleSheet.getBytes());
            
            zipout.closeEntry();
            zipout.flush();
 
            // -----------------------------------------------------------
            // add search page
            progress = Math.min(progressStart + (int) ((double) count * (double) progressLength / (double) numberOfSpecialPages), 99);
            count++;
 
            
            // read layout-elements
            // get topArea
            StringBuffer topArea = new StringBuffer();
            String TOPAREA = "TOPAREA";
            String TopArea = "TopArea";
            try {
                  topArea.append(wb.readCooked(virtualWiki, TopArea, en.getStringSetting(Environment.PROPERTY_FORMAT_LEXER), en.getStringSetting(Environment.PROPERTY_LAYOUT_LEXER), en.getStringSetting(Environment.PROPERTY_LINK_LEXER), WikiBase.EXPORT));
                  logger.debug("TopArea read.");
                  try {
                        int logo = topArea.indexOf("../images/");
                        topArea.replace(logo, logo + 3, "");
                  } catch (RuntimeException e1) {
                        //e1.printStackTrace();
                  }
            } catch (Exception e) {
                  logger.debug("TopArea " + e.getMessage());
            }
            // get LeftMenu
            StringBuffer leftMenu = new StringBuffer();
            String LEFTMENU = "LEFTMENU";
            String LeftMenu = "LeftMenu";
            try {
                  leftMenu.append(wb.readCooked(virtualWiki, LeftMenu, en.getStringSetting(Environment.PROPERTY_FORMAT_LEXER), en.getStringSetting(Environment.PROPERTY_LAYOUT_LEXER), en.getStringSetting(Environment.PROPERTY_LINK_LEXER), WikiBase.EXPORT));
                  logger.debug("LeftMenu read");
            } catch (Exception e) {
                  logger.debug("LeftMenu " + e.getMessage());
            }
            // get BottomArea
            StringBuffer bottomArea = new StringBuffer();
            String BOTTOMAREA = "BOTTOMAREA";
            String BottomArea = "BottomArea";
            try {
                  bottomArea.append(wb.readCooked(virtualWiki, BottomArea, en.getStringSetting(Environment.PROPERTY_FORMAT_LEXER), en.getStringSetting(Environment.PROPERTY_LAYOUT_LEXER), en.getStringSetting(Environment.PROPERTY_LINK_LEXER), WikiBase.EXPORT));
                  logger.debug("BottomArea read");
            } catch (Exception e) {
                  logger.debug("BottomArea " + e.getMessage());
            }

            Map map = new HashMap ();

            map.put("@@SEARCHSEARCH@@", Utilities.resource("search.search", locale, "Search"));
            map.put("@@SEARCHFOR@@", Utilities.resource("search.for", locale, "Search for:&nbsp;"));
            map.put("@@SEARCHHINTS@@", Utilities.resource("search.hints", locale, ""));
            map.put("@@SEARCHPROGRESS@@", Utilities.resource("search.progress", locale, "Search in progress..."));

            tpl = getTemplateFilledWithContent(virtualWiki, "search", map);
            tpl.setFieldGlobal(TOPICNAME, WIKISEARCH);
            tpl.setFieldGlobal(TITLE, WIKISEARCH);
            tpl.setFieldGlobal(BOTTOMAREA, bottomArea.toString());
            tpl.setFieldGlobal(TOPAREA, topArea.toString());
            tpl.setFieldGlobal(LEFTMENU, leftMenu.toString());
            tpl.setFieldGlobal(VERSION, Environment.WIKI_VERSION);
            tpl.setFieldGlobal(FILENAME, WIKISEARCH + ".html");
            

            String cont = tpl.getContent();
            
            entry = new ZipEntry("WikiSearch.html");
            StringReader strin = new StringReader(cont);
 
            // Add new entry to zip archive
            zipout.putNextEntry(entry);
 
            // Add data to new entry
            while ((bytesRead = strin.read()) != -1)
                  zipout.write(bytesRead);
            zipout.closeEntry(); // Close this entry
            zipout.flush();
 
            // -----------------------------------------------------------
            // add index page
            progress = Math.min(progressStart + (int) ((double) count * (double) progressLength / (double) numberOfSpecialPages), 99);
            count++;
 
            for (int i = 0; i < libs.length; i++) {
                entry = new ZipEntry("applets/"+libs[i]);
                zipout.putNextEntry(entry);
                if (i==0) {
                	in = new BufferedInputStream(new FileInputStream(this.getServletContext().getRealPath("/WEB-INF/classes/export2html/"+libs[i])));
                } else {
                    in = new BufferedInputStream(new FileInputStream(this.getServletContext().getRealPath("/WEB-INF/lib/"+libs[i])));                	
                }
                // Read in bytes through file stream, and write out through servlet stream
                while (in.available() > 0) {
                      bytesRead = in.read(byteArray, 0, Math.min(4096, in.available()));
                      zipout.write(byteArray, 0, bytesRead);
                }
                zipout.closeEntry();
                zipout.flush();
            	
            }
            
            try {
                  ByteArrayOutputStream bos = new ByteArrayOutputStream();
                  JarOutputStream indexjar = new JarOutputStream(bos);
                  JarEntry jarEntry;
                  File searchDir = new File(WikiBase.getInstance().getSearchEngineInstance().getSearchIndexPath(virtualWiki));
                  String files[] = searchDir.list();
                  StringBuffer listOfAllFiles = new StringBuffer();
                  
                  for (int i = 0; i < files.length; i++) {
                        if (listOfAllFiles.length() > 0)
                             listOfAllFiles.append(",");
                        listOfAllFiles.append(files[i]);
                        jarEntry = new JarEntry("lucene/index/" + files[i]);
                        indexjar.putNextEntry(jarEntry);
                        File file = new File(searchDir, files[i]);
                        in = new FileInputStream(file);
 
                        // Read in bytes through file stream, and write out through servlet stream
                        while (in.available() > 0) {
                             bytesRead = in.read(byteArray, 0, Math.min(4096, in.available()));
                             indexjar.write(byteArray, 0, bytesRead);
                        }
                        //UR:
                        in.close();
                        indexjar.closeEntry();

                  }
                  
                  indexjar.flush();
                  jarEntry = new JarEntry("lucene/index.dir");
                  strin = new StringReader(listOfAllFiles.toString());
                  indexjar.putNextEntry(jarEntry);
                  while ((bytesRead = strin.read()) != -1)
                        indexjar.write(bytesRead);
                  indexjar.closeEntry();
                  indexjar.flush();

                  
                  jarEntry = new JarEntry("lucene/visible.txt");
   	              List reachedTopics = new ArrayList ();
	              List reachedDocs = new ArrayList ();
	              wb.getEverythingFromStart (virtualWiki, WikiBase.EXPORT, reachedTopics, reachedDocs);
                  
                  List interest = reachedTopics;
                  indexjar.putNextEntry(jarEntry);
                  for (int i = 0; i < interest.size(); i++) {
                  	String nextTopic = (String)interest.get(i) + "\r\n";
                  	indexjar.write(nextTopic.getBytes());
                  }
                  indexjar.closeEntry();
                  indexjar.flush();
                  
                  indexjar.close();
                  
 
                  entry = new ZipEntry("applets/index.jar");
                  zipout.putNextEntry(entry);
                  zipout.write(bos.toByteArray());
                  zipout.closeEntry();
                  zipout.flush();
                  bos.reset();
            } catch (Exception e) {
                  logger.debug("Exception while adding lucene index: ", e);
            }
 
            // -----------------------------------------------------------
            // add recent changes
            /*
            progress = Math.min(progressStart + (int) ((double) count * (double) progressLength / (double) numberOfSpecialPages), 99);
            count++;
 
            tpl = new Template(this.getServletContext().getRealPath("/WEB-INF/classes/export2html/mastertemplate.tpl"));
 
            tpl.setFieldGlobal("VERSION", Environment.WIKI_VERSION);
 
            StringBuffer content = new StringBuffer();
            content.append("<table><tr><th>" + messages.getString("common.date") + "</th><th>" + messages.getString("common.topic") + "</th><th>" + messages.getString("common.user") + "</th></tr>\n");
            Collection all = null;
            try {
                  Calendar cal = Calendar.getInstance();
                  ChangeLog cl = WikiBase.getInstance().getChangeLogInstance();
                  int n = Environment.getInstance().getIntSetting(Environment.PROPERTY_RECENT_CHANGES_DAYS);
                  if (n == 0)
                        n = 5;
 
                  all = new ArrayList();
                  for (int i = 0; i < n; i++) {
                        Collection col = cl.getChanges(virtualWiki, cal.getTime());
                        if (col != null)
                             all.addAll(col);
                        cal.add(Calendar.DATE, -1);
                  }
            } catch (Exception e) {
                  ;
            }
            DateFormat df = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT, locale);
            for (Iterator iter = all.iterator(); iter.hasNext();) {
                  Change change = (Change) iter.next();
                  content.append("<tr><td class=\"recent\">" + df.format(change.getTime()) + "</td><td class=\"recent\"><a href=\"" + change.getTopic() + ".html\">" + change.getTopic() + "</a></td><td class=\"recent\">" + change.getUser() + "</td></tr>");
            }
            content.append("</table>\n");
 
            tpl.setFieldGlobal("TOPICNAME", "RecentChanges");
            tpl.setFieldGlobal("VERSION", Environment.WIKI_VERSION);
            tpl.setFieldGlobal("CONTENTS", content.toString());
 
            entry = new ZipEntry("RecentChanges.html");
            strin = new StringReader(tpl.getContent());
            // Add new entry to zip archive
            zipout.putNextEntry(entry);
            // Add data to new entry
            int read;
            while ((read = strin.read()) != -1)
                  zipout.write(read);
            zipout.closeEntry(); // Close this entry
            zipout.flush();
 */
            logger.debug("Done adding all special topics.");
      }
 
      private void addAllImages(Environment en, ZipOutputStream zipout, int progressStart, int progressLength) throws IOException {
            // add images
            String[] files = new File(imageDir).list();
 
            int bytesRead = 0;
            byte byteArray[] = new byte[4096];
 
            for (int i = 0; i < files.length; i++) {
                  progress = Math.min(progressStart + (int) ((double) i * (double) progressLength / (double) files.length), 99);
                  logger.debug("Adding image file " + files[i]);
 
                  ZipEntry entry = new ZipEntry("images/" + files[i]);
                  zipout.putNextEntry(entry);
 
                  FileInputStream in = new FileInputStream(new File(imageDir, files[i]));
 
                  // Read in bytes through file stream, and write out through servlet stream
                  while (in.available() > 0) {
                        bytesRead = in.read(byteArray, 0, Math.min(4096, in.available()));
                        zipout.write(byteArray, 0, bytesRead);
                  }
                  zipout.closeEntry();
                  zipout.flush();
            }
      }
 
      private Template getTemplateFilledWithContent(String virtualWiki, String contentName) throws Exception {
      	return getTemplateFilledWithContent(virtualWiki, contentName, null);
      }

      private Template getTemplateFilledWithContent(String virtualWiki, String contentName, Map map) throws Exception {
      		WikiBase wb = WikiBase.getInstance();
      	    Template tpl = new Template (wb.readRaw(virtualWiki, "SpecialPageTemplate").getBytes());
            tpl.setFieldGlobal("VERSION", Environment.WIKI_VERSION);
            StringBuffer content = readFile("/WEB-INF/classes/export2html/" + contentName + ".content");
            
            String contStr = content.toString();
            if (map != null){
            	Iterator iterator = map.keySet().iterator();
            	while (iterator.hasNext()) {
            		String key = (String)iterator.next();
            		String value = (String) map.get(key);
            		if (value != null) {
            			contStr = Utilities.replaceString(contStr, key, value);
            		}
            	}
            }
            tpl.setFieldGlobal("CONTENTS", contStr);
          return tpl;
      }
 
      /**
       * Read a file from a resource inside the classpath
       * @param filename The file to read
       * @return The content of the file as StringBuffer
       */
      private StringBuffer readFile(String filename) {
            // get content
            return Utilities.readFile(new File(this.getServletContext().getRealPath(filename)));
      }
 
      /**
       * We are done. Go to result page.
       * @see vqwiki.servlets.LongLastingOperationServlet#dispatchDone(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
       */
      protected void dispatchDone(HttpServletRequest request, HttpServletResponse response) {
            if (exception != null) {
                  error(request, response, new ServletException(exception.getMessage(), exception));
                  return;
            }
 
            try {
            	  SimpleDateFormat sdf = new SimpleDateFormat ("yyyyMMdd-HHmmss");
            	  Date now = new Date ();
            	  String dateString = sdf.format(now);
            	  
                  response.setContentType("application/zip");
                  response.setHeader("Expires", "0");
                  response.setHeader("Pragma", "no-cache");
                  response.setHeader("Keep-Alive", "timeout=15, max=100");
                  response.setHeader("Connection", "Keep-Alive");
 
                  response.setHeader("Content-Disposition", "attachment" + ";filename=" + virtualWiki + "." + dateString + ".zip;");
 
                  FileInputStream in = new FileInputStream(tempFile);
 
                  response.setContentLength((int) tempFile.length());
                  OutputStream out = response.getOutputStream();
 
                  int bytesRead = 0;
                  byte byteArray[] = new byte[4096];
                  while (in.available() > 0) {
                        bytesRead = in.read(byteArray, 0, Math.min(4096, in.available()));
                        out.write(byteArray, 0, bytesRead);
                  }
                  out.flush();
                  out.close();
                  
                  String lastExport = tempdir + File.separator + virtualWiki + ".HTML-Export.zip";
                  try {
	                  File lastExportFile = new File (lastExport);
	                  if (lastExportFile.exists()) {
	                  	lastExportFile.delete();
	                  }                  
	                  tempFile.renameTo(lastExportFile);
	                  /* copy instead of rename (if rename does not work, but then delete will not work too)
	                  int len  = 32768;
	                  byte[] buff = new byte[len];
	                  FileInputStream  fis = new FileInputStream(tempFile);
	                  FileOutputStream fos = new FileOutputStream(lastExportFile);
	                  while (0 < (len = fis.read(buff)))
	                    fos.write( buff, 0, len );
	                  fos.flush();
	                  fos.close();
	                  fis.close();
	                  tempFile.delete();
	                  */
                  } catch (Exception e) {e.printStackTrace();}
                  
            } catch (Exception e) {
                  logger.fatal("Exception", e);
                  error(request, response, new ServletException(e.getMessage(), e));
            }
      }
} 