/**
 * Copyright 2004, Uwe Roth
 * User: Uwe Roth
 * Date: 08/04/2005
 * Time: 14:24
 */

package vqwiki.lex;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import vqwiki.Environment;
import vqwiki.WikiAction;
import vqwiki.WikiException;
import vqwiki.servlets.WikiServletException;
import vqwiki.utils.Utilities;

import org.apache.log4j.Logger;

/**
 * Lexer that includes LaTeX-Fragements
 *
 * Copyright 2005, Uwe Roth
 * Subject to LGPL
 * 
 * @author $Author: Uwe Roth $
 */
public class LaTeXLex extends ExternalLex implements WikiAction{

  /**
   * Logger
   */
  public static final Logger logger = Logger.getLogger(LaTeXLex.class);
  private static final String STYLEDEFAULT = "minimal";
  private static final String DPIDEFAULT = "100";
  
  private static final String TEXPATH = "TeXFiles/";
  
  
  /**
   * Include the given LaTeX-fragment as a PNG into the document.
   * @param laTeX fragemnt
   * @return string image-link to the corresponding PNG-File
   */
  public String process(String laTeX) {
  	
  	laTeX = Utilities.replaceString(laTeX,"\\input", "");
  	laTeX = Utilities.replaceString(laTeX,"\\include", "");
  	
    Environment en = Environment.getInstance();
    
    String latex = "latex";
    String dvips = "dvips";
    String ghostScript = "gs";
    
    String OSName = System.getProperty("os.name");
    if (OSName.indexOf("Windows") >= 0) {
    	ghostScript = "gswin32c";
    }
    
    try {
    	String style=(String) getParameter("style");
    	if (style == null) {style = STYLEDEFAULT;}
    	String dpi=(String) getParameter("dpi");
    	if (dpi == null) {dpi = DPIDEFAULT;}
    	
    	MessageDigest md = MessageDigest.getInstance("MD5");
   	    md.update(laTeX.getBytes());
   	    md.update(this.getParameters().toString().getBytes());
   	    byte[] digest = md.digest();
   	    StringBuffer sb = new StringBuffer ();
   	    for (int i = 0; i< digest.length; i++) {
   	    	int x = digest[i];
   	    	if (x<0) x+=256;
   	    	sb.append(Integer.toHexString(x/16).toUpperCase());
   	    	sb.append(Integer.toHexString(x%16).toUpperCase());
   	    }
   	    String tmpFile = sb.toString();
   	    File teXPath = en.uploadPath(virtualWiki, TEXPATH);
   	    if (!teXPath.exists()) {
   	    	teXPath.mkdir();
   	    }
   	    File  teXFile = en.uploadPath(virtualWiki, TEXPATH + tmpFile + ".tex");
   	    File  dviFile = en.uploadPath(virtualWiki, TEXPATH + tmpFile + ".dvi");
   	    File  epsFile = en.uploadPath(virtualWiki, TEXPATH + tmpFile + ".eps");
   	    File  pngFile = en.uploadPath(virtualWiki, TEXPATH + tmpFile + ".png");
   	    File  auxFile = en.uploadPath(virtualWiki, TEXPATH + tmpFile + ".aux");
   	    File  logFile = en.uploadPath(virtualWiki, TEXPATH + tmpFile + ".log");
   	    
   	    if (!pngFile.exists()) {

	   	    String latexEnvPath = Environment.getInstance().getRealPath() + "WEB-INF/classes/latex.environment";
	   	    ArrayList envList = new ArrayList ();
	   	    String[] env = null;
	   	    String line = null;
	   	    try {
	   	    	BufferedReader br = new BufferedReader(new FileReader(latexEnvPath));
	   	    	while (br.ready()) {
	   	    		line = br.readLine();
	   	    		envList.add(line);
	   	    	}
	   	    	br.close();
	   	    } catch (Exception e) {
	   	    	e.printStackTrace();
	   	    }	
	   	    
	   	    if (envList != null) {
	   	    	env = new String[envList.size()];
	   	    	for (int i = 0; i < envList.size(); i++)
	   	    	env[i] = (String) envList.get(i);
	   	    }
	   	    	
	   	    BufferedWriter bw = new BufferedWriter(new FileWriter(teXFile));
	   	    bw.write("\\documentclass[12pt]{" + style + "}");  bw.newLine();
	   	    bw.write("\\pagestyle{empty}"); bw.newLine();
	   	    bw.write("\\usepackage[latin1,latin5]{inputenc}"); bw.newLine();
	   	    bw.write("\\usepackage[ngerman,english,french]{babel}"); bw.newLine();
	   	    bw.write("\\begin{document}"); bw.newLine();
	   	    bw.write(laTeX); bw.newLine();
	   	    bw.write("\\end{document}"); bw.newLine ();
	   	    bw.flush();
	   	    bw.close();
	   	    
	   	    String command = null;
	   	    int retValue = -1;

	   	    command = latex + " -interaction=batchmode " + teXFile.getName();
	   	    retValue = execute(command, 5000, 1000, env, teXPath);
	   	    command = dvips + " -o " + epsFile.getName() +  " -E " + dviFile.getName();
	   	    retValue = execute(command, 5000, 1000, env, teXPath);
	   	    command = ghostScript + " -r" + dpi +" -sDEVICE=png16m -dDOINTERPOLATE -dTextAlphaBits=4 -dGraphicsAlphaBits=4 -dSAVER -dBATCH -dNOPAUSE -dEPSCrop -sOutputFile=" + pngFile.getName() + " " + epsFile.getName();
	   	    // command = ghostScript + " -r" + dpi +" -sDEVICE=pngalpha -dBackgroundColor=16#FFFFFF -dTextAlphaBits=4 -dGraphicsAlphaBits=4 -dSAVER -dBATCH -dNOPAUSE -dEPSCrop -sOutputFile=" + pngFile.getName() + " " + epsFile.getName();
	   	    retValue = execute(command, 5000, 1000, env, teXPath);
	   	    
	   
	   	    teXFile.delete();
	   	    dviFile.delete();
	   	    epsFile.delete();
	   	    auxFile.delete();
	   	    logFile.delete();
	   	    
   	    }
   	    
   	    if (pngFile.exists()) {
   	    	addDoc(TEXPATH + tmpFile + ".png");
   	    	if (export & !preview) {
   	    		return "<img class=\"lateximg\" src=\"" + TEXPATH + tmpFile + ".png\" alt=\"\" border=\"0\"/>";
   	    	} else {
   	    		return "<img class=\"lateximg\" src=\"Wiki?action=viewTeX&TeXImg=" +  tmpFile + ".png\" alt=\"\" border=\"0\"/>";
   	    	}
   	    } else {
   	    	return "";
   	    }
    } catch (Exception e) {
      logger.error("", e);
      return "???" + e.getMessage() + "???";
    }
  }

  public void doAction(HttpServletRequest request, HttpServletResponse response) throws Exception {
    Environment en = Environment.getInstance();
    String teXImg = request.getParameter("TeXImg");

    try {
        virtualWiki = Utilities.extractVirtualWiki(request);
    } catch (WikiException e) {
          request.setAttribute("exception", e.getMessage());
          request.setAttribute("title", "Error");
          request.setAttribute("javax.servlet.jsp.jspException", e);
          dispatch("/jsp/servlet-error.jsp", request, response);
          return;
    }
    
    File uploadPath = en.uploadPath(virtualWiki, TEXPATH + teXImg);
    response.reset();
    // attachments can be "inline" or "attachment"
    response.setHeader(
        "Content-Disposition", en.getStringSetting(Environment.PROPERTY_ATTACHMENT_TYPE) +
                               ";filename=" + teXImg + ";"
    );
    if (teXImg.indexOf('.') >= 0) {
      if (teXImg.indexOf('.') < teXImg.length() - 1) {
        String extension = teXImg.substring(teXImg.lastIndexOf('.') + 1);
        logger.debug("Extension: " + extension);
        try {
          String mimetype = (String) getMimeByExtension().get(extension.toLowerCase());
          logger.debug("MIME: " + mimetype);
          if (mimetype != null) {
            logger.debug("Setting content type to: " + mimetype);
            response.setContentType(mimetype);
          }
        }
        catch (Exception e) {
          error(request, response, new WikiServletException(e.getMessage()));
          return;
        }
      }
    }
    FileInputStream in = new FileInputStream(uploadPath);
    ServletOutputStream out = response.getOutputStream();
    int bytesRead = 0;
    byte byteArray[] = new byte[4096];

    // Read in bytes through file stream, and write out through servlet stream
    while ((bytesRead = in.read(byteArray)) != -1) {
      out.write(byteArray, 0, bytesRead);
    }
    in.close();
    out.flush();
    out.close();
  }

  protected HashMap getMimeByExtension() throws Exception {
    HashMap map = new HashMap();
    InputStream resourceAsStream = Environment.getInstance().getResourceAsStream("/mime.types");
    if (resourceAsStream == null) {
      logger.warn("couldn't find the MIME types file mime.types");
      return map;
    }
    BufferedReader in =
        new BufferedReader(new InputStreamReader(
            resourceAsStream
        ));
    while (true) {
      String line = in.readLine();
      if (line == null) break;
      if (!line.startsWith("#") && !line.trim().equals("")) {
        StringTokenizer tokens = new StringTokenizer(line);
        if (tokens.hasMoreTokens()) {
          String type = tokens.nextToken();
          while (tokens.hasMoreTokens()) {
            map.put(tokens.nextToken(), type);
          }
        }
      }
    }
    return map;
  }
  
  protected void error(HttpServletRequest request, HttpServletResponse response, Exception err) {
    request.setAttribute("exception", err);
    request.setAttribute("title", "Error");

    if (!(err instanceof WikiServletException)) {
    	err.printStackTrace();
    	logger.error(err.getMessage(), err);
    } else {     
    	request.setAttribute("javax.servlet.jsp.jspException", err);
    }
   	dispatch("/jsp/servlet-error.jsp", request, response);
  }

  protected void dispatch(String destination, HttpServletRequest request, HttpServletResponse response) {
//  logger.debug("getting dispatcher for " + destination + ", current URL: " + HttpUtils.getRequestURL(request));
    logger.debug("getting dispatcher for " + destination + ", current URL: " + request.getRequestURL());
    RequestDispatcher dispatcher = request.getRequestDispatcher(destination);
    if (dispatcher == null) {
      logger.error("No dispatcher available for " + destination + " (request=" + request +
                   ", response=" + response + ")");
      return;
    }
    try {
      dispatcher.forward(request, response);
    }
    catch (Exception e) {
      e.printStackTrace();
      logger.error("dispatch error", e);
      try {
        dispatcher = request.getRequestDispatcher("/jsp/servlet-error.jsp");
        dispatcher.forward(request, response);
      }
      catch (Exception e1) {
      }
    }
  }
  
  private int execute (String command, int maxTime, int checkTime, String [] environment, File workingPath) {
	Runtime runtime = Runtime.getRuntime();
	int exitValue = -1;
	try {
		Process p = runtime.exec(command, environment, workingPath);
		boolean finished = false;
		int count = 0;
		while (!finished & (count < maxTime)) {
			try {
				exitValue = p.exitValue();
				finished = true;				
			} catch (IllegalThreadStateException e) {
				synchronized (p) {
					p.wait(checkTime);
					count = count + checkTime;
				}
			}
		}
		p.destroy();
	} catch (Exception e) {
		e.printStackTrace();
	}			
 	return exitValue;
  }
}
