/* The following code was generated by JFlex 1.4.1 on 08.04.05 10:22 */

package vqwiki.lex;


/*
Very Quick Wiki - WikiWikiWeb clone
Copyright (C) 2001-2003 Gareth Cronin

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program (gpl.txt); if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.io.*;
import java.util.*;
import vqwiki.WikiBase;
import vqwiki.utils.*;



/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 08.04.05 10:22 from the specification file
 * <tt>C:/Program Files/Tomcat 5.0/webapps/vqwiki/WEB-INF/src/vqwiki/lex/FormatLex.jflex</tt>
 */
public class FormatLex extends vqwiki.lex.Lexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int COMMENT = 10;
  public static final int EXTERNAL = 8;
  public static final int PRE = 6;
  public static final int OFF = 4;
  public static final int INTERSECT = 12;
  public static final int NORMAL = 2;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7, 7
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\5\1\1\2\0\1\2\22\0\1\3\1\27\1\0\1\21"+
    "\1\12\1\10\1\20\1\30\5\0\1\13\1\37\1\16\12\25\1\31"+
    "\1\23\1\11\1\32\1\15\1\0\1\35\6\26\24\24\1\14\1\7"+
    "\1\4\1\0\1\6\1\0\1\43\5\26\1\42\4\24\1\40\1\44"+
    "\2\24\1\45\3\24\1\41\6\24\1\33\1\0\1\34\1\36\53\0"+
    "\1\17\12\0\1\17\4\0\1\17\5\0\27\17\1\0\37\17\1\0"+
    "\u013f\17\31\0\162\17\4\0\14\17\16\0\5\17\11\0\1\17\213\0"+
    "\1\17\13\0\1\17\1\0\3\17\1\0\1\17\1\0\24\17\1\0"+
    "\54\17\1\0\46\17\1\0\5\17\4\0\202\17\10\0\105\17\1\0"+
    "\46\17\2\0\2\17\6\0\20\17\41\0\46\17\2\0\1\17\7\0"+
    "\47\17\110\0\33\17\5\0\3\17\56\0\32\17\5\0\13\17\25\0"+
    "\12\22\4\0\2\17\1\0\143\17\1\0\1\17\17\0\2\17\7\0"+
    "\2\17\12\22\3\17\2\0\1\17\20\0\1\17\1\0\36\17\35\0"+
    "\3\17\60\0\46\17\13\0\1\17\u0152\0\66\17\3\0\1\17\22\0"+
    "\1\17\7\0\12\17\4\0\12\22\25\0\10\17\2\0\2\17\2\0"+
    "\26\17\1\0\7\17\1\0\1\17\3\0\4\17\3\0\1\17\36\0"+
    "\2\17\1\0\3\17\4\0\12\22\2\17\23\0\6\17\4\0\2\17"+
    "\2\0\26\17\1\0\7\17\1\0\2\17\1\0\2\17\1\0\2\17"+
    "\37\0\4\17\1\0\1\17\7\0\12\22\2\0\3\17\20\0\11\17"+
    "\1\0\3\17\1\0\26\17\1\0\7\17\1\0\2\17\1\0\5\17"+
    "\3\0\1\17\22\0\1\17\17\0\2\17\4\0\12\22\25\0\10\17"+
    "\2\0\2\17\2\0\26\17\1\0\7\17\1\0\2\17\1\0\5\17"+
    "\3\0\1\17\36\0\2\17\1\0\3\17\4\0\12\22\1\0\1\17"+
    "\21\0\1\17\1\0\6\17\3\0\3\17\1\0\4\17\3\0\2\17"+
    "\1\0\1\17\1\0\2\17\3\0\2\17\3\0\3\17\3\0\10\17"+
    "\1\0\3\17\55\0\11\22\25\0\10\17\1\0\3\17\1\0\27\17"+
    "\1\0\12\17\1\0\5\17\46\0\2\17\4\0\12\22\25\0\10\17"+
    "\1\0\3\17\1\0\27\17\1\0\12\17\1\0\5\17\3\0\1\17"+
    "\40\0\1\17\1\0\2\17\4\0\12\22\25\0\10\17\1\0\3\17"+
    "\1\0\27\17\1\0\20\17\46\0\2\17\4\0\12\22\25\0\22\17"+
    "\3\0\30\17\1\0\11\17\1\0\1\17\2\0\7\17\72\0\60\17"+
    "\1\0\2\17\14\0\7\17\11\0\12\22\47\0\2\17\1\0\1\17"+
    "\2\0\2\17\1\0\1\17\2\0\1\17\6\0\4\17\1\0\7\17"+
    "\1\0\3\17\1\0\1\17\1\0\1\17\2\0\2\17\1\0\4\17"+
    "\1\0\2\17\11\0\1\17\2\0\5\17\1\0\1\17\11\0\12\22"+
    "\2\0\2\17\42\0\1\17\37\0\12\22\26\0\10\17\1\0\42\17"+
    "\35\0\4\17\164\0\42\17\1\0\5\17\1\0\2\17\25\0\12\22"+
    "\6\0\6\17\112\0\46\17\12\0\51\17\7\0\132\17\5\0\104\17"+
    "\5\0\122\17\6\0\7\17\1\0\77\17\1\0\1\17\1\0\4\17"+
    "\2\0\7\17\1\0\1\17\1\0\4\17\2\0\47\17\1\0\1\17"+
    "\1\0\4\17\2\0\37\17\1\0\1\17\1\0\4\17\2\0\7\17"+
    "\1\0\1\17\1\0\4\17\2\0\7\17\1\0\7\17\1\0\27\17"+
    "\1\0\37\17\1\0\1\17\1\0\4\17\2\0\7\17\1\0\47\17"+
    "\1\0\23\17\16\0\11\22\56\0\125\17\14\0\u026c\17\2\0\10\17"+
    "\12\0\32\17\5\0\113\17\25\0\15\17\1\0\4\17\16\0\22\17"+
    "\16\0\22\17\16\0\15\17\1\0\3\17\17\0\64\17\43\0\1\17"+
    "\4\0\1\17\3\0\12\22\46\0\12\22\6\0\130\17\10\0\51\17"+
    "\127\0\35\17\51\0\12\22\36\17\2\0\5\17\u038b\0\154\17\224\0"+
    "\234\17\4\0\132\17\6\0\26\17\2\0\6\17\2\0\46\17\2\0"+
    "\6\17\2\0\10\17\1\0\1\17\1\0\1\17\1\0\1\17\1\0"+
    "\37\17\2\0\65\17\1\0\7\17\1\0\1\17\3\0\3\17\1\0"+
    "\7\17\3\0\4\17\2\0\6\17\4\0\15\17\5\0\3\17\1\0"+
    "\7\17\164\0\1\17\15\0\1\17\202\0\1\17\4\0\1\17\2\0"+
    "\12\17\1\0\1\17\3\0\5\17\6\0\1\17\1\0\1\17\1\0"+
    "\1\17\1\0\4\17\1\0\3\17\1\0\7\17\3\0\3\17\5\0"+
    "\5\17\u0ebb\0\2\17\52\0\5\17\5\0\2\17\4\0\126\17\6\0"+
    "\3\17\1\0\132\17\1\0\4\17\5\0\50\17\4\0\136\17\21\0"+
    "\30\17\70\0\20\17\u0200\0\u19b6\17\112\0\u51a6\17\132\0\u048d\17\u0773\0"+
    "\u2ba4\17\u215c\0\u012e\17\2\0\73\17\225\0\7\17\14\0\5\17\5\0"+
    "\1\17\1\0\12\17\1\0\15\17\1\0\5\17\1\0\1\17\1\0"+
    "\2\17\1\0\2\17\1\0\154\17\41\0\u016b\17\22\0\100\17\2\0"+
    "\66\17\50\0\14\17\164\0\5\17\1\0\207\17\23\0\12\22\7\0"+
    "\32\17\6\0\32\17\13\0\131\17\3\0\6\17\2\0\6\17\2\0"+
    "\6\17\2\0\3\17\43\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\10\0\1\1\1\2\1\3\1\4\1\3\3\1\1\5"+
    "\1\1\1\6\1\7\10\1\1\5\3\10\3\1\3\11"+
    "\3\12\1\13\2\0\1\14\1\15\1\16\10\0\1\17"+
    "\1\20\3\0\1\21\3\0\1\22\1\23\7\0\1\24"+
    "\1\25\4\0\1\26\6\0\1\27\1\30\1\31\1\32"+
    "\1\0\1\33\12\0\1\34\2\0\1\35\1\36\1\37"+
    "\2\0\1\40\7\0\1\41\1\0\1\42\2\0\1\43"+
    "\4\0\1\44\1\45\1\46\6\0\1\47\4\0\1\50"+
    "\2\0\1\51\1\52\3\0\1\53\1\0\1\54\2\0"+
    "\1\55\1\0\1\56\1\57\1\0\1\60\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[162];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\46\0\114\0\162\0\230\0\276\0\344\0\u010a"+
    "\0\0\0\0\0\u0130\0\0\0\0\0\u0156\0\u017c\0\u01a2"+
    "\0\u01c8\0\u01ee\0\0\0\u0214\0\u023a\0\u0260\0\u0286\0\u02ac"+
    "\0\u02d2\0\u02f8\0\u031e\0\u0344\0\0\0\u036a\0\u0390\0\0"+
    "\0\u03b6\0\u03dc\0\u0402\0\0\0\u0428\0\u044e\0\0\0\u0474"+
    "\0\u049a\0\0\0\u04c0\0\u04e6\0\0\0\0\0\u050c\0\u0532"+
    "\0\u0558\0\u057e\0\u05a4\0\u05ca\0\u05f0\0\u0616\0\u063c\0\u0662"+
    "\0\0\0\u0688\0\u06ae\0\u06d4\0\u06fa\0\u0720\0\u0746\0\u076c"+
    "\0\0\0\0\0\u0792\0\u036a\0\u050c\0\u07b8\0\u07de\0\u0804"+
    "\0\u082a\0\0\0\0\0\u0850\0\u0876\0\u089c\0\u08c2\0\0"+
    "\0\u08e8\0\u090e\0\u0934\0\u095a\0\u0980\0\u09a6\0\0\0\0"+
    "\0\0\0\0\0\u09cc\0\0\0\u09f2\0\u0a18\0\u0a3e\0\u0a64"+
    "\0\u0a8a\0\u0ab0\0\u0ad6\0\u0afc\0\u0b22\0\u0b48\0\0\0\u0b6e"+
    "\0\u0b94\0\0\0\0\0\0\0\u0bba\0\u0be0\0\0\0\u0c06"+
    "\0\u0c2c\0\u0c52\0\u0c78\0\u0c9e\0\u0cc4\0\u0cea\0\0\0\u0d10"+
    "\0\0\0\u0d36\0\u0d5c\0\0\0\u0d82\0\u0da8\0\u0dce\0\u0df4"+
    "\0\0\0\0\0\0\0\u0e1a\0\u0e40\0\u0e66\0\u0e8c\0\u0eb2"+
    "\0\u0ed8\0\0\0\u0efe\0\u0f24\0\u0f4a\0\u0f70\0\0\0\u0f96"+
    "\0\u0fbc\0\0\0\0\0\u0fe2\0\u1008\0\u102e\0\0\0\u1054"+
    "\0\0\0\u107a\0\u10a0\0\0\0\u10c6\0\0\0\0\0\u10ec"+
    "\0\0\0\u1112";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[162];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\46\0\1\11\1\12\1\13\1\14\1\11\1\15\1\16"+
    "\1\17\1\20\1\21\2\11\1\22\1\23\2\11\1\24"+
    "\7\11\1\25\1\26\1\27\1\30\1\31\1\32\11\11"+
    "\1\12\1\13\1\14\1\11\1\15\1\16\1\17\1\20"+
    "\1\21\2\11\1\22\1\23\2\11\1\24\6\11\1\33"+
    "\1\25\1\26\1\27\1\30\1\31\1\32\11\11\1\12"+
    "\1\13\1\15\1\11\1\15\1\34\2\11\1\35\3\11"+
    "\1\23\2\11\1\24\26\11\1\36\1\37\1\40\1\11"+
    "\1\40\1\16\1\41\1\42\1\21\2\11\1\22\1\23"+
    "\2\11\1\24\26\11\3\15\1\11\1\15\6\11\1\43"+
    "\31\11\7\44\1\45\1\46\35\44\11\47\1\50\1\47"+
    "\1\51\32\47\1\0\1\12\52\0\1\52\45\0\1\53"+
    "\1\54\13\0\1\55\13\0\1\56\16\0\1\57\10\0"+
    "\1\60\2\0\1\61\1\0\1\61\11\0\6\61\12\0"+
    "\1\62\44\0\1\63\55\0\1\64\16\0\1\65\1\0"+
    "\1\66\1\67\32\0\1\70\46\0\1\71\46\0\1\72"+
    "\46\0\1\73\46\0\1\74\46\0\1\75\1\76\7\0"+
    "\1\77\1\0\25\77\1\100\16\77\6\0\1\101\40\0"+
    "\1\102\1\103\44\0\1\104\52\0\1\53\1\54\46\0"+
    "\1\105\46\0\1\106\43\0\1\54\46\0\1\107\47\0"+
    "\1\110\45\0\1\111\41\0\1\112\40\0\1\113\1\114"+
    "\5\0\1\115\45\0\1\116\62\0\2\117\14\0\1\117"+
    "\12\0\1\120\13\0\1\61\1\0\1\61\11\0\6\61"+
    "\12\0\1\121\33\0\15\122\1\0\30\122\22\0\1\123"+
    "\2\0\1\123\61\0\1\124\45\0\1\125\50\0\1\126"+
    "\31\0\1\127\47\0\1\130\46\0\1\131\46\0\1\132"+
    "\46\0\1\133\45\0\1\134\10\0\1\77\1\0\25\77"+
    "\1\135\16\77\1\136\1\0\25\136\1\137\16\136\1\0"+
    "\1\102\62\0\1\140\37\0\1\141\47\0\1\142\45\0"+
    "\1\143\34\0\1\113\54\0\1\144\45\0\1\145\62\0"+
    "\2\146\14\0\1\146\15\0\1\147\1\150\31\0\15\122"+
    "\1\151\30\122\22\0\1\123\1\152\1\0\1\123\43\0"+
    "\1\153\45\0\1\154\67\0\1\155\35\0\1\156\10\0"+
    "\1\77\1\157\1\160\24\77\1\135\16\77\1\136\1\0"+
    "\25\136\1\161\16\136\1\162\1\157\1\163\24\162\1\164"+
    "\16\162\17\0\1\165\4\0\1\165\1\0\1\165\11\0"+
    "\6\165\10\0\1\166\50\0\1\167\1\170\46\0\1\171"+
    "\40\0\1\172\35\0\1\173\1\174\1\175\43\173\25\0"+
    "\2\176\14\0\1\176\2\0\4\177\1\200\7\177\1\0"+
    "\31\177\4\0\1\201\64\0\1\202\23\0\1\203\1\204"+
    "\43\0\1\77\1\157\25\77\1\135\16\77\1\136\1\157"+
    "\1\205\24\136\1\206\16\136\1\162\1\0\25\162\1\207"+
    "\17\162\1\157\25\162\1\207\17\162\1\157\1\163\24\162"+
    "\1\210\16\162\15\0\1\211\1\0\1\165\4\0\1\165"+
    "\1\0\1\165\11\0\6\165\1\0\1\212\1\213\43\0"+
    "\4\214\1\215\7\214\1\0\31\214\10\0\1\216\35\0"+
    "\1\173\1\217\45\173\1\174\44\173\25\0\2\220\14\0"+
    "\1\220\2\0\4\177\1\221\7\177\1\0\31\177\13\0"+
    "\1\222\33\0\1\203\44\0\1\136\1\157\25\136\1\161"+
    "\17\136\1\223\1\224\24\136\1\206\16\136\1\162\1\157"+
    "\1\163\24\162\1\225\17\162\1\223\1\226\24\162\1\225"+
    "\16\162\4\0\1\227\42\0\1\212\44\0\4\214\1\230"+
    "\7\214\1\0\31\214\13\0\1\231\32\0\1\232\1\0"+
    "\44\232\25\0\2\233\14\0\1\233\15\0\1\234\32\0"+
    "\1\136\1\223\25\136\1\161\16\136\1\162\1\223\1\226"+
    "\24\162\1\235\17\162\1\223\25\162\1\207\16\162\13\0"+
    "\1\236\32\0\1\232\1\237\44\232\25\0\2\240\14\0"+
    "\1\240\2\0\1\162\1\241\1\242\24\162\1\235\16\162"+
    "\10\0\1\120\35\0\1\162\1\241\25\162\1\207\16\162";

  private static int [] zzUnpackTrans() {
    int [] result = new int[4408];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\10\7\0\2\11\1\1\2\11\5\1\1\11\11\1"+
    "\1\11\2\1\1\11\3\1\1\11\2\1\1\11\2\1"+
    "\1\11\2\0\2\11\1\1\10\0\1\1\1\11\3\0"+
    "\1\1\3\0\2\11\7\0\2\11\4\0\1\11\6\0"+
    "\4\11\1\0\1\11\12\0\1\11\2\0\3\11\2\0"+
    "\1\11\7\0\1\11\1\0\1\11\2\0\1\11\4\0"+
    "\3\11\6\0\1\11\4\0\1\11\2\0\2\11\3\0"+
    "\1\11\1\0\1\11\2\0\1\11\1\0\2\11\1\0"+
    "\1\11\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[162];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
  protected boolean em, strong, underline, center, table, row, cell, allowHtml, code, h1, h2, h3, color;
  protected int listLevel;
  protected boolean ordered;
  protected boolean isCode = false;
  protected String intersection = "";
  protected int intersectCount = 0;
  protected String intersectMode = null;
  
  private static final String ISECSTART = " {${$${$$${--{";
  private static final String ISECEND = "}--}$$$}$$}$}";
  



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public FormatLex(java.io.Reader in) {
  	yybegin( NORMAL );
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public FormatLex(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1268) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 47: 
          { // ignore the following comment and new-line 
  return "";
          }
        case 49: break;
        case 4: 
          { // space
  if (isCode)
    return "&nbsp;";
  else
    return " ";
          }
        case 50: break;
        case 6: 
          { return "&gt;";
          }
        case 51: break;
        case 2: 
          { logger.debug( "{newline}" );
  if( h1 ){
    h1 = false;
    return( "</h1>" );
  }
  if( h2 ){
    h2 = false;
    return( "</h2>" );
  }
  if( h3 ){
    h3 = false;
    return( "</h3>" );
  }
  return yytext();
          }
        case 52: break;
        case 12: 
          { // special tab \;
	return "&nbsp;&nbsp;&nbsp;";
          }
        case 53: break;
        case 32: 
          { // heading 3 !
  logger.debug("!...!");
  return "<h3>" + yytext().substring(1,yytext().substring(1).indexOf('!')+1) + "</h3>";
          }
        case 54: break;
        case 16: 
          { // center ::
  logger.debug( "::" );
  if( center ){
    center = false;
    return( "</div>" );
  }
  else{
    center = true;
    return( "<div align=\"center\">" );
  }
          }
        case 55: break;
        case 40: 
          { // start Comment: %%%%....{newline}

  logger.debug( "comment line" );

  return "\n";
          }
        case 56: break;
        case 18: 
          { // formatted text end__
  logger.debug( "Format on" );
  yybegin( NORMAL );
  return "__";
          }
        case 57: break;
        case 19: 
          { logger.debug( "{newline}x2 leaving pre" );
	yybegin( NORMAL );
  return yytext();
          }
        case 58: break;
        case 31: 
          { return "&amp;gt;";
          }
        case 59: break;
        case 21: 
          { // ignore the following new-line
  return "";
          }
        case 60: break;
        case 27: 
          { // Page break @~@
  return "<p style=\"page-break-after:always\">&nbsp;</p>";
          }
        case 61: break;
        case 48: 
          { // heading 1 !!!
  logger.debug("!!!...!!!");
  return "<h1>" + yytext().substring(3, yytext().substring(3).indexOf('!')+3) + "</h1>";
          }
        case 62: break;
        case 22: 
          { logger.debug( "color start" );
  
  StringBuffer sb = new StringBuffer() ;
  if( color ){
    sb.append( "</font>" );
  }  
  color = true;
  sb.append( "<font color=\"")
    .append( yytext().substring( 1,yytext().length()-1) )
    .append( "\">" );
  
  return sb.toString();
          }
        case 63: break;
        case 37: 
          { return "&amp;amp;";
          }
        case 64: break;
        case 25: 
          { // code start {{{
  isCode = true;
  return "<code>";
          }
        case 65: break;
        case 17: 
          { // Line break @@
  return "<br/>";
          }
        case 66: break;
        case 7: 
          { return "&amp;";
          }
        case 67: break;
        case 34: 
          { // $$>
  
  intersectCount--;
  if (intersectCount == 0) {  
  
     Boolean globalDisplay = (Boolean) getParameter("globalDisplay");
     if (globalDisplay == null) globalDisplay = new Boolean (true);
     Boolean globalPrint = (Boolean) getParameter("globalPrint");
     if (globalPrint == null) globalPrint = new Boolean (true);
     Boolean globalExport = (Boolean) getParameter("globalExport");;
     if (globalExport == null) globalExport = new Boolean (true);
     
     boolean localDisplay = false;
     boolean localPrint = false;
     boolean localExport = false;

     StringTokenizer st = new StringTokenizer(intersectMode, ", ");

     while (st.hasMoreTokens()) {
       String token = st.nextToken();
       if (token.trim().toLowerCase().equals("display")) {
         localDisplay = true;
       }
       if (token.trim().toLowerCase().equals("print")) {
         localPrint = true;
       }
       if (token.trim().toLowerCase().equals("export")) {
         localExport = true;
       }
       if (token.trim().toLowerCase().equals("!display")) {
         localPrint = true;
         localExport = true;
       }
       if (token.trim().toLowerCase().equals("!print")) {
         localDisplay = true;
         localExport = true;
       }
       if (token.trim().toLowerCase().equals("!export")) {
         localDisplay = true;
         localPrint = true;
       }
       if (token.trim().toLowerCase().equals("all")) {
         localDisplay = true;
         localPrint = true;
         localExport = true;
       }
    }
         
    globalDisplay = new Boolean(globalDisplay.booleanValue() & localDisplay);
    globalPrint = new Boolean (globalPrint.booleanValue() & localPrint);
    globalExport = new Boolean (globalExport.booleanValue() & localExport);

    boolean calcContent = false;
    switch (displayMode) {
      case WikiBase.DISPLAY: calcContent = globalDisplay.booleanValue(); break;
      case WikiBase.PRINT: calcContent = globalPrint.booleanValue(); break;
      case WikiBase.EXPORT: calcContent = globalExport.booleanValue(); break;
    }  
    if (calcContent) {
      BufferedReader in = new BufferedReader(new StringReader(intersection));
      String content = "";
      try {
        Map parameters = new HashMap();
        parameters.put("decodeSubsection", "false");
        parameters.put("globalDisplay", globalDisplay);
        parameters.put("globalPrint", globalPrint);
        parameters.put("globalExport", globalExport);
        List linkList = new ArrayList ();
        List docList = new ArrayList ();
        content = WikiBase.getInstance().cook(in, virtualWiki, topic, topicsList, linkList, docList, displayModeFullInfo, parameters);
        addLinks (linkList);
        addDocs (docList);
        if (content != "") {
          content = Utilities.encodeSafeFileName(content);
          content = ISECSTART + content + ISECEND;
        }
      	intersection = "";
      	yybegin(NORMAL);
      	return content;
      } catch (Exception e) {}
    }
  	intersection = "";
  	yybegin(NORMAL);
  	return "";
  } else {
	  intersection+= "-$$>";
  }
  return "";
          }
        case 68: break;
        case 44: 
          { // another <$$[]-
  intersectCount++;
  intersection+= yytext();
  return "";
          }
        case 69: break;
        case 11: 
          { // formatted text begin __
  logger.debug( "Format off" );
  yybegin( OFF );
  return "__";
          }
        case 70: break;
        case 15: 
          { // emphasis ''
  logger.debug( "''" );
  if( em ){
    em = false;
    return( "</em>" );
  }
  else{
    em = true;
    return( "<em>" );
  }
          }
        case 71: break;
        case 10: 
          { // inside <$$-....-$$>
  logger.debug( ". (" + yytext() + ")" );
  intersection = intersection + yytext();
  return "";
          }
        case 72: break;
        case 28: 
          { // start <$$-
  logger.debug( "intersect start" );

  if (intersectCount==0) {
  	  intersection = "";
      intersectMode = "all";
      yybegin (INTERSECT);
  }
  intersectCount++;

  return "";
          }
        case 73: break;
        case 39: 
          { // end Comment: %%%%{newline}
  yybegin(NORMAL);
  return "";
          }
        case 74: break;
        case 38: 
          { logger.debug( "@@@@{newline} entering PRE" );
  yybegin( PRE );
  return yytext();
          }
        case 75: break;
        case 46: 
          { // another <$$[displayMode]-
  intersectCount++;
  intersection+= yytext();
  return "";
          }
        case 76: break;
        case 33: 
          { // another <$$-
  intersectCount++;
  intersection+= yytext();
  return "";
          }
        case 77: break;
        case 43: 
          { // external end
  logger.debug( "external end");
  yybegin( NORMAL );
  return yytext();
          }
        case 78: break;
        case 26: 
          { // code end }}}
  isCode=false;
  return "</code>";
          }
        case 79: break;
        case 24: 
          { // underline ===
  logger.debug( "===" );
  if( underline ){
    underline = false;
    return( "</u>" );
  }
  else{
    underline = true;
    return( "<u>" );
  }
          }
        case 80: break;
        case 29: 
          { return yytext();
          }
        case 81: break;
        case 23: 
          { // strong '''
  logger.debug( "'''" );
  if( strong ){
    strong = false;
    return( "</strong>" );
  }
  else{
    strong = true;
    return( "<strong>" );
  }
          }
        case 82: break;
        case 20: 
          { // escaped double backslash \\_
  logger.debug( "escaped double backslash" );
  return "\\__";
          }
        case 83: break;
        case 5: 
          { return "&lt;";
          }
        case 84: break;
        case 9: 
          { logger.debug( ". (" + yytext() + ")" );
  return "";
          }
        case 85: break;
        case 3: 
          { logger.debug( "{whitespace}" );
  return yytext();
          }
        case 86: break;
        case 1: 
          { logger.debug( ". (" + yytext() + ")" );
  return yytext();
          }
        case 87: break;
        case 36: 
          { // external start
  logger.debug( "external" );
  yybegin( EXTERNAL );
  return yytext();
          }
        case 88: break;
        case 14: 
          { if( color ){
    logger.debug( "color end" );
  
    color = false ;
    return( "</font>" );
  }
  else {
    return yytext();
  }
          }
        case 89: break;
        case 45: 
          { // start <$$[displayMode]-
  
  logger.debug( "intersect2 start" );

  if (intersectCount==0) {
  	  intersection = "";
	  intersectMode = yytext();
	  int start = intersectMode.indexOf("[");
	  int end = intersectMode.indexOf("]");
	  if ((start >= 0) & (end >= 0)) {
	  	intersectMode = intersectMode.substring(start + 1, end);
	  }
	  yybegin (INTERSECT);
  }
  intersectCount++;
  return "";
          }
        case 90: break;
        case 30: 
          { return "&amp;lt;";
          }
        case 91: break;
        case 35: 
          { // start Comment: %%%%{newline}

  logger.debug( "comment start" );

  yybegin (COMMENT);

  return "";
          }
        case 92: break;
        case 41: 
          { // start <$$[]-
  
  logger.debug( "intersect3 start" );

  if (intersectCount==0) {
  	  intersection = "";
	  intersectMode = "";
	  yybegin (INTERSECT);
  }
  intersectCount++;
  return "";
          }
        case 93: break;
        case 8: 
          { logger.debug( "PRE {whitespace}" );
  return yytext();
          }
        case 94: break;
        case 42: 
          { // heading 2 !!
  logger.debug("!!...!!");
  return "<h2>" + yytext().substring(2, yytext().substring(2).indexOf('!')+2) + "</h2>";
          }
        case 95: break;
        case 13: 
          { // special space \;
	return "&nbsp;";
          }
        case 96: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              { 	if( strong ){
	  strong = false;
	  return( "</strong>" );
	}
	if( em ){
	  em = false;
	  return( "</em>" );
	}
	return null;
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
