/*
 * Copyright 2002 Gareth Cronin
 * This software is subject to the GNU Public Licence
 */
package vqwiki.db;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;

import javax.naming.Context;
import javax.naming.InitialContext;

//import org.apache.commons.dbcp.AbandonedConfig;
//import org.apache.commons.dbcp.AbandonedObjectPool;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

import vqwiki.Environment;

public class DatabaseConnection {
  private static final Logger logger = Logger.getLogger(DatabaseConnection.class);
  private static boolean poolInitialized = false;

  public static void setUpConnectionPool(String url, String userName, String password) throws Exception {
    Environment env = Environment.getInstance();

    Class.forName(env.getDriver());

    /** deprecated
    AbandonedConfig config = new AbandonedConfig();
    config.setRemoveAbandoned(env.getBooleanSetting(Environment.PROPERTY_DBCP_REMOVE_ABANDONED));
    config.setLogAbandoned(env.getBooleanSetting(Environment.PROPERTY_DBCP_LOG_ABANDONED));
    config.setRemoveAbandonedTimeout(env.getIntSetting(Environment.PROPERTY_DBCP_REMOVE_ABANDONED_TIMEOUT));

    GenericObjectPool connectionPool = new AbandonedObjectPool(null, config);
    **/
    GenericObjectPool connectionPool = new GenericObjectPool();
    
    connectionPool.setMaxActive(env.getIntSetting(Environment.PROPERTY_DBCP_MAX_ACTIVE));
    connectionPool.setMaxIdle(env.getIntSetting(Environment.PROPERTY_DBCP_MAX_IDLE));
    connectionPool.setMinEvictableIdleTimeMillis(env.getIntSetting(Environment.PROPERTY_DBCP_MIN_EVICTABLE_IDLE_TIME) * 1000);
    connectionPool.setTestOnBorrow(env.getBooleanSetting(Environment.PROPERTY_DBCP_TEST_ON_BORROW));
    connectionPool.setTestOnReturn(env.getBooleanSetting(Environment.PROPERTY_DBCP_TEST_ON_RETURN));
    connectionPool.setTestWhileIdle(env.getBooleanSetting(Environment.PROPERTY_DBCP_TEST_WHILE_IDLE));
    connectionPool.setTimeBetweenEvictionRunsMillis(env.getIntSetting(Environment.PROPERTY_DBCP_TIME_BETWEEN_EVICTION_RUNS) * 1000);
    connectionPool.setNumTestsPerEvictionRun(env.getIntSetting(Environment.PROPERTY_DBCP_NUM_TESTS_PER_EVICTION_RUN));
    connectionPool.setWhenExhaustedAction((byte) env.getIntSetting(Environment.PROPERTY_DBCP_WHEN_EXHAUSTED_ACTION));

    DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, userName, password);
    new PoolableConnectionFactory(connectionFactory, connectionPool, null, env.getStringSetting(Environment.PROPERTY_DBCP_VALIDATION_QUERY), false, true);
    PoolingDriver driver = new PoolingDriver();
    driver.registerPool("vqwiki", connectionPool);

    poolInitialized = true;
  }

  public static Connection getConnection() throws Exception {
    String url = Environment.getInstance().getUrl();
    String userName = Environment.getInstance().getUserName();
    String password = Environment.getInstance().getPassword();

    if (url.startsWith("jdbc:")) {
      if (!poolInitialized) {
        setUpConnectionPool(url, userName, password);
      }
      return DriverManager.getConnection("jdbc:apache:commons:dbcp:vqwiki");
    }
    else {
      // Use Reflection here to avoid a compile time dependency
      // on the DataSource interface. It's not available by default
      // on j2se 1.3.

      Context ctx = new InitialContext();
      Object dataSource = ctx.lookup(url);
      Method m;
      Object args[];

      if (userName.length() == 0) {
        m = dataSource.getClass().getMethod("getConnection", null);
        args = new Object[]{};
      }
      else {
        m = dataSource.getClass().getMethod("getConnection", new Class[]{String.class, String.class});
        args = new Object[]{userName, password};
      }

      return (Connection) m.invoke(dataSource, args);
    }
  }

  public static void setPoolInitialized(boolean poolInitialized) {
    DatabaseConnection.poolInitialized = poolInitialized;
  }

}
