package vqwiki;

import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import vqwiki.db.DatabaseConnection;
import vqwiki.utils.JSPUtils;

import javax.naming.InitialContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
Very Quick Wiki - WikiWikiWeb clone
Copyright (C) 2001-2002 Gareth Cronin

This program is free software; you can redistribute it and/or modify
it under the terms of the latest version of the GNU Lesser General
Public License as published by the Free Software Foundation;

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program (gpl.txt); if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
 * Provides the basic environment
 * This class is a bit confusing at the moment (Nov 2002) - it is in the process of
 * being changed from one system of property defaulting and retrieval to another.
 */

/*
 * To add a new property:
 *
 * - Define constants for property name and default value below
 * - Set the default in the constructor below
 * - Set the property in AdministrationServlet's doPost method, look for the "properties" section
 * - Provide a form element for the property in admin.jsp
 * - Specify literal strings by using properties in ApplicationResources*.properties
 */

public class Environment {

  public final static String WIKI_VERSION = "2.7.1 (UniLux: 1.13.1 2005-10-07)";

  public static final String PROP_FILE = "vqwiki.properties";

  protected String homeDir;
  protected String uploadDir;
  protected int indexRefreshInterval;
  protected int recentChangesRefreshInterval;
  protected boolean allowHTML;
  protected String persistenceType;
  protected boolean versioningOn;
  protected int editTimeOut;
  protected String baseContext;
  protected boolean allowBackTick;
  protected String driver;
  protected String url;
  protected String userName;
  protected String password;
  protected boolean forceUsername;
  protected String logoImageName;
  protected boolean 
  attachmentsToDatabase;
  private static List wikinameIgnore;

  private static Environment instance;

  /*
    Old properties system
  */
  protected final static String DEFAULT_UPLOAD_DIR = "upload";
  protected final static int DEFAULT_INDEX_REFRESH_INTERVAL = 1440;
  protected final static boolean DEFAULT_ALLOW_HTML = false;
  protected final static String DEFAULT_PERSISTENCE_TYPE = "FILE";
  protected final static boolean DEFAULT_VERSIONING_ON = true;
  protected final static int DEFAULT_EDIT_TIME_OUT = 10;
  protected final static boolean DEFAULT_ALLOW_BACK_TICK = true;
  protected final static String DEFAULT_DRIVER = "org.gjt.mm.mysql.Driver";
  protected final static String DEFAULT_URL = "jdbc:mysql://localhost/vqwiki";
  protected final static String DEFAULT_USERNAME = "vqwiki";
  protected final static String DEFAULT_PASSWORD = "vqwiki";
  public static final boolean DEFAULT_FORCE_USERNAME = false;


  public static final String DEFAULT_LOGO_IMAGE_NAME = "/images/logo.jpg";
  public static final boolean DEFAULT_ATTACHMENTS_TO_DATABASE = true;

  /*
   new more easily extensible properties system
  */
  public static final String DEFAULT_ATTACHMENT_TYPE = "inline";
  public static final String PROPERTY_ATTACHMENT_TYPE = "attachment-type";

  public static final String DEFAULT_ALLOW_TEMPLATES = "true";
  public static final String PROPERTY_ALLOW_TEMPLATES = "allow-templates";

  public static final String DEFAULT_NEW_LINE_BREAKS = "1";
  public static final String PROPERTY_NEW_LINE_BREAKS = "new-line-breaks";

  public static final String DEFAULT_SMTP_HOST = "";
  public static final String PROPERTY_SMTP_HOST = "smtp-host";

  public static final String DEFAULT_REPLY_ADDRESS = "vqwiki-admin@localhost";
  public static final String PROPERTY_REPLY_ADDRESS = "reply-address";

  public static final String DEFAULT_RECENT_CHANGES_DAYS = "5";
  public static final String PROPERTY_RECENT_CHANGES_DAYS = "recent-changes-days";

  public static final String DEFAULT_MAXIMUM_BACKLINKS = "20";
  public static final String PROPERTY_MAXIMUM_BACKLINKS = "maximum-backlinks";

  public static final String DEFAULT_MAX_FILE_SIZE = "2000000";
  public static final String PROPERTY_MAX_FILE_SIZE = "max-file-size";

  public static final String DEFAULT_TEMP_DIR = "tmp";
  public static final String PROPERTY_TEMP_DIR = "tmp-dir";

  public static final String DEFAULT_SMTP_USERNAME = "";
  public static final String PROPERTY_SMTP_USERNAME = "smtp-username";

  public static final String DEFAULT_SMTP_PASSWORD = "";
  public static final String PROPERTY_SMTP_PASSWORD = "smtp-password";

  public static final String PROPERTY_FORMAT_LEXER = "format-lexer";
  public static final String DEFAULT_FORMAT_LEXER = "vqwiki.lex.FormatLex";

  public static final String PROPERTY_LINK_LEXER = "link-lexer";
  public static final String DEFAULT_LINK_LEXER = "vqwiki.lex.LinkLex";

  public static final String PROPERTY_LAYOUT_LEXER = "layout-lexer";
  public static final String DEFAULT_LAYOUT_LEXER = "vqwiki.lex.LayoutLex";

  public static final String PROPERTY_COOKIE_EXPIRE = "cookie-expire";
  public static final String DEFAULT_COOKIE_EXPIRE = "31104000"; // a year

  public static final String PROPERTY_CONVERT_TABS = "convert-tabs";
  public static final String DEFAULT_CONVERT_TABS = "true";

  public static final String PROPERTY_BASE_CONTEXT = "base-context";

  public static final String PROPERTY_ADMIN_PASSWORD = "adminPassword";

  public static final String PROPERTY_FIRST_USE = "firstUse";
  public static final String DEFAULT_FIRST_USE = "true";

  public static final String PROPERTY_CONVERT_ENTITIES = "convert-entities";
  public static final String DEFAULT_CONVERT_ENTITIES = "false";

  public static final String PROPERTY_DEFAULT_TOPIC = "default-topic";
  public static final String DEFAULT_DEFAULT_TOPIC = "StartingPoints";

  public static final String PROPERTY_DATABASE_TYPE = "database-type";
  public static final String DEFAULT_DATABASE_TYPE = "mysql";

  public static final String PROPERTY_ALLOW_VWIKI_LIST = "allow-vqwiki-list";
  public static final String DEFAULT_ALLOW_VWIKI_LIST = "true";

  public static final String PROPERTY_DBCP_MAX_ACTIVE = "dbcp-max-active";
  public static final String DEFAULT_DBCP_MAX_ACTIVE = "10";

  public static final String PROPERTY_DBCP_MAX_IDLE = "dbcp-max-idle";
  public static final String DEFAULT_DBCP_MAX_IDLE = "3";

  public static final String PROPERTY_DBCP_TEST_ON_BORROW = "dbcp-test-on-borrow";
  public static final String DEFAULT_DBCP_TEST_ON_BORROW = "true";

  public static final String PROPERTY_DBCP_TEST_ON_RETURN = "dbcp-test-on-return";
  public static final String DEFAULT_DBCP_TEST_ON_RETURN = "true";

  public static final String PROPERTY_DBCP_TEST_WHILE_IDLE = "dbcp-test-while-idle";
  public static final String DEFAULT_DBCP_TEST_WHILE_IDLE = "true";

  public static final String PROPERTY_DBCP_MIN_EVICTABLE_IDLE_TIME = "dbcp-min-evictable-idle-time";
  public static final String DEFAULT_DBCP_MIN_EVICTABLE_IDLE_TIME = "600";

  public static final String PROPERTY_DBCP_TIME_BETWEEN_EVICTION_RUNS = "dbcp-time-between-eviction-runs";
  public static final String DEFAULT_DBCP_TIME_BETWEEN_EVICTION_RUNS = "120";

  public static final String PROPERTY_DBCP_NUM_TESTS_PER_EVICTION_RUN = "dbcp-num-tests-per-eviction-run";
  public static final String DEFAULT_DBCP_NUM_TESTS_PER_EVICTION_RUN = "5";

  public static final String PROPERTY_DBCP_WHEN_EXHAUSTED_ACTION = "dbcp-when-exhausted-action";
  public static final String DEFAULT_DBCP_WHEN_EXHAUSTED_ACTION = String.valueOf(
      GenericObjectPool.WHEN_EXHAUSTED_GROW
  );

  public static final String PROPERTY_DBCP_VALIDATION_QUERY = "dbcp-validation-query";
  public static final String DEFAULT_DBCP_VALIDATION_QUERY = "SELECT 1";

  public static final String PROPERTY_DBCP_REMOVE_ABANDONED = "dbcp-remove-abandoned";
  public static final String DEFAULT_DBCP_REMOVE_ABANDONED = "true";

  public static final String PROPERTY_DBCP_REMOVE_ABANDONED_TIMEOUT = "dbcp-remove-abandoned-timeout";
  public static final String DEFAULT_DBCP_REMOVE_ABANDONED_TIMEOUT = "120";

  public static final String PROPERTY_DBCP_LOG_ABANDONED = "dbcp-log-abandoned";
  public static final String DEFAULT_DBCP_LOG_ABANDONED = "true";

  public static final String PROPERTY_ATTACHMENT_INDEXING_ENABLED = "attachment-indexing";
  public static final String DEFAULT_ATTACHMENT_INDEXING_ENABLED = "false";

  public static final String PROPERTY_WIKI_SERVER_HOSTNAME = "wiki-server-hostname";
  public static final String DEFAULT_WIKI_SERVER_HOSTNAME = null;
  public static final String PROPERTY_RECENT_CHANGES_REFRESH_INTERVAL = "recentChangesRefreshInterval";
  public static final String DEFAULT_RECENT_CHANGES_REFRESH_INTERVAL = "1";
  public static final String PROPERTY_FILE_ENCODING = "file-encoding";
  public static final String DEFAULT_FILE_ENCODING = "utf-8";

  public static final String PROPERTY_SEPARATE_WIKI_TITLE_WORDS = "separate-wiki-title-words";
  public static final String DEFAULT_SEPARATE_WIKI_TITLE_WORDS = "false";

  public static final String PROPERTY_SUPPRESS_NOTIFY_WITHIN_SAME_DAY = "supress-notify-within-same-day";
  public static final String DEFAULT_SUPPRESS_NOTIFY_WITHIN_SAME_DAY = "false";
  
  private static final HashMap defaults = new HashMap();

  private static Properties properties;

  private static final Logger logger = Logger.getLogger(Environment.class);

  /**
   * the actual local path that is the base of the context, i.e. where the wiki is installed
   */
  private String realPath;


  /**
   * Initialise the environment (put defaults in a table)
   */
  private Environment() {
  	
    logger.debug("new Environment");
    refresh();
    defaults.put(PROPERTY_MAX_FILE_SIZE, DEFAULT_MAX_FILE_SIZE);
    defaults.put(PROPERTY_TEMP_DIR, DEFAULT_TEMP_DIR);
    defaults.put(PROPERTY_SMTP_USERNAME, DEFAULT_SMTP_USERNAME);
    defaults.put(PROPERTY_SMTP_PASSWORD, DEFAULT_SMTP_PASSWORD);
    defaults.put(PROPERTY_FORMAT_LEXER, DEFAULT_FORMAT_LEXER);
    defaults.put(PROPERTY_LINK_LEXER, DEFAULT_LINK_LEXER);
    defaults.put(PROPERTY_LAYOUT_LEXER, DEFAULT_LAYOUT_LEXER);
    defaults.put(PROPERTY_RECENT_CHANGES_DAYS, DEFAULT_RECENT_CHANGES_DAYS);
    defaults.put(PROPERTY_MAXIMUM_BACKLINKS, DEFAULT_MAXIMUM_BACKLINKS);
    defaults.put(PROPERTY_REPLY_ADDRESS, DEFAULT_REPLY_ADDRESS);
    defaults.put(PROPERTY_SMTP_HOST, DEFAULT_SMTP_HOST);
    defaults.put(PROPERTY_NEW_LINE_BREAKS, DEFAULT_NEW_LINE_BREAKS);
    defaults.put(PROPERTY_ALLOW_TEMPLATES, DEFAULT_ALLOW_TEMPLATES);
    defaults.put(PROPERTY_ATTACHMENT_TYPE, DEFAULT_ATTACHMENT_TYPE);
    defaults.put(PROPERTY_COOKIE_EXPIRE, DEFAULT_COOKIE_EXPIRE);
    defaults.put(PROPERTY_CONVERT_TABS, DEFAULT_CONVERT_TABS);
    defaults.put(PROPERTY_FIRST_USE, DEFAULT_FIRST_USE);
    defaults.put(PROPERTY_CONVERT_ENTITIES, DEFAULT_CONVERT_ENTITIES);
    defaults.put(PROPERTY_DEFAULT_TOPIC, DEFAULT_DEFAULT_TOPIC);
    defaults.put(PROPERTY_DATABASE_TYPE, DEFAULT_DATABASE_TYPE);
    defaults.put(PROPERTY_ALLOW_VWIKI_LIST, DEFAULT_ALLOW_VWIKI_LIST);
    defaults.put(PROPERTY_DBCP_MAX_ACTIVE, DEFAULT_DBCP_MAX_ACTIVE);
    defaults.put(PROPERTY_DBCP_MAX_IDLE, DEFAULT_DBCP_MAX_IDLE);
    defaults.put(PROPERTY_DBCP_TEST_ON_BORROW, DEFAULT_DBCP_TEST_ON_BORROW);
    defaults.put(PROPERTY_DBCP_TEST_ON_RETURN, DEFAULT_DBCP_TEST_ON_RETURN);
    defaults.put(PROPERTY_DBCP_TEST_WHILE_IDLE, DEFAULT_DBCP_TEST_WHILE_IDLE);
    defaults.put(PROPERTY_DBCP_MIN_EVICTABLE_IDLE_TIME, DEFAULT_DBCP_MIN_EVICTABLE_IDLE_TIME);
    defaults.put(PROPERTY_DBCP_TIME_BETWEEN_EVICTION_RUNS, DEFAULT_DBCP_TIME_BETWEEN_EVICTION_RUNS);
    defaults.put(PROPERTY_DBCP_NUM_TESTS_PER_EVICTION_RUN, DEFAULT_DBCP_NUM_TESTS_PER_EVICTION_RUN);
    defaults.put(PROPERTY_DBCP_WHEN_EXHAUSTED_ACTION, DEFAULT_DBCP_WHEN_EXHAUSTED_ACTION);
    defaults.put(PROPERTY_DBCP_VALIDATION_QUERY, DEFAULT_DBCP_VALIDATION_QUERY);
    defaults.put(PROPERTY_DBCP_REMOVE_ABANDONED, DEFAULT_DBCP_REMOVE_ABANDONED);
    defaults.put(PROPERTY_DBCP_REMOVE_ABANDONED_TIMEOUT, DEFAULT_DBCP_REMOVE_ABANDONED_TIMEOUT);
    defaults.put(PROPERTY_DBCP_LOG_ABANDONED, DEFAULT_DBCP_LOG_ABANDONED);
    defaults.put(PROPERTY_WIKI_SERVER_HOSTNAME, DEFAULT_WIKI_SERVER_HOSTNAME);
    defaults.put(PROPERTY_FILE_ENCODING, DEFAULT_FILE_ENCODING);
    defaults.put(PROPERTY_ATTACHMENT_INDEXING_ENABLED, DEFAULT_ATTACHMENT_INDEXING_ENABLED);
    defaults.put(PROPERTY_RECENT_CHANGES_REFRESH_INTERVAL, DEFAULT_RECENT_CHANGES_REFRESH_INTERVAL);
    defaults.put(PROPERTY_SEPARATE_WIKI_TITLE_WORDS, DEFAULT_SEPARATE_WIKI_TITLE_WORDS);
    defaults.put(PROPERTY_SUPPRESS_NOTIFY_WITHIN_SAME_DAY, DEFAULT_SUPPRESS_NOTIFY_WITHIN_SAME_DAY);
    logger.info("Using properties file location: " + getPropertiesFileLocation());
  }

  public static String relativeDirIfNecessary(String path) {
    if (path.length() <= 2) {
      return path;
    }
    if (!path.startsWith("/") && !(Character.isLetter(path.charAt(0)) && path.charAt(1) == ':')) {
      return new File(dir(), path).getAbsolutePath();
    }
    return path;
  }

  /**
   * The directory to place attachments in. This is either an absolute path if the admin setting for "upload directory"
   * starts with a "/" or a drive letter, or it is a relative path.
   * @param virtualWiki
   * @param name
   * @return
   */
  public File uploadPath(String virtualWiki, String name) {
    String dir = Environment.relativeDirIfNecessary(Environment.getInstance().getUploadDir());
    if (virtualWiki == null || "".equals(virtualWiki)) {
      virtualWiki = WikiBase.DEFAULT_VWIKI;
    }
    File baseDir = new File(dir, virtualWiki);
    baseDir.mkdirs();
    dir = baseDir.getAbsolutePath();
    File uploadedFile = new File(
        dir,
        name
    );
    return uploadedFile;
  }
  
  /**
   * The directory to place attachments in. This is either an absolute path if the admin setting for "upload directory"
   * starts with a "/" or a drive letter, or it is a relative path.
   * @param virtualWiki
   * @param name
   * @return
   */
  public boolean uploadExists(String virtualWiki, String name) {
  	File f = uploadPath(virtualWiki, name);
  	return f.exists();
  }
  

  /**
   * Get a stream from a resource name using this classes class loader
   * @param resourceName
   * @return
   */
  public InputStream getResourceAsStream(String resourceName) {
    return Environment.class.getResourceAsStream(resourceName);
  }

  /**
   * Get default value for an admin property
   * @param settingName
   * @return
   */
  private String defaultValue(String settingName) {
    return (String) defaults.get(settingName);
  }

  /**
   * Return a location to store/retrieve the VQWiki properties file. This is in order of precedence:
   * <ol>
   *   <li>The path given by the context environment entry "propertiesFile"</li>
   *   <li>The path found by looking for the resource named "/vqwiki.properties" using the class loader
   * for this class. This will usually be located in WEB-INF/classes</li>
   *   <li>A file called vqwiki.properties in the process owner's home directory</li>
   * </ol>
   * @return properties file location
   */
  private String getPropertiesFileLocation() {
    String propertiesFilePath = null;
    try {
      InitialContext ictx = new InitialContext();
      propertiesFilePath = (String) ictx.lookup("java:comp/env/propertiesFile");
      logger.debug("properties file from context: " + propertiesFilePath);
    }
    catch (Exception e) {
      logger.debug("No entry for properties in context:\n" + e.toString());
    }
    if (propertiesFilePath == null) {
      URL resource = Environment.class.getResource("/vqwiki.properties");
      logger.debug("properties file as resource: " + resource);
      if (resource != null) {
//      propertiesFilePath = URLDecoder.decode(resource.getFile());
    	propertiesFilePath = resource.getFile();
    	try {
    		propertiesFilePath = URLDecoder.decode(resource.getFile(),JSPUtils.DEFAULTENCODING);
    	} catch (Exception e) {}
        logger.debug("properties file as file from resource: " + propertiesFilePath);
      }
    }
    if (propertiesFilePath == null) {
      StringBuffer buffer = new StringBuffer();
      buffer.append(System.getProperty("user.home"));
      buffer.append(System.getProperty("file.separator"));
      buffer.append("wiki/vqwiki.properties");
    }
    return propertiesFilePath;
  }

  private InputStream getPropertiesInputStream() throws Exception {
    String propertiesFile = getPropertiesFileLocation();
    if (propertiesFile == null) {
      return getResourceAsStream("/vqwiki.properties");
    }
    return new FileInputStream(propertiesFile);
  }

  public String getStringSetting(String settingName) {
    try {
      if (properties == null) {
        properties = new Properties();
        properties.load(getPropertiesInputStream());
      }
    }
    catch (Exception e) {
      logger.error(e);
      return defaultValue(settingName);
    }
    String value = properties.getProperty(settingName);
    if (value == null) {
      return defaultValue(settingName);
    }
    return value;
  }

  public int getIntSetting(String settingName) {
    String asString = getStringSetting(settingName);
    logger.debug("Setting as string:" + asString);
    return Integer.parseInt(asString);
  }

  public boolean getBooleanSetting(String settingName) {
    return Boolean.valueOf(getStringSetting(settingName)).booleanValue();
  }

  public void setSetting(String settingName, String value) throws Exception {
    try {
      if (properties == null) {
        properties = new Properties();
        properties.load(getPropertiesInputStream());
      }
    }
    catch (Exception e) {
      logger.error("Error setting " + settingName, e);
      return;
    }
    properties.setProperty(settingName, value);
  }

  public void setSetting(String settingName, boolean value) throws Exception {
    setSetting(settingName, String.valueOf(value));
  }

  public void setSetting(String settingName, int value) throws Exception {
    setSetting(settingName, String.valueOf(value));
  }

  public boolean getForceUsername() {
    return this.forceUsername;
  }

  /**
   * Re-read the properties file and sets the home directory. If no properties
   * file is found it will be the user's home directory + "/wiki"
   */
  public void refresh() {
    Properties prop = new Properties();
    File f = null;
    try {
      f = getPropsFile();
      logger.debug("Loading properties from " + f);
      prop.load(new FileInputStream(f));
      //dir
      if (prop.getProperty("homeDir") == null) {
        homeDir = System.getProperty("user.home") +
            System.getProperty("file.separator") + "wiki";
      }
      else {
        homeDir = prop.getProperty("homeDir");
      }
      //uploadDir
      if (prop.getProperty("uploadDir") == null) {
        uploadDir = DEFAULT_UPLOAD_DIR;
      }
      else {
        uploadDir = prop.getProperty("uploadDir");
      }
      //allow back-tick
      if (prop.getProperty("attachmentsToDatabase") == null) {
        allowBackTick = DEFAULT_ATTACHMENTS_TO_DATABASE;
      }
      else {
        allowBackTick = Boolean.valueOf(prop.getProperty("allowBackTick")).booleanValue();
      }
      //indexRefreshInterval
      if (prop.getProperty("indexRefreshInterval") == null) {
        indexRefreshInterval = DEFAULT_INDEX_REFRESH_INTERVAL;
      }
      else {
        indexRefreshInterval = Integer.parseInt(prop.getProperty("indexRefreshInterval"));
      }
      //recentChangesRefreshInterval
      if (prop.getProperty(PROPERTY_RECENT_CHANGES_REFRESH_INTERVAL) == null) {
        recentChangesRefreshInterval = Integer.parseInt(DEFAULT_RECENT_CHANGES_REFRESH_INTERVAL);
      }
      else {
        recentChangesRefreshInterval = Integer.parseInt(prop.getProperty(PROPERTY_RECENT_CHANGES_REFRESH_INTERVAL));
      }
      //allowHTML
      if (prop.getProperty("allowHTML") == null) {
        allowHTML = DEFAULT_ALLOW_HTML;
      }
      else {
        allowHTML = (Boolean.valueOf(prop.getProperty("allowHTML"))).booleanValue();
      }
      //persistenceType
      if (prop.getProperty("persistenceType") == null) {
        persistenceType = DEFAULT_PERSISTENCE_TYPE;
      }
      else {
        persistenceType = prop.getProperty("persistenceType");
      }
      //versioningOn
      if (prop.getProperty("versioningOn") == null) {
        versioningOn = DEFAULT_VERSIONING_ON;
      }
      else {
        versioningOn = (Boolean.valueOf(prop.getProperty("versioningOn"))).booleanValue();
      }
      //editTimeOut
      if (prop.getProperty("editTimeOut") == null) {
        editTimeOut = DEFAULT_EDIT_TIME_OUT;
      }
      else {
        editTimeOut = Integer.parseInt(prop.getProperty("editTimeOut"));
      }
      //allow back-tick
      if (prop.getProperty("allowBackTick") == null) {
        allowBackTick = DEFAULT_ALLOW_BACK_TICK;
      }
      else {
        allowBackTick = Boolean.valueOf(prop.getProperty("allowBackTick")).booleanValue();
      }
      //driver
      if (prop.getProperty("driver") == null) {
        this.driver = DEFAULT_DRIVER;
      }
      else {
        this.driver = prop.getProperty("driver");
      }
      //url
      if (prop.getProperty("url") == null) {
        this.url = DEFAULT_URL;
      }
      else {
        this.url = prop.getProperty("url");
      }
      //username
      if (prop.getProperty("username") == null) {
        this.userName = DEFAULT_USERNAME;
      }
      else {
        this.userName = prop.getProperty("username");
      }
      //password
      if (prop.getProperty("password") == null) {
        this.password = DEFAULT_PASSWORD;
      }
      else {
        this.password = prop.getProperty("password");
      }
      // force username
      if (prop.getProperty("force-username") == null) {
        this.forceUsername = DEFAULT_FORCE_USERNAME;
      }
      else {
        this.forceUsername = Boolean.valueOf(prop.getProperty("force-username")).booleanValue();
      }
    }
    catch (Exception e) {
      logger.debug("Couldn't access properrties file, using static defaults: " + f);
      logger.debug("Handled exception: " + e);
      this.homeDir = System.getProperty("user.home") +
          System.getProperty("file.separator") + "wiki";
      this.uploadDir = DEFAULT_UPLOAD_DIR;
      this.indexRefreshInterval = DEFAULT_INDEX_REFRESH_INTERVAL;
      this.recentChangesRefreshInterval = Integer.parseInt(DEFAULT_RECENT_CHANGES_REFRESH_INTERVAL);
      this.allowHTML = DEFAULT_ALLOW_HTML;
      this.persistenceType = DEFAULT_PERSISTENCE_TYPE;
      this.versioningOn = DEFAULT_VERSIONING_ON;
      this.editTimeOut = DEFAULT_EDIT_TIME_OUT;
      this.allowBackTick = DEFAULT_ALLOW_BACK_TICK;
      this.driver = DEFAULT_DRIVER;
      this.url = DEFAULT_URL;
      this.userName = DEFAULT_USERNAME;
      this.password = DEFAULT_PASSWORD;
      this.forceUsername = DEFAULT_FORCE_USERNAME;
      this.attachmentsToDatabase = DEFAULT_ATTACHMENTS_TO_DATABASE;
    }
    logger.debug("Properties: " + prop);

    this.logoImageName = lookupLogoImageName();

    if (getPersistenceType() == WikiBase.DATABASE) {
      DatabaseConnection.setPoolInitialized(false);
    }
  }

  public void saveProperties() throws Exception {
    File f = getPropsFile();
    logger.debug("Writing to properties file: " + f);
    if (properties == null) {
      properties = new Properties();
    }
    //FileOutputStream out = new FileOutputStream( f );
    OutputStream out = getPropertiesOutputStream();
    properties.setProperty("uploadDir", this.uploadDir);
    properties.setProperty("indexRefreshInterval", String.valueOf(this.indexRefreshInterval));
    properties.setProperty(
        PROPERTY_RECENT_CHANGES_REFRESH_INTERVAL,
        String.valueOf(recentChangesRefreshInterval)
    );
    properties.setProperty("allowHTML", String.valueOf(this.allowHTML));
    properties.setProperty("persistenceType", this.persistenceType);
    properties.setProperty("versioningOn", String.valueOf(this.versioningOn));
    properties.setProperty("editTimeOut", String.valueOf(this.editTimeOut));
    properties.setProperty("homeDir", this.homeDir);
    properties.setProperty("allowBackTick", String.valueOf(this.allowBackTick));
    properties.setProperty("driver", this.driver);
    properties.setProperty("url", this.url);
    properties.setProperty("username", this.userName);
    properties.setProperty("password", this.password);
    properties.setProperty("force-username", String.valueOf(this.forceUsername));
    logger.debug(properties);
    properties.store(out, "VQWiki");
    out.close();
  }

  /**
   * Singleton reinforcement
   */
  public static Environment getInstance() {
    if (instance == null) {
      instance = new Environment();
    }
    return instance;
  }

  private File getPropsFile() throws Exception {
    return new File(getPropertiesFileLocation());
  }

  /**
   * Returns the base directory for the Wiki file-system
   */
  public String getHomeDir() {
    return homeDir;
  }

  public void setHomeDir(String dir) {
    this.homeDir = dir;
  }

  /**
   * Returns the directory for uploading topic attachments to
   */
  public String getUploadDir() {
    return uploadDir;
  }

  public int getIndexRefreshInterval() {
    return this.indexRefreshInterval;
  }

  public void setIndexRefreshInterval(int interval) {
    this.indexRefreshInterval = interval;
  }

  public int getRecentChangesRefreshInterval() {
    return recentChangesRefreshInterval;
  }

  public void setRecentChangesRefreshInterval(int interval) {
    recentChangesRefreshInterval = interval;
  }

  public boolean getAllowHTML() {
    return this.allowHTML;
  }

  public void setAllowHTML(boolean allow) {
    this.allowHTML = allow;
  }

  public boolean isVersioningOn() {
    return this.versioningOn;
  }

  public void setVersioningOn(boolean on) {
    this.versioningOn = on;
  }

  public int getPersistenceType() {
    if (this.persistenceType.equals("DATABASE")) {
      return WikiBase.DATABASE;
    }
    else {
      return WikiBase.FILE;
    }
  }

  public void setPersistenceType(int persistenceType) {
    if (persistenceType == WikiBase.FILE) {
      this.persistenceType = "FILE";
    }
    else if (persistenceType == WikiBase.DATABASE) {
      this.persistenceType = "DATABASE";
    }
  }

  public int getEditTimeOut() {
    return this.editTimeOut;
  }

  public void setEditTimeOut(int timeout) {
    this.editTimeOut = timeout;
  }

  public void setUploadDir(String dir) {
    this.uploadDir = dir;
  }

  public static String dir() {
    return getInstance().getHomeDir() + System.getProperty("file.separator");
  }

  public String getBaseContext() {
    return baseContext;
  }

  public void setBaseContext(String baseContext) {
    this.baseContext = baseContext;
  }

  public boolean isAllowBackTick() {
    return allowBackTick;
  }

  public void setAllowBackTick(boolean allowBackTick) {
    this.allowBackTick = allowBackTick;
  }

  public boolean isAttachmentsToDatabase() {
    return attachmentsToDatabase;
  }

  public void setAttachmentsToDatabase(boolean _attachmentsToDatabase) {
    this.attachmentsToDatabase = _attachmentsToDatabase;
  }

  public String getDriver() {
    return driver;
  }

  public void setDriver(String driver) {
    this.driver = driver;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public boolean isForceUsername() {
    return forceUsername;
  }

  public void setForceUsername(boolean forceUsername) {
    this.forceUsername = forceUsername;
  }

  public String getLogoImageName() {
    return this.logoImageName;
  }

  public boolean isDefaultLogoImageName() {
    return DEFAULT_LOGO_IMAGE_NAME.equals(logoImageName);
  }

  public boolean isLogoImageAbsoluteUrl() {
    return lookupLogoImageName().indexOf(':') >= 0;
  }

  public boolean isEmailAvailable() {
    String smtpHost = this.getStringSetting(PROPERTY_SMTP_HOST);
    if (smtpHost != null) {
      return !"".equals(smtpHost);
    }
    return false;
  }

  public boolean isAllowVirtualWikiList() {
    return this.getBooleanSetting(PROPERTY_ALLOW_VWIKI_LIST);
  }

  public boolean isTemplatesAvailable() {
    return this.getBooleanSetting(PROPERTY_ALLOW_TEMPLATES);
  }

  public boolean isConvertTabs() {
    return this.getBooleanSetting(PROPERTY_CONVERT_TABS);
  }

  public String getDefaultTopic() {
    return this.getStringSetting(PROPERTY_DEFAULT_TOPIC);
  }

  public String getDefaultTopicEncoded() {
    return JSPUtils.encodeURL(this.getStringSetting(PROPERTY_DEFAULT_TOPIC), JSPUtils.DEFAULTENCODING);
  }

  private String lookupLogoImageName() {
    String _logoImageName = null;
    try {
      InitialContext ictx = new InitialContext();
      _logoImageName = (String) ictx.lookup("java:comp/env/logoImageName");
      if (_logoImageName != null && !"".equals(logoImageName)) {
        return _logoImageName;
      }
    }
    catch (Exception e) {
      logger.debug("Exception retrieving logoImageName:\n" + e.toString());
    }

    return DEFAULT_LOGO_IMAGE_NAME;

  }

  private OutputStream getPropertiesOutputStream() throws Exception {
    String propertiesFile = getPropertiesFileLocation();
    return new FileOutputStream(propertiesFile, false);
  }

  public boolean isFirstUse() {
    if (getBooleanSetting(PROPERTY_FIRST_USE)) {
      logger.info("First use of VQWiki, creating admin password");
      try {
        setSetting(PROPERTY_ADMIN_PASSWORD, generateNewAdminPassword());
        setSetting(PROPERTY_FIRST_USE, false);
        saveProperties();
      }
      catch (Exception e) {
        logger.error(e);
      }
      return true;
    }
    return false;
  }

  public String getAdminPassword() {
    return getStringSetting(PROPERTY_ADMIN_PASSWORD);
  }

  public String generateNewAdminPassword() throws Exception {
    StringBuffer buffer = new StringBuffer();
    for (int i = 0; i < 5; i++) {
      int n = (int) (Math.random() * 26 + 65);
      buffer.append((char) n);
    }
    String value = buffer.toString();
    return value;
  }

  public boolean isMySQL() {
    return ("mysql".equalsIgnoreCase(getDatabaseType()));
  }

  public boolean isOracle() {
    return ("oracle".equalsIgnoreCase(getDatabaseType()));
  }

  public String getDatabaseType() {
    return getStringSetting(PROPERTY_DATABASE_TYPE);
  }

  public String getFileEncoding() {
    return getStringSetting(PROPERTY_FILE_ENCODING);
  }

  public boolean doIgnoreWikiname(String name) {
    if (wikinameIgnore == null) {
      wikinameIgnore = new ArrayList();
      InputStream in = getClass().getResourceAsStream("/wikiname.ignore");
      if (in == null) {
        logger.debug("No wikinames to ignore, wikiname.ignore does not exist");
        return false;
      }
      try {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while (true) {
          String line = reader.readLine();
          if (line == null) {
            break;
          }
          logger.debug("Adding " + line.toLowerCase() + " to ignore list");
          wikinameIgnore.add(line.toLowerCase());
        }
        reader.close();
        in.close();
      }
      catch (IOException e) {
        logger.warn("Error reading wikiname.ignore", e);
      }
    }
    if (wikinameIgnore.isEmpty()) {
      return false;
    }
    boolean ignore = wikinameIgnore.contains(name.toLowerCase());
    if (ignore) {
      logger.debug("Do ignore " + name);
    }
    return ignore;
  }

  public boolean isAttachmentIndexingEnabled() {
    return getBooleanSetting(PROPERTY_ATTACHMENT_INDEXING_ENABLED);
  }

  /**
   * Return true if titles are to be spaced between the humps in the CamelCaps, e.g "Camel Caps"
   *
   * @return true if separate title words is on
   */
  public boolean isSeparateWikiTitleWords() {
    return this.getBooleanSetting(PROPERTY_SEPARATE_WIKI_TITLE_WORDS);
  }
  
  /**
   * This is set by the main controller servlet on every request
   * @param realPath the actual local path that is the base of the context
   */
   public void setRealPath(String realPath) {
     logger.debug("real path: " + realPath);
     this.realPath = realPath;
   }

  /**
   * the actual local path that is the base of the context
   * @return path
   */
   public String getRealPath() {
    return realPath;
   }
  
  public String toString () {
  	return properties.toString();
  }


}