/**
 * @author garethc
 *  22/10/2002 13:20:38
 */
package vqwiki;

import java.util.Random;
import java.util.ResourceBundle;
import java.net.MalformedURLException;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import vqwiki.utils.JSPUtils;
import vqwiki.utils.Utilities;

public abstract class AbstractWikiMembers implements WikiMembers {
  protected String virtualWiki;
  private static final Logger logger = Logger.getLogger(AbstractWikiMembers.class);
  private static final int KEY_LENGTH = 20;
  private static Random rn = new Random();


  /**
   * Confirms a member (that is, gives them the ability to set notifications and reminders)
   * if the supplied key matches the key generated when the account was created. It is expected
   * that another class or JSP page will call this function at the request of a user.
   *
   * @param username  the name of the user to confirm
   * @param key the key to compare to the key generated when the account was created
   * @return boolean  True if the user is in the list.
   */
  public boolean confirmMembership(String username, String key) throws Exception {
    WikiMember aMember = findMemberByName(username);
    logger.debug("Confirming membership by key " + key + " for " + aMember);
    if (aMember.isConfirmed()) return true;
    return false;
  }

  /**
   * Send the confirmation email to the member
   */
  protected void mailMember(String username, HttpServletRequest request, WikiMember aMember, String email) {
  	String characterEncoding = Utilities.extractCharacterEncoding(request);
  	
    ResourceBundle messages = Utilities.getMessages(request.getLocale());

    // Send an email to the requester with the generated key
    logger.debug("Sending email to " + email);
    StringBuffer buffer = new StringBuffer();
    buffer.append(username);
    buffer.append("\n");
    buffer.append(messages.getString("mail.confirmation.body"));
    buffer.append("\n\n");
    String wikiServerHostname = Environment.getInstance().getStringSetting(Environment.PROPERTY_WIKI_SERVER_HOSTNAME);
    try {
        buffer.append(Utilities.extractVirtualWikiContext(request, wikiServerHostname));
     } catch (MalformedURLException e) {
    	buffer.append(Utilities.extractVirtualWikiContext(request));
        logger.error("", e);
    }
//  buffer.append("/");
//  buffer.append(virtualWiki);
//  buffer.append("/Wiki");
    buffer.append("?userName=");
    buffer.append(JSPUtils.encodeURL(username, characterEncoding));
    buffer.append("&key=");
    buffer.append(aMember.getKey());
    buffer.append("&action=action_member");
    WikiMail mailer = WikiMail.getInstance();
    String replyAddress = Environment.getInstance().getStringSetting(Environment.PROPERTY_REPLY_ADDRESS);
    mailer.sendMail(
        replyAddress, email,
        messages.getString("mail.confirmation.subject"),
        buffer.toString()
    );
  }

  /**
   * Create a new member with a random key
   */
  protected WikiMember createMember(String username, String email) {
    // Generate a key to confirm the request
    WikiMember aMember = new WikiMember(username, email);
    byte b[] = new byte[KEY_LENGTH];
    for (int i = 0; i < KEY_LENGTH; i++)
      b[i] = (byte) (rn.nextInt(26) + 65);
    String newKey = new String(b);
    aMember.setKey(newKey);
    return aMember;
  }
}

// $Log: AbstractWikiMembers.java,v $
// Revision 1.13  2003/10/05 05:07:30  garethc
// fixes and admin file encoding option + merge with contributions
//
// Revision 1.12  2003/09/21 20:52:43  garethc
// merge and typos
//
// Revision 1.11  2003/05/14 19:02:58  mrgadget4711
// MOD: Internationalization extended
//
// Revision 1.10  2003/04/28 03:54:41  garethc
// beginning of work on import tool
//
// Revision 1.9  2003/04/15 23:10:57  garethc
// lucene fixes
//
// Revision 1.8  2003/04/09 20:44:09  garethc
// package org
//
// Revision 1.7  2003/02/18 20:48:07  garethc
// 2.4.0 RC3
//
// Revision 1.6  2003/01/07 23:54:39  garethc
// almost finished taglibs
//
// Revision 1.5  2003/01/07 03:11:51  garethc
// beginning of big cleanup, taglibs etc
//
// Revision 1.4  2002/12/08 20:58:58  garethc
// 2.3.6 almost ready
//
// Revision 1.3  2002/12/02 19:26:51  garethc
// fixes
//
// Revision 1.2  2002/11/11 22:19:23  garethc
// printable page
//
// Revision 1.1  2002/10/22 20:14:32  garethc
// 2.2.0
//