/**
 * @author garethc
 *  22/10/2002 11:52:37
 */
package vqwiki;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;

import org.apache.log4j.Logger;

import vqwiki.utils.Utilities;
import vqwiki.utils.JSPUtils;

public abstract class AbstractNotify implements Notify {

  private static final Logger logger = Logger.getLogger(AbstractNotify.class);

  protected String topicName;
  protected String virtualWiki;

  public abstract void addMember(String userName) throws Exception;

  public abstract void removeMember(String userName) throws Exception;

  public abstract boolean isMember(String userName) throws Exception;

  public abstract Collection getMembers() throws Exception;

  public boolean sendNotifications(String rootPath, Locale locale) throws Exception {
    logger.debug("sending notifications for path " + rootPath);
    ResourceBundle messages = Utilities.getMessages(locale);

    WikiMembers members = WikiBase.getInstance().getWikiMembersInstance(virtualWiki);
    logger.debug(members.getAllMembers().size() + " members found");
    WikiMail mailer = WikiMail.getInstance();
    Iterator anIterator = getMembers().iterator();
    while (anIterator.hasNext()) {
      String aUsername = (String) anIterator.next();
      logger.debug("notification for " + aUsername);
      WikiMember aMember = members.findMemberByName(aUsername);
      String replyAddress = Environment.getInstance().getStringSetting(Environment.PROPERTY_REPLY_ADDRESS);
      StringBuffer buffer = new StringBuffer();
      buffer.append(messages.getString("mail.notification.body.line1"));
      buffer.append(" ");
      buffer.append(topicName);
      buffer.append("\n\n");
      if (!this.virtualWiki.equals(WikiBase.DEFAULT_VWIKI)) {
        buffer.append(messages.getString("mail.notification.body.line2"));
        buffer.append(" ");
        buffer.append(this.virtualWiki);
        buffer.append("\n\n");
      }
      buffer.append(rootPath + "Wiki?" + JSPUtils.encodeURL(topicName, JSPUtils.DEFAULTENCODING));
      buffer.append("\n\n");

      Topic topicObject = new Topic(topicName);

      String author = null;
      java.util.Date lastRevisionDate = null;

      if (Environment.getInstance().isVersioningOn()) {
        lastRevisionDate = topicObject.getMostRecentRevisionDate(virtualWiki);
        if (lastRevisionDate != null) {
          buffer.append(messages.getString("mail.notification.body.revision"));
          buffer.append(" ");
          buffer.append(Utilities.formatDateTime(lastRevisionDate));
          buffer.append("\n\n");

          Collection c = WikiBase.getInstance().getChangeLogInstance().getChanges(virtualWiki, lastRevisionDate);
          if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
              Change thischange = (Change) it.next();
              if (thischange.getTopic().equals(topicName)) {
                author = thischange.getUser();
              }
            }
          }
        }
      }

      if (author != null) {
        buffer.append(messages.getString("mail.notification.body.author"));
        buffer.append(" ");
        buffer.append(author);
        buffer.append("\n");
      }
      buffer.append("\n");
      buffer.append(messages.getString("mail.notification.body.diff"));
      buffer.append("\n");
      buffer.append(topicObject.mostRecentDiff(this.virtualWiki, false));

      buffer.append("\n\n\n----\n\n");
      logger.debug("Sending notification email to " + aMember.getEmail() + " for " + virtualWiki + "/" + topicName);
      mailer.sendMail(replyAddress, aMember.getEmail(), messages.getString("mail.notification.subject"), buffer.toString());
    }
    return true;

  }

  public String getTopicName() {
    return topicName;
  }

  public String getVirtualWiki() {
    return virtualWiki;
  }
}