/*
Very Quick Wiki - WikiWikiWeb clone
Copyright (C) 2001-2002 Gareth Cronin

This program is free software; you can redistribute it and/or modify
it under the terms of the latest version of the GNU Lesser General
Public License as published by the Free Software Foundation;

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program (gpl.txt); if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package vqwiki.servlets.beans;

import java.util.List;

/**
 * Bean, which holds one sitemap entry
 *
 * This class was created on 19:39:43 20.07.2003
 *
 * @author $Author: garethc $
 */
public class SitemapBean {

  private String name;

  private List pages;


  /**
   * @return
   */
  public String getName() {
    return name;
  }

  /**
   * @return
   */
  public List getPages() {
    return pages;
  }

  /**
   * @param string
   */
  public void setName(String string) {
    name = string;
  }

  /**
   * @param list
   */
  public void setPages(List list) {
    pages = list;
  }

  public String getNumpages() {
    if (pages == null) return "0";
    return String.valueOf(pages.size());
  }

}

/*
 * Log:
 *
 * $Log: SitemapBean.java,v $
 * Revision 1.2  2003/10/05 05:07:32  garethc
 * fixes and admin file encoding option + merge with contributions
 *
 * Revision 1.1  2003/07/20 20:34:40  mrgadget4711
 * ADD: Sitemap
 *
 * ------------END------------
 */