/*
 * Copyright 2002 Gareth Cronin
 * This software is subject to the GNU Lesser General Public Licence (LGPL)
 */
package vqwiki.servlets;

import javax.servlet.ServletException;

import org.apache.log4j.Logger;

public class WikiServletException extends ServletException {
//protected static org.apache.log4j.Category cat = org.apache.log4j.Category.getInstance(WikiServletException.class);
  protected static Logger cat = Logger.getLogger(WikiServletException.class);

  public final static int UNKNOWN = -1;
  public final static int TOPIC_LOCKED = 0;
  public final static int LOCK_TIMEOUT = 1;
  public final static int READ_ONLY = 2;
  public final static int FILE_EXISTS = 3;
  
  protected int type;

  public WikiServletException(int type, String s) {
  	super(s);
  	setType (type);
  }
  public WikiServletException(String s) {
    super(s);
    setType(-1);
  }

  public WikiServletException(int type) {
  	setType(type);
  }

  public int getType() {
    return type;
  }

  public void setType(int type) {
    this.type = type;
  }

  public String toString() {
    return super.toString() + "\nType: " + this.type + ", " + this.getMessage();
  }

}
