/**
 * Delivers an attachment to the browser. Sends as a binary stream along with a content-type
 * determined by the mime.types file in the classpath.
 *
 * @author garethc
 * 25/10/2002 14:18:32
 */
package vqwiki.servlets;

import org.apache.log4j.Logger;
import vqwiki.Environment;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class ViewAttachmentServlet extends VQWikiServlet {

  private static final Logger logger = Logger.getLogger(ViewAttachmentServlet.class);

  protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    Environment en = Environment.getInstance();
    String attachmentName = request.getParameter("attachment");
    String virtualWiki = (String) request.getAttribute("virtual-wiki");
    File uploadPath = en.uploadPath(virtualWiki, attachmentName);
    response.reset();
    // attachments can be "inline" or "attachment"
    response.setHeader(
        "Content-Disposition", en.getStringSetting(Environment.PROPERTY_ATTACHMENT_TYPE) +
                               ";filename=" + attachmentName + ";"
    );
    if (attachmentName.indexOf('.') >= 0) {
      if (attachmentName.indexOf('.') < attachmentName.length() - 1) {
        String extension = attachmentName.substring(attachmentName.lastIndexOf('.') + 1);
        logger.debug("Extension: " + extension);
        try {
          String mimetype = (String) getMimeByExtension().get(extension.toLowerCase());
          logger.debug("MIME: " + mimetype);
          if (mimetype != null) {
            logger.debug("Setting content type to: " + mimetype);
            response.setContentType(mimetype);
          }
        }
        catch (Exception e) {
          error(request, response, new WikiServletException(e.getMessage()));
          return;
        }
      }
    }
    FileInputStream in = new FileInputStream(uploadPath);
    ServletOutputStream out = response.getOutputStream();
    int bytesRead = 0;
    byte byteArray[] = new byte[4096];

    // Read in bytes through file stream, and write out through servlet stream
    while ((bytesRead = in.read(byteArray)) != -1) {
      out.write(byteArray, 0, bytesRead);
    }
    in.close();
    out.flush();
    out.close();
  }

  protected HashMap getMimeByExtension() throws Exception {
    HashMap map = new HashMap();
    InputStream resourceAsStream = Environment.getInstance().getResourceAsStream("/mime.types");
    if (resourceAsStream == null) {
      logger.warn("couldn't find the MIME types file mime.types");
      return map;
    }
    BufferedReader in =
        new BufferedReader(new InputStreamReader(
            resourceAsStream
        ));
    while (true) {
      String line = in.readLine();
      if (line == null) break;
      if (!line.startsWith("#") && !line.trim().equals("")) {
        StringTokenizer tokens = new StringTokenizer(line);
        if (tokens.hasMoreTokens()) {
          String type = tokens.nextToken();
          while (tokens.hasMoreTokens()) {
            map.put(tokens.nextToken(), type);
          }
        }
      }
    }
    return map;
  }
}

// $Log: ViewAttachmentServlet.java,v $
// Revision 1.8  2004/04/27 04:23:30  coljac
// Fixed getting extension from file attachment.(Bug 926148)
//
// Revision 1.7  2003/10/05 05:07:32  garethc
// fixes and admin file encoding option + merge with contributions
//
// Revision 1.6  2003/04/15 23:11:04  garethc
// lucene fixes
//
// Revision 1.5  2003/04/15 08:33:12  mrgadget4711
// ADD: Search using Lucene
// ADD: RSS feed
//
// Revision 1.4  2003/04/09 20:44:29  garethc
// package org
//
// Revision 1.3  2003/03/31 20:35:27  garethc
// wikiname.ignore
//
// Revision 1.2  2003/03/11 20:21:16  garethc
// fixes and 2.5 enhancements
//
// Revision 1.1  2003/02/02 19:41:25  garethc
// servlets
//
// Revision 1.5  2003/01/07 03:11:53  garethc
// beginning of big cleanup, taglibs etc
//
// Revision 1.4  2002/12/02 19:26:51  garethc
// fixes
//
// Revision 1.3  2002/11/22 02:53:51  garethc
// 2.3.5
//
// Revision 1.2  2002/11/07 21:47:45  garethc
// part way through 2 part lex
//
// Revision 1.1  2002/11/01 03:12:43  garethc
// starting work on new two pass lexer
//