package vqwiki.servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.ResourceBundle;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import vqwiki.ChangeLog;
import vqwiki.Environment;
import vqwiki.WikiBase;
import vqwiki.utils.Utilities;

/**
 * @author garethc
 * Date: 7/03/2003
 */
public class RecentChangesServlet extends VQWikiServlet {

    private Object lock = new Object();
    private Hashtable lastReloadTime = new Hashtable ();
    private Hashtable lastAll = new Hashtable ();
    private static final Logger logger = Logger
        .getLogger(RecentChangesServlet.class);

    protected void doGet(HttpServletRequest request, 
                         HttpServletResponse response) 
                         throws ServletException, IOException 
    {        
        String virtualWiki = (String)request.getAttribute("virtual-wiki");
        Collection all = new ArrayList();
        if (mustReload(virtualWiki)) {        
            try {
                all = reload(virtualWiki);
                lastAll.put(virtualWiki, all);
            } catch (Exception e) {
                error(request, response, e);
                return;
            }
          } else {
        	all = (Collection) lastAll.get(virtualWiki);
          }
        
        ResourceBundle messages = Utilities.getMessages(request.getLocale());

        request.setAttribute("title", messages.getString("recentchanges.title"));
        request.setAttribute("changes", all);
        dispatch("/jsp/recentChanges.jsp", request, response);
    }


    private Collection reload (String virtualWiki) throws Exception {
        synchronized (lock) {
            logger.debug("Reloading recent changes");
            Calendar cal = Calendar.getInstance();
            ChangeLog cl = WikiBase.getInstance().getChangeLogInstance();           
            int n = Environment.getInstance()
                .getIntSetting(Environment.PROPERTY_RECENT_CHANGES_DAYS);
            
            if (n == 0) { 
                n = 5;
            }
            
            Collection all = new ArrayList();
            for (int i = 0; i < n; i++) {
                Collection col = cl.getChanges(virtualWiki, cal.getTime());
                if (col != null)
                  all.addAll(col);
                cal.add(Calendar.DATE, -1);
            }
            Long reloadTime = new Long (System.currentTimeMillis());
            lastReloadTime.put(virtualWiki, reloadTime);
            return all;
        }
    }
    
    private long getDeltaMillisReload() {
        return Environment.getInstance()
            .getRecentChangesRefreshInterval() * 1000 * 60;
    }
    
    private boolean mustReload(String virtualWiki) {
        long delta = getDeltaMillisReload();
        logger.debug("delta = " + delta);
        Long reloadTime = (Long) lastReloadTime.get(virtualWiki);
        if (reloadTime != null) {
        	return ((System.currentTimeMillis() - reloadTime.longValue()) > delta);
        } else {
        	return ((System.currentTimeMillis()) > delta);        	
        }
    }    
}
