/**
 * @author garethc
 *  15/10/2002 15:06:53
 */
package vqwiki.servlets;

import vqwiki.Notify;
import vqwiki.WikiBase;
import vqwiki.WikiException;
import vqwiki.utils.JSPUtils;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class NotifyServlet extends HttpServlet {
  protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    String virtualWiki = null;
    String topic = null;

    try {
      virtualWiki = (String) request.getAttribute("virtual-wiki");
      String action = request.getParameter("notify_action");
      topic = request.getParameter("topic");
      if (topic == null || topic.equals("")) throw new WikiException("Topic must be specified");

      String user = "";
      Cookie[] cookies = request.getCookies();
      if (cookies != null)
        if (cookies.length > 0)
          for (int i = 0; i < cookies.length; i++)
            if (cookies[i].getName().equals("username")) user = cookies[i].getValue();
      if (user == null || user.equals("")) throw new WikiException("User name not found.");
      Notify notifier = WikiBase.getInstance().getNotifyInstance(virtualWiki, topic);
      if (action == null || action.equals("notify_on")) {
        notifier.addMember(user);
      }
      else {
        notifier.removeMember(user);
      }
    }
    catch (Exception e) {
      throw new ServletException(e.getMessage(), e);
    }
    String next = JSPUtils.createRootPath(request, virtualWiki, false) + "/Wiki?" + topic;
    response.sendRedirect(response.encodeRedirectURL(next));
  }

  protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    this.doPost(httpServletRequest, httpServletResponse);
  }
}

// $Log: NotifyServlet.java,v $
// Revision 1.4  2003/10/05 05:07:32  garethc
// fixes and admin file encoding option + merge with contributions
//
// Revision 1.3  2003/04/15 08:33:08  mrgadget4711
// ADD: Search using Lucene
// ADD: RSS feed
//
// Revision 1.2  2003/03/11 20:21:14  garethc
// fixes and 2.5 enhancements
//
// Revision 1.1  2003/02/02 19:41:25  garethc
// servlets
//
// Revision 1.5  2003/01/07 23:54:39  garethc
// almost finished taglibs
//
// Revision 1.4  2003/01/07 03:11:52  garethc
// beginning of big cleanup, taglibs etc
//
// Revision 1.3  2002/12/08 20:58:58  garethc
// 2.3.6 almost ready
//
// Revision 1.2  2002/11/15 03:31:44  garethc
// small fixes
//
// Revision 1.1  2002/10/22 20:14:36  garethc
// 2.2.0
//