/**
 * Copyright 2004, Gareth Cronin
 * Subject to LGPL
 * User: garethc
 * Date: 5/06/2004
 * Time: 17:47:23
 */

package vqwiki.servlets;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import vqwiki.utils.JSPUtils;
import vqwiki.utils.Utilities;

import java.io.IOException;

/**
 * Servlet for handling quick menu search and jump-to options. Despatches work to other servlets.
 *
 * Copyright 2004, Gareth Cronin
 * 
 * @author $Author: garethc $
 *         Last Modified: $Date: 2004/06/06 03:40:00 $
 *         $Id: MenuJumpServlet.java,v 1.1 2004/06/06 03:40:00 garethc Exp $
 */
public class MenuJumpServlet extends VQWikiServlet {

  protected void doPost(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException {
  	String characterEncoding = Utilities.extractCharacterEncoding(response);
    String jumpto = request.getParameter("jumpto");
    String text = request.getParameter("text");
    if(jumpto != null){
    	String topic = text;
      // the jump-to submit button was pushed so do a jumpto
	    if (!Utilities.checkURLChars(topic)) {
	    	WikiServletException err = new WikiServletException ("Wrong character(s) in topic: " + Utilities.getWrongURLChars(topic));
	        request.setAttribute("exception", err);
	        request.setAttribute("title", "Error");
	        request.setAttribute("javax.servlet.jsp.jspException", err);
	        dispatch("/jsp/servlet-error.jsp", request, response);
	        return;
	    }
    	
      redirect("Wiki?" + JSPUtils.encodeURL(topic, characterEncoding), response);
      return;
    }
    else{
      // do a search
    	String search = text;
      redirect("Wiki?action=action_search&text=" + JSPUtils.encodeURL(text, characterEncoding), response);
      return;
    }
  }

}
