package vqwiki.servlets;

import org.apache.log4j.Logger;
import vqwiki.Environment;
import vqwiki.utils.JSPUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Servlet responsible for managing login and logout.
 *
 * @author garethc
 *         Date: 5/03/2003
 */
public class LoginServlet extends VQWikiServlet {

  /**
   * Logger
   */
  private static final Logger logger = Logger.getLogger(LoginServlet.class);

  /**
   * Respond to get request. This will be a logout request from the link that appears at the bottom of pages if
   * there is a user principal in the session.
   * @param httpServletRequest
   * @param httpServletResponse
   * @throws ServletException
   * @throws IOException
   */
  protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse)
      throws ServletException, IOException {
    String logoutParameter = httpServletRequest.getParameter("logout");
    if (logoutParameter != null) {
      Boolean logout = new Boolean(logoutParameter);
      if (logout.booleanValue()) {
        httpServletRequest.getSession().invalidate();
        String redirect = JSPUtils.createRedirectURL(httpServletRequest, httpServletRequest.getParameter("redirect"));
        redirect(redirect, httpServletResponse);
      }
    }
  }

  /**
   * Respond to post request. This will be called when the login form is filled out in login.jsp and is used for
   * admin authentication for AdminOnlyTopics and the admin console.
   * @param request
   * @param httpServletResponse
   * @throws ServletException
   * @throws IOException
   */
  protected void doPost(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException,
      IOException {
    String password = request.getParameter("password");
    String username = request.getParameter("username");
    Environment environment = Environment.getInstance();
    if ("admin".equals(username)) {
      if (environment.getStringSetting(Environment.PROPERTY_ADMIN_PASSWORD).equals(password)) {
        request.getSession().setAttribute("admin", "true");
      }
    }
    String redirect = request.getParameter("redirect");
    redirect(redirect, httpServletResponse);
  }

}
