package vqwiki.servlets;

import vqwiki.PseudoTopicHandler;
import vqwiki.Topic;
import vqwiki.WikiBase;
import vqwiki.WikiException;
import vqwiki.utils.JSPUtils;
import vqwiki.utils.Utilities;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;

/**
 * @author garethc
 *         Date: Jan 8, 2003
 */
public class EditServlet extends VQWikiServlet {

  protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
  	String characterEncoding = Utilities.extractCharacterEncoding(response);
    ResourceBundle messages = Utilities.getMessages(request.getLocale());

    String topic = request.getParameter("topic");
    
    /*
    if (topic == null) {
      if (request.getAttribute("topic") != null) {
        topic = (String) request.getAttribute("topic");
      }
    }
    
    if (request.getCharacterEncoding() != null) {
        topic = JSPUtils.decodeURL(topic, request.getCharacterEncoding());
    } else {
        topic = JSPUtils.decodeURL(topic, response.getCharacterEncoding());
    }
   */

    if (PseudoTopicHandler.getInstance().isPseudoTopic(topic)) {

      error(
          request, response, new WikiServletException(topic + " " + messages.getString("edit.exception.pseudotopic"))
      );
      return;
    }
    String virtualWiki = (String) request.getAttribute("virtual-wiki");

    try {
      if (virtualWiki == null) {
        virtualWiki = Utilities.extractVirtualWiki(request);
      }
      Topic t = new Topic(topic);
      if (t.isReadOnlyTopic(virtualWiki)) {
        error(request, response, new WikiServletException(WikiException.READ_ONLY));
        return;
      }

      if (WikiBase.getInstance().isAdminOnlyTopic(request.getLocale(), virtualWiki, topic)) {
        if (!Utilities.isAdmin(request)) {
          request.setAttribute("title", Utilities.resource("login.title", request.getLocale(),"WikiLogin"));
          String rootPath = JSPUtils.createRootPath(request, virtualWiki, false);
          StringBuffer buffer = new StringBuffer();
          buffer.append(rootPath);
          buffer.append("Wiki?" + JSPUtils.encodeURL(topic, characterEncoding));
          request.setAttribute(
              "redirect",
              buffer.toString()
          );
          dispatch("/jsp/login.jsp", request, response);
          return;
        }
      }
    }
    catch (Exception e) {
      error(request, response, e);
      return;
    }

    if (topic == null || topic.equals("")) {
      error(
          request, response,
          new WikiServletException(messages.getString("edit.exception.notopic"))
      );
      return;
    }
    WikiBase base = null;
    try {
      base = WikiBase.getInstance();
      String key = request.getSession().getId();
      if (!base.lockTopic(virtualWiki, topic, key)) {
        error(request, response, new WikiServletException(WikiException.TOPIC_LOCKED));
        return;
      }
    }
    catch (Exception e) {
      error(request, response, e);
      return;
    }

    String contents = null;
    Collection templateNames = null;
    try {
      contents = base.readRaw(virtualWiki, topic);
      contents = Utilities.replaceString(contents, "&", "&amp;");
      contents = Utilities.replaceString(contents, "<", "&lt;");
      contents = Utilities.replaceString(contents, ">", "&gt;");
      templateNames = base.getTemplates(virtualWiki);
    }
    catch (Exception e) {
      error(request, response, e);
      return;
    }
    StringBuffer buffer = new StringBuffer();
    buffer.append(messages.getString("edit"));
    buffer.append(" ");
    buffer.append(topic);

    request.setAttribute("title", buffer.toString());
    request.setAttribute("templateNames", templateNames);
    request.setAttribute("contents", contents);
    request.setAttribute("topic", JSPUtils.encodeURL(topic, characterEncoding));
    dispatch("/jsp/edit.jsp", request, response);
  }

  protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse)
      throws ServletException, IOException {
    this.doGet(httpServletRequest, httpServletResponse);
  }
}
