/**
 * Copyright 2004, Martijn van der Kleijn
 * User: mvdkleijn
 * Date: 18/10/2004
 * Time: 01:42
 */

package vqwiki.plugin.include;

import vqwiki.Topic;
import vqwiki.lex.ExternalLex;
import org.apache.log4j.Logger;

/**
 * Lexer that includes a different topic
 *
 * Copyright 2004, Martijn van der Kleijn
 * Subject to LGPL
 * 
 * @author $Author: mvdkleijn $
 *         Last Modified: $Date: 2004/10/26 21:54:15 $
 *         $Id: LaTeXLex.java,v 1.1 2004/10/26 21:54:15 mvdkleijn Exp $
 */
public class IncludeLex extends ExternalLex{

  /**
   * Logger
   */
  public static final Logger logger = Logger.getLogger(IncludeLex.class);

  /**
   * Process the given topic and include the complete text of the topic given.
   * @param text Name of topic
   * @return string Text of topic
   */
  public String process(String text) {
    try {
        Topic topic = new Topic(text);
        return ">>>"+text+"<<<";
    }
    catch (Exception e) {
      logger.error("", e);
      return "???" + e.getMessage() + "???";
    }
  }

}