package vqwiki.lex;

import java.io.BufferedReader;
import java.io.StringReader;
import java.text.MessageFormat;

import vqwiki.utils.Utilities;


/**

 * @author Uwe Roth

 * Date: 2005-05-13

 */

public class Meta extends ExternalLex {

  private final static String META = "META";
  public String process(String text) {
  	
  	StringBuffer textBuffer = new StringBuffer();
	MessageFormat mf = new MessageFormat ("{0}=\"{1}\"{2}");
	BufferedReader br = new BufferedReader (new StringReader(text));
	try {
		while (br.ready()) {
			String line = br.readLine();
		  	StringBuffer lineBuffer = new StringBuffer();		
			while (!line.equals("")) {
				try {
					Object [] o = mf.parse(line);
					if (lineBuffer.length()>0) {lineBuffer.append(" "); }

					String part = (String)o[0];
					
					StringBuffer checked = new StringBuffer();
					for (int i = 0; i < part.length(); i++) {
						char c = part.charAt(i);
						if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-".indexOf(c)>=0) {
							checked.append(c);
						}
					}
					lineBuffer.append(checked.toString());
					lineBuffer.append("=\"");

					part = (String)o[1];
					part= Utilities.replaceString(part, "<", "&lt;");
					part= Utilities.replaceString(part, ">", "&gt;");					
					lineBuffer.append(part);
					lineBuffer.append("\"");
					
					line = (String)o[2];
					while (line.startsWith(" ")) {
						line = line.substring(1);
					}			
				} catch (Exception e) {
					line = "";
				}
			}
			if (lineBuffer.length()>0) {
				textBuffer.append("<meta ");
				textBuffer.append(lineBuffer);
				textBuffer.append("/>\n");								
			}
		}
	} catch (Exception e) {}
	String metaTags = (String) getTemplateParameter(META);
	if (metaTags == null) {
		metaTags = textBuffer.toString();
	} else {
		metaTags = metaTags + textBuffer.toString();
	}
	setTemplateParameter(META, metaTags);
    return "";
  }
  
}

