/*
Very Quick Wiki - WikiWikiWeb clone
Copyright (C) 2001-2002 Gareth Cronin

This program is free software; you can redistribute it and/or modify
it under the terms of the latest version of the GNU Lesser General
Public License as published by the Free Software Foundation;

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program (gpl.txt); if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package vqwiki.lex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import vqwiki.Environment;
import vqwiki.WikiBase;
import vqwiki.utils.JSPUtils;
import vqwiki.utils.Utilities;

/**
 * This interface can be implemented in any way you like, it doesn't have to be for
 * a JLex generated lexer. As long as the implementing class implements a constructor
 * that takes a single InputStream or Reader parameter and returns one token at a
 * time from the yylex() method, it will work.
 */
public abstract class Lexer {

	protected static Logger logger = Logger.getLogger(Lexer.class);

	protected String virtualWiki;

	protected int displayMode = WikiBase.DEFAULT;
	protected int displayModeFullInfo = WikiBase.DEFAULT;
	protected boolean display = true;
    protected boolean export = false;
    protected boolean print = false;
    protected boolean preview = false;
    
    protected List topicsList = new ArrayList();// list of all visited topics (used for include)
    
    protected List docs = new ArrayList ();		// list of all documents in a topic
    protected List urls = new ArrayList ();		// list of all urls in a topic
    protected List links = new ArrayList();		// list of all links in a topic
    
    protected String topic = null;
    protected Map customParameters = new HashMap ();
    
     protected String charset = JSPUtils.DEFAULTENCODING;
    
	protected boolean exists(String topic){
		try{
			return wikiBase().exists(virtualWiki, topic);
		}catch( Exception err ){
			logger.error( err );
		}
		return false;
	}
	protected boolean ignoreWikiname( String name ){
		return Environment.getInstance().doIgnoreWikiname(name);
	}

    protected WikiBase wikiBase () {
		try {
			return WikiBase.getInstance();
		} catch (Exception err) {
			logger.error(err);
		}
		return null;
    }
    
    protected Environment environment () {
    	return Environment.getInstance();
    }
    
	public void setVirtualWiki(String vWiki) {
		this.virtualWiki = vWiki;
	}

	public String getVirtualWiki() {
		return virtualWiki;
	}

    public void setDisplayMode(int displayMode) {
		this.displayMode = displayMode;
		this.displayModeFullInfo = displayMode;
		
		this.display = (displayMode == WikiBase.DISPLAY);
		this.export = ((displayMode == WikiBase.EXPORT) || (displayMode == WikiBase.EXPORTPREV));
		this.print = ((displayMode == WikiBase.PRINT) || (displayMode == WikiBase.PRINTPREV));
		this.preview = ((displayMode == WikiBase.PRINTPREV) || (displayMode == WikiBase.EXPORTPREV));
		
		if (preview) {
			if (displayMode == WikiBase.PRINTPREV) {this.displayMode = WikiBase.PRINT;}
			if (displayMode == WikiBase.EXPORTPREV) {this.displayMode = WikiBase.EXPORT;}			
		}
		
	}
    
    public void setCharset (String charset) {
    	charset = this.charset;
    }
    
    public void setTopicsList (List topicsList) {
    	this.topicsList = topicsList;
    }
    
    public List getTopicsList () {
    	return topicsList;
    }

    public void setTopic (String topic) {
    	this.topic = topic;
    }
    
    public String getTopic () {
    	return topic;
    }
    
    public void setParameter (String key, Object value){
    	customParameters.put(key, value);
    }
    
    public void setAllParameters(Map map) {
    	customParameters.putAll(map);
    }
    
    public Object getParameter (String key){
    	return customParameters.get(key);
    }

    public Map getParameters () {
    	return customParameters;
    }
    
    protected void addLink(String link){
      if (Utilities.checkURLChars(link) & !this.links.contains(link)& exists(link)) {
        logger.debug("adding link: '" + link + "'");
        this.links.add(link);
      }
    }
    
    
    protected void addLinks (List links) {
    	if (links!=null) {
    		for (Iterator it = links.iterator(); it.hasNext();) {
    			String link = (String) it.next();
    			addLink(link);
    		}
    	}
    }
    
    public List getLinks(){
        return this.links;
     }
      
    protected void addDoc(String doc){
        if (Utilities.checkURLChars(doc) & !this.docs.contains(doc)) {
          logger.debug("adding doc: '" + doc + "'");
          this.docs.add(doc);
        }
      }
      
      
      protected void addDocs (List docs) {
      	if (docs!=null) {
      		for (Iterator it = docs.iterator(); it.hasNext();) {
      			String doc = (String) it.next();
      			addDoc(doc);
      		}
      	}
      }
      
      public List getDocs(){
          return this.docs;
       }

      protected void addUrl(String url){
        if (Utilities.checkURLChars(url) & !this.urls.contains(url)) {
          logger.debug("adding url: '" + url + "'");
          this.urls.add(url);
        }
      }
      
      
      protected void addUrls (List urls) {
      	if (urls!=null) {
      		for (Iterator it = urls.iterator(); it.hasNext();) {
      			String url = (String) it.next();
      			addUrl(url);
      		}
      	}
      }
      
      public List getUrls(){
          return this.urls;
       }
    
    abstract public String yylex() throws java.io.IOException;

}
