/**
 * @author garethc
 *  22/10/2002 11:46:44
 */
package vqwiki.db;

import org.apache.log4j.Logger;
import vqwiki.AbstractWikiMembers;
import vqwiki.Environment;
import vqwiki.WikiMember;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.Collection;
import java.util.ArrayList;

public class DatabaseWikiMembers extends AbstractWikiMembers {

  private static final Logger logger = Logger.getLogger(DatabaseWikiMembers.class);

  private static Properties statements;

  public DatabaseWikiMembers(String virtualWiki) {
    if ("".equals(virtualWiki)) throw new RuntimeException("Virtual wiki == blank!");
    this.virtualWiki = virtualWiki;
  }

  public void addMember(String username, String email, String key) throws Exception {
    WikiMember aMember = createMember(username, email);
    Connection conn = DatabaseConnection.getConnection();
    PreparedStatement stmt = conn.prepareStatement(getStatement("STATEMENT_ADD_MEMBER"));
    stmt.setString(1, username);
    stmt.setString(2, email);
    stmt.setString(3, aMember.getKey());
    stmt.setString(4, this.virtualWiki);
    stmt.execute();
    stmt.close();
    conn.close();
  }

  public boolean requestMembership(String username, String email, HttpServletRequest virtualWiki) throws Exception {
    WikiMember aMember = createMember(username, email);
    mailMember(username, virtualWiki, aMember, email);
    // remove existing member (might be a re-confirmation)
    Connection conn = DatabaseConnection.getConnection();
    PreparedStatement stmt = conn.prepareStatement(getStatement("STATEMENT_REMOVE_MEMBER"));
    stmt.setString(1, username);
    stmt.setString(2, this.virtualWiki);
    stmt.execute();
    stmt.close();
    stmt = conn.prepareStatement(getStatement("STATEMENT_ADD_MEMBER"));
    stmt.setString(1, username);
    stmt.setString(2, email);
    stmt.setString(3, aMember.getKey());
    stmt.setString(4, this.virtualWiki);
    stmt.execute();
    stmt.close();
    conn.close();
    return true;
  }

  private void saveMember(WikiMember member) throws Exception {
    Connection conn = DatabaseConnection.getConnection();
    PreparedStatement stmt = conn.prepareStatement(getStatement("STATEMENT_UPDATE_MEMBER"));
    stmt.setString(1, member.getEmail().trim());
    stmt.setString(2, member.getKey().trim());
    stmt.setString(3, member.getUserName().trim());
    stmt.setString(4, this.virtualWiki);
    stmt.execute();
    stmt.close();
    conn.close();
  }

  public boolean confirmMembership(String username, String key) throws Exception {
    boolean result = super.confirmMembership(username, key);
    if (result == true) return true;
    WikiMember member = findMemberByName(username);
    // Look up the username and check the keys
    if (!member.checkKey(key)) return false;
    member.confirm();
    saveMember(member);
    return true;
  }

  public boolean removeMember(String username) throws Exception {
    Connection conn = DatabaseConnection.getConnection();
    PreparedStatement stmt = conn.prepareStatement(getStatement("STATEMENT_REMOVE_MEMBER"));
    stmt.setString(1, username);
    stmt.setString(2, this.virtualWiki);
    int n = stmt.executeUpdate();
    stmt.close();
    conn.close();
    return n > 0;
  }

  public WikiMember findMemberByName(String username) throws Exception {
    Connection conn = DatabaseConnection.getConnection();
    PreparedStatement stmt = conn.prepareStatement(getStatement("STATEMENT_GET_MEMBER"));
    stmt.setString(1, username);
    stmt.setString(2, this.virtualWiki);
    ResultSet rs = stmt.executeQuery();
    if (!rs.next()) {
      rs.close();
      stmt.close();
      conn.close();
      return new WikiMember(username);
    }
    WikiMember member = null;
    if (Environment.getInstance().isMySQL()) {
      member = new WikiMember(rs.getString("user"), rs.getString("email"));
    }
    else {
      member = new WikiMember(rs.getString("wikiuser"), rs.getString("email"));
    }
    member.setKey(rs.getString("userkey"));
    rs.close();
    stmt.close();
    conn.close();
    return member;
  }

  public Collection getAllMembers() throws Exception {
    Collection all = new ArrayList();
    Connection conn = DatabaseConnection.getConnection();
    PreparedStatement stmt = conn.prepareStatement(getStatement("STATEMENT_ALL_MEMBERS"));
    stmt.setString(1, this.virtualWiki);
    ResultSet rs = stmt.executeQuery();
    while (rs.next()) {
      WikiMember member;
      if (Environment.getInstance().isMySQL()) {
        member = new WikiMember(rs.getString("user"), rs.getString("email"));
      }
      else {
        member = new WikiMember(rs.getString("wikiuser"), rs.getString("email"));
      }
      member.setKey(rs.getString("userkey"));
      all.add(member);
    }
    rs.close();
    stmt.close();
    conn.close();
    return all;
  }

  private String getStatement(String key) {

    if (statements == null) {
      String statementResource, databaseType;
      databaseType = Environment.getInstance().getDatabaseType();
      statementResource = "/wikimembers_" + databaseType + ".sql.properties";
      try {
        InputStream in = getClass().getResourceAsStream(statementResource);
        statements = new Properties();
        statements.load(in);
        in.close();
      }
      catch (IOException e) {
        logger.error("Error getting statements from file", e);
        return null;
      }
    }
    String statement = statements.getProperty(key);
    logger.debug("statement for " + key + " = " + statement);
    return statement.trim();
  }
}
