/**
 * @author garethc
 *  22/10/2002 11:40:10
 */
package vqwiki.db;

import vqwiki.AbstractNotify;
import vqwiki.Environment;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.io.InputStream;
import java.io.IOException;

import org.apache.log4j.Logger;

public class DatabaseNotify extends AbstractNotify {

  private static final Logger logger = Logger.getLogger(DatabaseNotify.class);
  private static Properties statements;

  public DatabaseNotify(String virtualWiki, String topicName) {
    super();
    this.virtualWiki = virtualWiki;
    this.topicName = topicName;
  }

  public void addMember(String userName) throws Exception {
    Connection conn = DatabaseConnection.getConnection();
    PreparedStatement stmt = conn.prepareStatement(getStatement("STATEMENT_ADD_MEMBER"));
    stmt.setString(1, this.topicName);
    stmt.setString(2, userName);
    stmt.setString(3, this.virtualWiki);
    stmt.execute();
    stmt.close();
    conn.close();
  }

  public void removeMember(String userName) throws Exception {
    Connection conn = DatabaseConnection.getConnection();
    PreparedStatement stmt = conn.prepareStatement(getStatement("STATEMENT_REMOVE_MEMBER"));
    stmt.setString(1, this.topicName);
    stmt.setString(2, userName);
    stmt.setString(3, this.virtualWiki);
    stmt.execute();
    stmt.close();
    conn.close();
  }

  public boolean isMember(String userName) throws Exception {
    Connection conn = DatabaseConnection.getConnection();
    PreparedStatement stmt = conn.prepareStatement(getStatement("STATEMENT_IS_MEMBER"));
    stmt.setString(1, this.topicName);
    stmt.setString(2, userName);
    stmt.setString(3, this.virtualWiki);
    ResultSet rs = stmt.executeQuery();
    rs.next();
    int count = rs.getInt(1);
    rs.close();
    stmt.close();
    conn.close();
    return count > 0;
  }

  public Collection getMembers() throws Exception {
    Collection all = new ArrayList();
    Connection conn = DatabaseConnection.getConnection();
    PreparedStatement stmt = conn.prepareStatement(getStatement("STATEMENT_GET_MEMBERS"));
    stmt.setString(1, this.topicName);
    stmt.setString(2, this.virtualWiki);
    ResultSet rs = stmt.executeQuery();
    while (rs.next()) {
      String username;
      if (Environment.getInstance().isMySQL()) {
        username = rs.getString("user");
      }
      else {
        username = rs.getString("wikiuser");
      }
      all.add(username);
    }
    rs.close();
    stmt.close();
    conn.close();
    return all;
  }

  public static Collection getAllNotifications(String virtualWiki) throws Exception {
    Collection all = new ArrayList();
    Connection conn = DatabaseConnection.getConnection();
    PreparedStatement stmt = conn.prepareStatement(getStatement("STATEMENT_ALL_NOTIFICATIONS"));
    stmt.setString(1, virtualWiki);
    ResultSet rs = stmt.executeQuery();
    while (rs.next()) {
      DatabaseNotify notify = new DatabaseNotify(rs.getString("virtualwiki"), rs.getString("topic"));
      all.add(notify);
    }
    rs.close();
    stmt.close();
    conn.close();
    return all;
  }

  private static String getStatement(String key) {
    if (statements == null) {
      String statementResource, databaseType;
      databaseType = Environment.getInstance().getDatabaseType();
      statementResource = "/notify_" + databaseType + ".sql.properties";
      try {
        InputStream in = DatabaseNotify.class.getResourceAsStream(statementResource);
        if (in == null) {
          logger.error("statement file not found: " + statementResource);
          return null;
        }
        statements = new Properties();
        statements.load(in);
        in.close();
      }
      catch (IOException e) {
        logger.error("Error getting statements from file", e);
        return null;
      }
    }
    String statement = statements.getProperty(key);
    logger.debug("statement for " + key + " = " + statement);
    return statement.trim();
  }

}
