/*
 * $Id: PrintableEntry.java,v 1.3 2003/10/05 05:07:30 garethc Exp $
 *
 * Filename  : PrintableEntry.java
 * Project   : VQWiki
 * Author    : Tobias Schulz-Hess (sourcefoge@schulz-hess.de)
 */
package vqwiki;


/**
 * One entry of the printable page (the page can contain multiple entries)
 *
 * This class was created on 20:18:49 15.04.2003
 *
 * @author Tobias Schulz-Hess (sourcefoge@schulz-hess.de)
 */
public class PrintableEntry {
  //~ Instance variables �����������������������������������������������������

  /** The topic of this entry */
  private String topic;

  /** The topicName of this entry as used in <a name= */
  private String topicName;
  
  /** The content of this entry */
  private String content;

  //~ Methods ����������������������������������������������������������������

  /**
   * Get the topic
   *
   * @return topic as String
   */
  public String getTopic() {
    return topic;
  }

  /**
   * Get the topicName
   *
   * @return topic as String
   */
  public String getTopicName() {
    return topicName;
  }

  /**
   * Get the content
   *
   * @return content as String
   */
  public String getContent() {
    return content;
  }

  /**
   * Set the topic
   *
   * @param mytopic New topic
   */
  public void setTopic(String mytopic) {
    topic = mytopic;
  }

  /**
   * Set the topicName
   *
   * @param mytopic New topic
   */
  public void setTopicName(String mytopic) {
    topicName = mytopic;
  }

  /**
   * Set the content
   *
   * @param mycontent New content
   */
  public void setContent(String mycontent) {
    content = mycontent;
  }
}


/*
 * Log:
 *
 * $Log: PrintableEntry.java,v $
 * Revision 1.3  2003/10/05 05:07:30  garethc
 * fixes and admin file encoding option + merge with contributions
 *
 * Revision 1.2  2003/04/15 23:11:01  garethc
 * lucene fixes
 *
 * Revision 1.1  2003/04/15 18:40:25  mrgadget4711
 * ADD: Print multiple pages
 *
 * ------------END------------
 */
