import java.applet.Applet;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import vqwiki.AbstractSearchEngine;
import vqwiki.SearchResultEntry;

/*
Very Quick Wiki - WikiWikiWeb clone
Copyright (C) 2001-2002 Gareth Cronin

This program is free software; you can redistribute it and/or modify
it under the terms of the latest version of the GNU Lesser General
Public License as published by the Free Software Foundation;

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program (gpl.txt); if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
 * Applet to perform a search using lucene
 *
 * @author $Author: mrgadget4711 $
 */
public class SearchApplet extends Applet {

	/** The last search result */
	private ArrayList result = null;
	
	/** Reference to the search Engine */
	private  AbstractSearchEngine se = null; 


	/** Init the applet and the search engine.
	 * @see java.applet.Applet#init()
	 */
	public void init() {
		super.init();
		
		// configure log4j
		BasicConfigurator.configure();
		Logger.getLogger("org.apache").setLevel(Level.WARN);
		
		se = new AppletSearchEngine();
	}

	/**
	 * Actually perform a search
	 * @param term The word to find
	 * @return A String containing the number of hits found
	 */
 	public String doSearch(String term)
 	{
 		result = new ArrayList(se.findMultiple("", term, true));
 		
 		return String.valueOf(result.size()); 
 	}
 	
	/**
	 * Actually perform a search
	 * @param term The word to find
	 * @param template The template to fill in
	 * @return A String containing the number of hits found
	 */
	public String doSearch(String term, String template)
	{
		boolean filter = true;
		List visible = new ArrayList ();
		try {
			InputStream in = this.getClass().getResourceAsStream("/lucene/visible.txt");
			BufferedReader br = new BufferedReader (new InputStreamReader(in));
			while (br.ready()) {
				String topic = br.readLine();
				if (!topic.trim().equals("")) {
					visible.add(topic);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			filter = false;
		}
		result = new ArrayList(se.findMultiple("", term, true));
 		StringBuffer out = new StringBuffer();
 		for (Iterator iter = result.iterator(); iter.hasNext();) {
			SearchResultEntry searchresultentry = (SearchResultEntry) iter.next();
			if (!filter || visible.contains(searchresultentry.getTopic())) {
				out.append(
					replaceString(
					replaceString(
					replaceString(
					replaceString(
					replaceString(
					template, 
					"##FOUNDWORD##", searchresultentry.getFoundWord()), 
					"##TEXTAFTER##", searchresultentry.getTextAfter()), 
					"##TEXTBEFORE##", searchresultentry.getTextBefore()), 
					"##TOPICADAPT##", encodeSafeURL(searchresultentry.getTopic())),
					"##TOPIC##", searchresultentry.getTopic())
					);
			}
 			
		}
		return out.toString(); 
	}
	
	private static String encodeSafeURL(String topic) {
		if (topic == null) {return null; }
		StringBuffer sb = new StringBuffer ();
		for (int i = 0; i < topic.length(); i++) {
			char c = topic.charAt(i);
			int ci = (int) c;
			if (c == ' ') {sb.append('+');}
			else
			if ((c == '!') ||
                (c == '.') ||
				(c == '-') ||
				(c == '_'))
				{sb.append(c);}
			else
			if ((ci <=31) ||
				((ci >= 33) && (ci <=47)) ||
			    ((ci >= 58) && (ci <=64)) ||
			    ((ci >= 91) && (ci <=96)) ||
			    (ci >= 123)) {
			    	sb.append("($");
			    	sb.append(Integer.toHexString(ci).toUpperCase());
			    	sb.append(")");
			    }
			else {
				sb.append(c);
			}
		}
		
		return sb.toString();
	}
 	
 	/**
 	 * Get a topic for a specific hit
 	 * @param i Number of hit 
 	 * @return Topic for this hit or empty string.
 	 */
 	public String getTopic(int i)
 	{
 		if (result == null || i >= result.size())
 			return "";
 		return ((SearchResultEntry)result.get(i)).getTopic();
 	}

	/**
	 * Get a text before word actually found for a specific hit
	 * @param i Number of hit 
	 * @return Text before word actually found for this hit or empty string.
	 */
	public String getTextBefore(int i)
	{
		if (result == null || i >= result.size())
			return "";
		return ((SearchResultEntry)result.get(i)).getTextBefore();
	}

	/**
	 * Get a text after word actually found for a specific hit
	 * @param i Number of hit 
	 * @return Text after word actually found for this hit or empty string.
	 */
	public String getTextAfter(int i)
	{
		if (result == null || i >= result.size())
			return "";
		return ((SearchResultEntry)result.get(i)).getTextAfter();
	}

	/**
	 * Get a the word actually found for a specific hit
	 * @param i Number of hit 
	 * @return Word actually found for this hit or empty string.
	 */
	public String getFoundWord(int i)
	{
		if (result == null || i >= result.size())
			return "";
		return ((SearchResultEntry)result.get(i)).getFoundWord();
	}

	/**
	 * Replaces occurences of the find string with the replace string in the given text
	 * @param text
	 * @param find
	 * @param replace
	 * @return the altered string
	 */
	public static String replaceString(String text, String find, String replace) {
	  int findLength = find.length();
	  StringBuffer buffer = new StringBuffer();
	  int i;
	  for (i = 0; i < text.length() - find.length() + 1; i++) {
		String substring = text.substring(i, i + findLength);
		if (substring.equals(find)) {
		  buffer.append(replace);
		  i += find.length() - 1;
		}
		else {
		  buffer.append(text.charAt(i));
		}
	  }
	  buffer.append(text.substring(text.length() - (text.length() - i)));
	  return buffer.toString();
	}
}
