/*
 * Decompiled with CFR 0.152.
 */
package JSX;

import JSX.ParseUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.Vector;

public class ParserXML {
    Reader in;
    StreamTokenizer st;
    static final boolean DEBUG = false;
    static final boolean CLOSETAG_DEBUG = false;
    static final boolean ATTR_BUFFER_DEBUG = false;
    private Vector attrBuffer = new Vector();
    private int attrBufferIndex = 0;
    private Attr attrAlias = null;

    public ParserXML(Reader reader) {
        this.in = reader;
        this.st = new StreamTokenizer(new BufferedReader(reader));
        this.setSyntax();
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setSyntax() {
        this.st.eolIsSignificant(false);
        this.st.resetSyntax();
        this.st.wordChars(0, 255);
        this.st.ordinaryChar(60);
        this.st.ordinaryChar(47);
        this.st.ordinaryChar(62);
        this.st.ordinaryChar(61);
        this.st.ordinaryChar(34);
        this.st.ordinaryChar(39);
        this.st.whitespaceChars(32, 32);
        this.st.whitespaceChars(9, 9);
        this.st.whitespaceChars(10, 10);
        this.st.whitespaceChars(13, 13);
    }

    public Attr readAttr() throws ExceptionXML, IOException {
        Attr attr = (Attr)this.attrBuffer.get(this.attrBufferIndex++);
        if (this.attrBufferIndex == this.attrBuffer.size()) {
            this.attrBuffer.clear();
            this.attrBufferIndex = 0;
        }
        return attr;
    }

    public Attr readAttrImpl() throws ExceptionXML, IOException {
        Attr attr = new Attr();
        int n = this.st.nextToken();
        if (n == 62) {
            attr.isEnd = true;
            return attr;
        }
        if (n == 47) {
            if (this.st.nextToken() == 62) {
                attr.isEnd = true;
                attr.emptyTag = true;
                return attr;
            }
            throw new ExceptionXML("empty tag (\"/>\")", this.st);
        }
        if (n != -3) {
            throw new ExceptionXML("an attribute name", this.st);
        }
        if (this.st.sval.equals("?")) {
            if (this.st.nextToken() == 62) {
                attr.isEndPI = true;
                return attr;
            }
            throw new ExceptionXML("PI end (\"?>\")", this.st);
        }
        attr.name = this.st.sval;
        n = this.st.nextToken();
        if (n != 61) {
            throw new ExceptionXML("Expected \"=\" to follow attribute name \"" + attr.name + "\"");
        }
        this.st.wordChars(62, 62);
        this.st.wordChars(61, 61);
        this.st.wordChars(47, 47);
        this.st.ordinaryChar(32);
        this.st.ordinaryChar(9);
        this.st.eolIsSignificant(true);
        this.st.ordinaryChar(13);
        n = this.st.nextToken();
        if (n != 34 && n != 39) {
            throw new ExceptionXML("'quoted' or \"quoted\" value (single or double) to follow \"" + attr.name + "=\"", this.st);
        }
        int n2 = n;
        n = this.st.nextToken();
        if (n == n2) {
            attr.value = "";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                if (n == 32) {
                    stringBuffer.append(' ');
                    n = this.st.nextToken();
                    continue;
                }
                if (n == 9) {
                    stringBuffer.append('\t');
                    n = this.st.nextToken();
                    continue;
                }
                if (n == 13) {
                    stringBuffer.append('\r');
                    n = this.st.nextToken();
                    continue;
                }
                if (n == 10) {
                    stringBuffer.append('\n');
                    n = this.st.nextToken();
                    continue;
                }
                if (n != -3) break;
                stringBuffer.append(this.st.sval);
                n = this.st.nextToken();
            }
            attr.value = stringBuffer.toString();
        }
        if (n != n2) {
            throw new ExceptionXML("matching '" + (char)n2 + "'", this.st);
        }
        this.st.eolIsSignificant(false);
        this.st.ordinaryChar(62);
        this.st.ordinaryChar(61);
        this.st.ordinaryChar(47);
        this.st.whitespaceChars(32, 32);
        this.st.whitespaceChars(9, 9);
        this.st.whitespaceChars(10, 10);
        this.st.whitespaceChars(13, 13);
        attr.name = ParseUtilities.descapeDollar(attr.name);
        return attr;
    }

    public Tag readTag() throws ExceptionXML, IOException {
        Tag tag = new Tag();
        int n = this.st.nextToken();
        if (n == -1) {
            return null;
        }
        if (n != 60) {
            throw new ExceptionXML("an open tag", this.st);
        }
        n = this.st.nextToken();
        switch (n) {
            case -3: {
                tag.name = this.st.sval;
                tag.start = true;
                break;
            }
            case 47: {
                n = this.st.nextToken();
                if (n != -3) {
                    throw new ExceptionXML("a tag", this.st);
                }
                tag.name = this.st.sval;
                tag.start = false;
                n = this.st.nextToken();
                if (n == 62) break;
                throw new ExceptionXML("a >", this.st);
            }
            default: {
                throw new ExceptionXML("either \"<tag\" or \"</tag\"", this.st);
            }
        }
        if (tag.name.startsWith("?")) {
            tag.isPI = true;
            tag.name = tag.name.substring(1);
        }
        if (tag.start) {
            Attr attr;
            if (this.attrBuffer.size() != 0) {
                throw new ExceptionXML("not all attrs (" + this.attrBuffer + ") consumed, when read " + tag);
            }
            do {
                attr = this.readAttrImpl();
                if (attr.name != null && attr.name.equals("alias-ID")) {
                    this.setAlias(attr);
                    continue;
                }
                if (attr.name != null && attr.name.equals("obj-name")) {
                    this.attrBuffer.insertElementAt(attr, 0);
                    continue;
                }
                this.attrBuffer.add(attr);
            } while (!attr.isEnd && !attr.isEndPI);
        }
        return tag;
    }

    private void setAlias(Attr attr) throws ExceptionXML {
        if (this.attrAlias != null) {
            throw new ExceptionXML("Found two alias-ID attrs in tag");
        }
        this.attrAlias = attr;
    }

    public Attr getAlias() throws ExceptionXML {
        if (this.attrAlias == null) {
            throw new ExceptionXML("no alias attr found");
        }
        Attr attr = this.attrAlias;
        this.attrAlias = null;
        return attr;
    }

    public void parse() {
        String string = "";
        System.out.println("Note: this version of parse() does no start-end tag balancing\nNote: it does no checking for legality of class and field names\n");
        try {
            Tag tag;
            while ((tag = this.readTag()) != null) {
                if (tag.start) {
                    Attr attr;
                    System.out.print(string + tag);
                    string = string + "    ";
                    while ((attr = this.readAttr()) != null) {
                        System.out.print(" " + attr);
                    }
                } else {
                    string = string.substring(4);
                    System.out.print(string + tag);
                }
                System.out.println(">");
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void dumbParse() {
        try {
            while (true) {
                int n = this.st.nextToken();
                if (n != -1) {
                    String string;
                    switch (n) {
                        case 34: {
                            string = "QUOTED:  " + this.st.sval;
                            break;
                        }
                        case -3: {
                            string = "TOKEN:  " + this.st.sval;
                            break;
                        }
                        default: {
                            string = (char)n + " : " + this.st.sval;
                        }
                    }
                    System.out.println(string);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static class Test {
        public static void main(String[] stringArray) {
            new ParserXML(new InputStreamReader(System.in)).parse();
        }
    }

    public static class ExceptionXML
    extends IOException {
        public ExceptionXML(String string) {
            super(string);
        }

        public ExceptionXML(String string, String string2) {
            super("Expected \"" + string + "\"" + ", but got \"" + string2 + "\"");
        }

        public ExceptionXML(String string, String string2, String string3) {
            super(string + ":  Expected \"" + string2 + "\"" + ", but got \"" + string3 + "\"");
        }

        public ExceptionXML(String string, StreamTokenizer streamTokenizer) {
            super("Line " + streamTokenizer.lineno() + ": " + "Expected " + string + ", but got " + "'" + (streamTokenizer.ttype != -3 ? "" + (char)streamTokenizer.ttype : streamTokenizer.sval) + "'     " + "[" + streamTokenizer.ttype + ": " + streamTokenizer.sval + "]");
        }
    }

    public class Tag {
        public String name;
        boolean isPI;
        public boolean start;

        public String toString() {
            return "<" + (this.isPI ? "?" : (this.start ? "" : "/")) + this.name;
        }
    }

    public class Attr
    implements Serializable {
        public String name;
        public String value;
        boolean nameMissing;
        int length;
        boolean isEndPI = false;
        public boolean isEnd = false;
        public boolean emptyTag = false;

        public String toString() {
            return this.name + "=\"" + this.value + "\" , " + (this.emptyTag ? "empty" : "") + (this.isEnd ? "end" : "") + " tag" + " nameMissing=" + this.nameMissing;
        }
    }
}

