/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;

public abstract class Lock {
    public abstract boolean obtain() throws IOException;

    public abstract void release();

    public static abstract class With {
        private Lock lock;
        private int sleepInterval = 1000;
        private int maxSleeps = 10;

        public With(Lock lock) {
            this.lock = lock;
        }

        protected abstract Object doBody() throws IOException;

        public Object run() throws IOException {
            boolean bl = false;
            try {
                bl = this.lock.obtain();
                int n = 0;
                while (!bl) {
                    if (++n == this.maxSleeps) {
                        throw new IOException("Timed out waiting for: " + this.lock);
                    }
                    try {
                        Thread.sleep(this.sleepInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(interruptedException.toString());
                    }
                    bl = this.lock.obtain();
                }
                Object object = this.doBody();
                Object var5_5 = null;
                if (bl) {
                    this.lock.release();
                }
                return object;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var5_6 = null;
                    if (!bl) break block7;
                    this.lock.release();
                }
                throw throwable;
            }
        }
    }
}

