/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene.store.OutputStream;

final class FSOutputStream
extends OutputStream {
    RandomAccessFile file = null;

    public FSOutputStream(File file) throws IOException {
        this.file = new RandomAccessFile(file, "rw");
    }

    public final void flushBuffer(byte[] byArray, int n) throws IOException {
        this.file.write(byArray, 0, n);
    }

    public final void close() throws IOException {
        super.close();
        this.file.close();
    }

    public final void seek(long l) throws IOException {
        super.seek(l);
        this.file.seek(l);
    }

    public final long length() throws IOException {
        return this.file.length();
    }

    protected final void finalize() throws IOException {
        this.file.close();
    }
}

