/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;

public final class PrefixQuery
extends Query {
    private Term prefix;
    private IndexReader reader;
    private BooleanQuery query;

    public PrefixQuery(Term term) {
        this.prefix = term;
        this.reader = this.reader;
    }

    final void prepare(IndexReader indexReader) {
        this.query = null;
        this.reader = indexReader;
    }

    final float sumOfSquaredWeights(Searcher searcher) throws IOException {
        return this.getQuery().sumOfSquaredWeights(searcher);
    }

    void normalize(float f) {
        try {
            this.getQuery().normalize(f);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    Scorer scorer(IndexReader indexReader) throws IOException {
        return this.getQuery().scorer(indexReader);
    }

    public BooleanQuery getQuery() throws IOException {
        if (this.query == null) {
            BooleanQuery booleanQuery = new BooleanQuery();
            TermEnum termEnum = this.reader.terms(this.prefix);
            try {
                Term term;
                String string = this.prefix.text();
                String string2 = this.prefix.field();
                while ((term = termEnum.term()) != null && term.text().startsWith(string) && term.field() == string2) {
                    TermQuery termQuery = new TermQuery(term);
                    termQuery.setBoost(this.boost);
                    booleanQuery.add(termQuery, false, false);
                    if (termEnum.next()) continue;
                    break;
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                termEnum.close();
                throw throwable;
            }
            termEnum.close();
            this.query = booleanQuery;
        }
        return this.query;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.prefix.field().equals(string)) {
            stringBuffer.append(this.prefix.field());
            stringBuffer.append(":");
        }
        stringBuffer.append(this.prefix.text());
        stringBuffer.append('*');
        if (this.boost != 1.0f) {
            stringBuffer.append("^");
            stringBuffer.append(Float.toString(this.boost));
        }
        return stringBuffer.toString();
    }
}

