/*
 * Decompiled with CFR 0.152.
 */
package vqwiki.utils.lucene;

import java.io.Reader;
import java.util.Hashtable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import vqwiki.utils.lucene.LowerCaseKeepNumbersTokenizer;

public final class StopKeepNumbersAnalyzer
extends Analyzer {
    private Hashtable stopTable;
    public static final String[] ENGLISH_STOP_WORDS = new String[]{"a", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "s", "such", "t", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};

    public StopKeepNumbersAnalyzer() {
        this.stopTable = StopFilter.makeStopTable((String[])ENGLISH_STOP_WORDS);
    }

    public StopKeepNumbersAnalyzer(String[] stopWords) {
        this.stopTable = StopFilter.makeStopTable((String[])stopWords);
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        return new StopFilter((TokenStream)new LowerCaseKeepNumbersTokenizer(reader), this.stopTable);
    }
}

