/*
 * Decompiled with CFR 0.152.
 */
package vqwiki.utils.lucene;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pdfbox.encryption.DecryptDocument;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class PDFDocument {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer getContentOfPDFFile(String attachmentFileName, File attachmentFile) throws FileNotFoundException, IOException {
        StringBuffer contents = new StringBuffer();
        FileInputStream input = null;
        try {
            input = new FileInputStream(attachmentFile);
            PDDocument pdfDocument = null;
            try {
                PDFParser parser = new PDFParser((InputStream)input);
                parser.parse();
                pdfDocument = parser.getPDDocument();
                if (pdfDocument.isEncrypted()) {
                    DecryptDocument decryptor = new DecryptDocument(pdfDocument);
                    decryptor.decryptDocument("");
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(out);
                PDFTextStripper stripper = new PDFTextStripper();
                stripper.writeText(pdfDocument.getDocument(), (Writer)writer);
                writer.close();
                contents.append(" ");
                contents.append(out.toString());
            }
            catch (CryptographyException e) {
                throw new IOException("Error decrypting document(" + attachmentFileName + "): " + (Object)((Object)e));
            }
            catch (InvalidPasswordException e) {
                throw new IOException("Error: The document(" + attachmentFileName + ") is encrypted and will not be indexed.");
            }
            finally {
                if (pdfDocument != null) {
                    pdfDocument.close();
                }
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return contents;
    }
}

