/*
 * Decompiled with CFR 0.152.
 */
package vqwiki.utils.lucene;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import vqwiki.utils.lucene.Entities;
import vqwiki.utils.lucene.HTMLParserConstants;
import vqwiki.utils.lucene.HTMLParserTokenManager;
import vqwiki.utils.lucene.ParseException;
import vqwiki.utils.lucene.ParserThread;
import vqwiki.utils.lucene.SimpleCharStream;
import vqwiki.utils.lucene.Token;

public class HTMLParser
implements HTMLParserConstants {
    public static int SUMMARY_LENGTH = 200;
    boolean afterSpace = false;
    boolean afterTag = false;
    String eol = System.getProperty("line.separator");
    boolean inScript = false;
    boolean inTitle = false;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private int jj_endpos;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_gc = 0;
    private int jj_gen;
    SimpleCharStream jj_input_stream;
    private int jj_kind = -1;
    private int jj_la;
    private final int[] jj_la1 = new int[13];
    private final int[] jj_la1_0 = new int[]{2878, 2878, 4096, 229376, 8192, 32768, 65536, 131072, 241664, 241664, 0x800000, 0x2000000, 24};
    private int[] jj_lasttokens = new int[100];
    private int jj_ntk;
    private boolean jj_rescan = false;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private boolean jj_semLA;
    int length = 0;
    public boolean lookingAhead = false;
    PipedReader pipeIn = null;
    PipedWriter pipeOut;
    StringBuffer summary = new StringBuffer(SUMMARY_LENGTH * 2);
    StringBuffer title = new StringBuffer(SUMMARY_LENGTH);
    boolean titleComplete = false;
    public Token token;
    public Token jj_nt;
    public HTMLParserTokenManager token_source;

    public HTMLParser(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public HTMLParser(InputStream stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new HTMLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public HTMLParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new HTMLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public HTMLParser(HTMLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public final Token ArgValue() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                t = this.jj_consume_token(15);
                return t;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        if (this.jj_2_1(2)) {
            this.jj_consume_token(16);
            this.jj_consume_token(20);
            return t;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                t = this.jj_consume_token(19);
                this.jj_consume_token(20);
                return t;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        if (this.jj_2_2(2)) {
            this.jj_consume_token(17);
            this.jj_consume_token(22);
            return t;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                t = this.jj_consume_token(21);
                this.jj_consume_token(22);
                return t;
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void CommentTag() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                this.jj_consume_token(3);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(23);
                }
                this.jj_consume_token(24);
                break;
            }
            case 4: {
                this.jj_consume_token(4);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(25);
                }
                this.jj_consume_token(26);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token Decl() throws ParseException {
        Token t;
        block9: {
            t = this.jj_consume_token(2);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                        continue block8;
                    }
                    case 15: 
                    case 16: 
                    case 17: {
                        this.ArgValue();
                        continue block8;
                    }
                    case 13: {
                        this.jj_consume_token(13);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(14);
        return t;
    }

    public final void HTMLDocument() throws ParseException, IOException {
        block13: {
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 9: 
                    case 11: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.Tag();
                        this.afterTag = true;
                        continue block12;
                    }
                    case 2: {
                        Token t = this.Decl();
                        this.afterTag = true;
                        continue block12;
                    }
                    case 3: 
                    case 4: {
                        this.CommentTag();
                        this.afterTag = true;
                        continue block12;
                    }
                    case 5: {
                        Token t = this.jj_consume_token(5);
                        this.addText(t.image);
                        this.afterTag = false;
                        continue block12;
                    }
                    case 8: {
                        Token t = this.jj_consume_token(8);
                        this.addText(Entities.decode(t.image));
                        this.afterTag = false;
                        continue block12;
                    }
                    case 11: {
                        Token t = this.jj_consume_token(11);
                        this.addText(t.image);
                        this.afterTag = false;
                        continue block12;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        this.addSpace();
                        this.afterTag = false;
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[1] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(HTMLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public final void Tag() throws ParseException, IOException {
        boolean inImg = false;
        Token t1 = this.jj_consume_token(1);
        this.inTitle = t1.image.equalsIgnoreCase("<title");
        inImg = t1.image.equalsIgnoreCase("<img");
        this.inScript = this.inScript ? !t1.image.equalsIgnoreCase("</script") : t1.image.equalsIgnoreCase("<script");
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block9;
                }
            }
            t1 = this.jj_consume_token(12);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    this.jj_consume_token(13);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 15: 
                        case 16: 
                        case 17: {
                            Token t2 = this.ArgValue();
                            if (!inImg || !t1.image.equalsIgnoreCase("alt") || t2 == null) continue block9;
                            this.addText("[" + t2.image + "]");
                            continue block9;
                        }
                    }
                    this.jj_la1[3] = this.jj_gen;
                    continue block9;
                }
            }
            this.jj_la1[4] = this.jj_gen;
        }
        this.jj_consume_token(14);
    }

    void addSpace() throws IOException {
        if (this.inScript) {
            return;
        }
        if (!this.afterSpace) {
            if (this.inTitle) {
                this.title.append(" ");
            } else {
                this.addToSummary(" ");
            }
            String space = this.afterTag ? this.eol : " ";
            this.length += space.length();
            this.pipeOut.write(space);
            this.afterSpace = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addText(String text) throws IOException {
        if (this.inScript) {
            return;
        }
        if (this.inTitle) {
            this.title.append(text);
        } else {
            this.addToSummary(text);
            if (!this.titleComplete && !this.title.equals("")) {
                HTMLParser hTMLParser = this;
                synchronized (hTMLParser) {
                    this.titleComplete = true;
                    this.notifyAll();
                }
            }
        }
        this.length += text.length();
        this.pipeOut.write(text);
        this.afterSpace = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToSummary(String text) {
        if (this.summary.length() < SUMMARY_LENGTH) {
            this.summary.append(text);
            if (this.summary.length() >= SUMMARY_LENGTH) {
                HTMLParser hTMLParser = this;
                synchronized (hTMLParser) {
                    this.notifyAll();
                }
            }
        }
    }

    public final void disable_tracing() {
    }

    public final void enable_tracing() {
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[27];
        for (i = 0; i < 27; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 13; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 27; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, HTMLParserConstants.tokenImage);
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public Reader getReader() throws IOException {
        if (this.pipeIn == null) {
            this.pipeIn = new PipedReader();
            this.pipeOut = new PipedWriter(this.pipeIn);
            ParserThread thread = new ParserThread(this);
            thread.start();
        }
        return this.pipeIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSummary() throws IOException, InterruptedException {
        String tit;
        String sum;
        if (this.pipeIn == null) {
            this.getReader();
        }
        while (true) {
            HTMLParser hTMLParser = this;
            synchronized (hTMLParser) {
                if (this.summary.length() >= SUMMARY_LENGTH) {
                    break;
                }
                this.wait(10L);
            }
        }
        if (this.summary.length() > SUMMARY_LENGTH) {
            this.summary.setLength(SUMMARY_LENGTH);
        }
        if ((sum = this.summary.toString().trim()).startsWith(tit = this.getTitle())) {
            return sum.substring(tit.length());
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTitle() throws IOException, InterruptedException {
        if (this.pipeIn == null) {
            this.getReader();
        }
        while (true) {
            HTMLParser hTMLParser = this;
            synchronized (hTMLParser) {
                if (this.titleComplete || this.length > SUMMARY_LENGTH) {
                    break;
                }
                this.wait(10L);
            }
        }
        return this.title.toString().trim();
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    static final class JJCalls {
        int arg;
        Token first;
        int gen;
        JJCalls next;

        JJCalls() {
        }
    }
}

