/*
 * Decompiled with CFR 0.152.
 */
package vqwiki;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.store.RAMDirectory;
import vqwiki.Environment;
import vqwiki.SearchEngine;
import vqwiki.SearchRefreshThread;
import vqwiki.SearchResultEntry;
import vqwiki.WikiBase;
import vqwiki.lex.BackLinkLex;
import vqwiki.utils.Utilities;
import vqwiki.utils.lucene.HTMLParser;
import vqwiki.utils.lucene.LuceneTools;
import vqwiki.utils.lucene.SimpleKeepNumbersAnalyzer;

public abstract class AbstractSearchEngine
implements SearchEngine {
    protected static final String ITYPE_FILE = "file";
    protected static final String ITYPE_TOPIC = "topic";
    protected static final String ITYPE_CONTENT = "content";
    protected static final String ITYPE_CONTENT_PLAIN = "content_plain";
    protected static final String ITYPE_TOPIC_PLAIN = "topic_plain";
    private static final Logger LOGGER = Logger.getLogger((Class)(class$vqwiki$AbstractSearchEngine == null ? (class$vqwiki$AbstractSearchEngine = AbstractSearchEngine.class$("vqwiki.AbstractSearchEngine")) : class$vqwiki$AbstractSearchEngine));
    protected static String sep = System.getProperty("file.separator");
    protected static String indexPath = null;
    private static final int RAM_BASED = 0;
    private static final int FS_BASED = 1;
    private transient int fsType = 1;
    private transient boolean canParseHTML = false;
    private transient boolean canParsePDF = false;
    static /* synthetic */ Class class$vqwiki$AbstractSearchEngine;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;

    public void indexText(String virtualWiki, String topic, String text) throws IOException {
        this.add(virtualWiki, topic, text);
    }

    public void refreshIndex() throws Exception {
        this.rebuild();
    }

    public Collection find(String virtualWiki, String text, boolean doTextBeforeAndAfterParsing) {
        return this.doSearch(virtualWiki, text, false, doTextBeforeAndAfterParsing);
    }

    public Collection findLinkedTo(String virtualWiki, String topicName) throws Exception {
        HashSet<SearchResultEntry> results = new HashSet<SearchResultEntry>();
        Collection all = this.doSearch(virtualWiki, topicName, false, false);
        Iterator iterator = all.iterator();
        while (iterator.hasNext()) {
            SearchResultEntry searchResultEntry = (SearchResultEntry)iterator.next();
            String topicFoundIn = searchResultEntry.getTopic();
            if (!topicName.equalsIgnoreCase(topicFoundIn)) {
                LOGGER.debug((Object)("checking links in topic " + topicFoundIn + " to " + topicName));
                String topicContents = WikiBase.getInstance().readRaw(virtualWiki, topicFoundIn);
                StringReader reader = new StringReader(topicContents);
                BackLinkLex backLinkLex = new BackLinkLex((Reader)reader);
                while (backLinkLex.yylex() != null) {
                }
                reader.close();
                List backLinks = backLinkLex.getLinks();
                LOGGER.debug((Object)("links: " + backLinks));
                if (Utilities.containsStringIgnoreCase((Collection)backLinks, (String)topicName)) {
                    results.add(searchResultEntry);
                    LOGGER.debug((Object)("'" + topicFoundIn + "' does contain a link to '" + topicName + "'"));
                    continue;
                }
                LOGGER.debug((Object)("'" + topicFoundIn + "' contains no link to '" + topicName + "'"));
                continue;
            }
            LOGGER.debug((Object)"the topic itself is not a back link");
        }
        return results;
    }

    public Collection findMultiple(String virtualWiki, String text, boolean fuzzy) {
        return this.doSearch(virtualWiki, text, true, true);
    }

    protected void initSearchEngine(ServletContext ctx) throws Exception {
        try {
            File tmpDir = (File)ctx.getAttribute("javax.servlet.context.tempdir");
            indexPath = tmpDir.getPath();
        }
        catch (Throwable t) {
            LOGGER.warn((Object)"'javax.servlet.context.tempdir' attribute undefined or invalid, using java.io.tmpdir", t);
            indexPath = System.getProperty("java.io.tmpdir");
        }
        this.refreshIndex();
    }

    protected void initSearchEngine(String iP) throws Exception {
        indexPath = iP;
        this.refreshIndex();
    }

    protected Collection doSearch(String virtualWiki, String text, boolean caseInsensitiveSearch, boolean doTextBeforeAndAfterParsing) {
        if (indexPath == null) {
            return Collections.EMPTY_LIST;
        }
        String indexFilename = this.getSearchIndexPath(virtualWiki);
        SimpleKeepNumbersAnalyzer analyzer = new SimpleKeepNumbersAnalyzer();
        ArrayList<SearchResultEntry> result = new ArrayList<SearchResultEntry>();
        LOGGER.debug((Object)("search text: " + text));
        try {
            BooleanQuery query = new BooleanQuery();
            if (caseInsensitiveSearch) {
                query.add(QueryParser.parse((String)text, (String)ITYPE_TOPIC, (Analyzer)analyzer), false, false);
                query.add(QueryParser.parse((String)text, (String)ITYPE_CONTENT, (Analyzer)analyzer), false, false);
            } else {
                query.add(QueryParser.parse((String)("\"" + text + "\""), (String)ITYPE_TOPIC, (Analyzer)analyzer), false, false);
                query.add(QueryParser.parse((String)("\"" + text + "\""), (String)ITYPE_CONTENT, (Analyzer)analyzer), false, false);
            }
            IndexSearcher searcher = new IndexSearcher(this.getIndexDirectory(indexFilename, false));
            Hits hits = searcher.search((Query)query);
            for (int i = 0; i < hits.length(); ++i) {
                SearchResultEntry entry = new SearchResultEntry();
                entry.setTopic(hits.doc(i).get(ITYPE_TOPIC_PLAIN));
                entry.setRanking(hits.score(i));
                boolean canBeAdded = true;
                boolean found = false;
                if (doTextBeforeAndAfterParsing) {
                    String content = hits.doc(i).get(ITYPE_CONTENT_PLAIN);
                    if (content != null) {
                        if (!caseInsensitiveSearch) {
                            if (content.indexOf(text) != -1) {
                                found = true;
                            }
                        } else {
                            if (content.toLowerCase().indexOf(text.toLowerCase()) != -1) {
                                found = true;
                            }
                            if (!found) {
                                Token token;
                                HashSet terms = new HashSet();
                                LuceneTools.getTerms((Query)query, terms, false);
                                TokenStream stream = new SimpleKeepNumbersAnalyzer().tokenStream(ITYPE_CONTENT, new StringReader(content));
                                while ((token = stream.next()) != null) {
                                    if (!terms.contains(token.termText())) continue;
                                    found = true;
                                }
                            }
                            if (!found) {
                                int lastword;
                                int firstword = LuceneTools.findAfter(content, 1, 0);
                                if (firstword == -1) {
                                    firstword = 0;
                                }
                                entry.setTextBefore("");
                                entry.setFoundWord(content.substring(0, firstword));
                                if (firstword + 1 < content.length()) {
                                    ++firstword;
                                }
                                if ((lastword = LuceneTools.findAfter(content, 1, 19)) < 0) {
                                    lastword = content.length();
                                }
                                if (firstword < 0) {
                                    firstword = 0;
                                }
                                entry.setTextAfter(content.substring(Math.min(firstword, lastword), Math.max(firstword, lastword)) + " ...");
                            } else {
                                String[] tempresult = LuceneTools.outputHits(hits.doc(i).get(ITYPE_CONTENT_PLAIN), (Query)query, new Analyzer[]{new SimpleKeepNumbersAnalyzer(), new SimpleKeepNumbersAnalyzer()});
                                entry.setTextBefore("... " + tempresult[0]);
                                entry.setTextAfter(tempresult[2] + " ...");
                                entry.setFoundWord(tempresult[1]);
                            }
                        }
                    }
                    if (!caseInsensitiveSearch && !found) {
                        canBeAdded = false;
                    }
                } else {
                    canBeAdded = true;
                    entry.setTextBefore("");
                    entry.setTextAfter("");
                    entry.setFoundWord(entry.getTopic());
                }
                if (!canBeAdded) continue;
                result.add(entry);
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Error (IOExcpetion) while searching for " + text + "; Refreshing search index"));
            SearchRefreshThread.refreshNow();
        }
        catch (Exception e) {
            LOGGER.fatal((Object)("Excpetion while searching for " + text), (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void add(String virtualWiki, String topic, String contents) throws IOException {
        block28: {
            String indexFilename = this.getSearchIndexPath(virtualWiki);
            try {
                Directory directory = this.getIndexDirectory(indexFilename, false);
                if (IndexReader.isLocked((Directory)directory)) {
                    for (int count = 0; IndexReader.isLocked((Directory)directory) && count < 20; ++count) {
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    if (IndexReader.isLocked((Directory)directory)) {
                        IndexReader.unlock((Directory)directory);
                        LOGGER.fatal((Object)"Unlocking search index by force");
                    }
                }
                IndexReader reader = IndexReader.open((Directory)directory);
                reader.delete(new Term(ITYPE_TOPIC_PLAIN, topic));
                reader.close();
                directory.close();
                IndexWriter writer = new IndexWriter(directory, (Analyzer)new SimpleKeepNumbersAnalyzer(), false);
                writer.optimize();
                Document doc = this.createDocument(virtualWiki, topic);
                writer.addDocument(doc);
                Object var11_13 = null;
                try {
                    if (writer != null) {
                        writer.optimize();
                    }
                }
                catch (IOException ioe) {
                    LOGGER.fatal((Object)"IOException during optimize", (Throwable)ioe);
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ioe) {
                    LOGGER.fatal((Object)"IOException during closing", (Throwable)ioe);
                }
                writer = null;
                {
                    break block28;
                    catch (IOException ex) {
                        LOGGER.error((Object)ex);
                        Object var11_14 = null;
                        try {
                            if (writer != null) {
                                writer.optimize();
                            }
                        }
                        catch (IOException ioe) {
                            LOGGER.fatal((Object)"IOException during optimize", (Throwable)ioe);
                        }
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException ioe) {
                            LOGGER.fatal((Object)"IOException during closing", (Throwable)ioe);
                        }
                        writer = null;
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    try {
                        if (writer != null) {
                            writer.optimize();
                        }
                    }
                    catch (IOException ioe) {
                        LOGGER.fatal((Object)"IOException during optimize", (Throwable)ioe);
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException ioe) {
                        LOGGER.fatal((Object)"IOException during closing", (Throwable)ioe);
                    }
                    writer = null;
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.fatal((Object)("Excpetion while adding topic " + topic + "; Refreshing search index"), (Throwable)e);
                SearchRefreshThread.refreshNow();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Excpetion while adding topic " + topic), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void rebuild() throws Exception {
        LOGGER.info((Object)"Building index");
        Collection allWikis = WikiBase.getInstance().getVirtualWikiList();
        if (!allWikis.contains("jsp")) {
            allWikis.add("jsp");
        }
        try {
            Class.forName("vqwiki.utils.lucene.HTMLParser");
            this.canParseHTML = true;
        }
        catch (ClassNotFoundException e) {
            this.canParseHTML = false;
        }
        try {
            Class.forName("org.pdfbox.pdfparser.PDFParser");
            this.canParsePDF = true;
        }
        catch (ClassNotFoundException e) {
            this.canParsePDF = false;
        }
        Iterator iterator = allWikis.iterator();
        while (iterator.hasNext()) {
            String currentWiki = (String)iterator.next();
            LOGGER.debug((Object)("indexing virtual wiki " + currentWiki));
            File indexFile = new File(indexPath, "index" + currentWiki);
            LOGGER.debug((Object)("Index file path = " + indexFile));
            if (currentWiki.equals("jsp")) {
                currentWiki = "";
            }
            int retrycounter = 0;
            do {
                RAMDirectory ram;
                block29: {
                    ram = new RAMDirectory();
                    SimpleKeepNumbersAnalyzer analyzer = new SimpleKeepNumbersAnalyzer();
                    IndexWriter writer = new IndexWriter((Directory)ram, (Analyzer)analyzer, true);
                    Collection topics = this.getAllTopicNames(currentWiki);
                    Iterator iter = topics.iterator();
                    while (iter.hasNext()) {
                        String topic = (String)iter.next();
                        Document doc = this.createDocument(currentWiki, topic);
                        writer.addDocument(doc);
                    }
                    Object var14_16 = null;
                    try {
                        if (writer != null) {
                            writer.optimize();
                        }
                    }
                    catch (IOException ioe) {
                        LOGGER.fatal((Object)"IOException during optimize", (Throwable)ioe);
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                            retrycounter = 999;
                        }
                    }
                    catch (IOException ioe) {
                        LOGGER.fatal((Object)"IOException during close", (Throwable)ioe);
                    }
                    writer = null;
                    {
                        break block29;
                        catch (IOException ex) {
                            LOGGER.error((Object)ex);
                            var14_16 = null;
                            try {
                                if (writer != null) {
                                    writer.optimize();
                                }
                            }
                            catch (IOException ioe) {
                                LOGGER.fatal((Object)"IOException during optimize", (Throwable)ioe);
                            }
                            try {
                                if (writer != null) {
                                    writer.close();
                                    retrycounter = 999;
                                }
                            }
                            catch (IOException ioe) {
                                LOGGER.fatal((Object)"IOException during close", (Throwable)ioe);
                            }
                            writer = null;
                        }
                    }
                    catch (Throwable throwable) {
                        var14_16 = null;
                        try {
                            if (writer != null) {
                                writer.optimize();
                            }
                        }
                        catch (IOException ioe) {
                            LOGGER.fatal((Object)"IOException during optimize", (Throwable)ioe);
                        }
                        try {
                            if (writer != null) {
                                writer.close();
                                retrycounter = 999;
                            }
                        }
                        catch (IOException ioe) {
                            LOGGER.fatal((Object)"IOException during close", (Throwable)ioe);
                        }
                        writer = null;
                        throw throwable;
                    }
                }
                this.copyRamIndexToFileIndex(ram, indexFile);
            } while (++retrycounter < 1);
        }
    }

    private void copyRamIndexToFileIndex(RAMDirectory ram, File indexFile) throws IOException {
        Directory index;
        block9: {
            index = this.getIndexDirectory(indexFile.getAbsolutePath(), true);
            try {
                if (IndexReader.isLocked((Directory)index)) {
                    for (int count = 0; IndexReader.isLocked((Directory)index) && count < 20; ++count) {
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    if (IndexReader.isLocked((Directory)index)) {
                        IndexReader.unlock((Directory)index);
                        LOGGER.fatal((Object)"Unlocking search index by force");
                    }
                }
                IndexWriter indexWriter = new IndexWriter(index, null, true);
                indexWriter.close();
            }
            catch (Exception e) {
                LOGGER.fatal((Object)"Cannot create empty directory: ", (Throwable)e);
                if (this.fsType != 1) break block9;
                File[] files = indexFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
            }
        }
        String[] ar = ram.list();
        for (int i = 0; i < ar.length; ++i) {
            OutputStream os = index.createFile(ar[i]);
            InputStream is = ram.openFile(ar[i]);
            int len = (int)is.length();
            byte[] buf = new byte[len];
            is.readBytes(buf, 0, len);
            os.writeBytes(buf, len);
            is.close();
            os.close();
        }
    }

    protected Directory getIndexDirectory(String indexFilename, boolean create) throws IOException {
        if (this.fsType == 1) {
            return FSDirectory.getDirectory((String)indexFilename, (boolean)create);
        }
        return null;
    }

    protected Document createDocument(String currentWiki, String topic) throws Exception {
        String fileName;
        StringBuffer contents = new StringBuffer(WikiBase.getInstance().getHandler().read(currentWiki, topic));
        ArrayList attachments = this.extractByKeyword(contents, "attach:");
        ArrayList<String> links = new ArrayList<String>();
        ArrayList linksNonsecure = this.extractByKeyword(contents, "http://");
        Iterator iter = linksNonsecure.iterator();
        while (iter.hasNext()) {
            links.add("http://" + (String)iter.next());
        }
        ArrayList linksSecure = this.extractByKeyword(contents, "https://");
        Iterator iter2 = linksSecure.iterator();
        while (iter2.hasNext()) {
            links.add("https://" + (String)iter2.next());
        }
        if (Environment.getInstance().isAttachmentIndexingEnabled()) {
            int read;
            Reader inStream;
            HTMLParser parser;
            iter2 = attachments.iterator();
            while (iter2.hasNext()) {
                String attachmentFileName = (String)iter2.next();
                String extension = "";
                if (attachmentFileName.lastIndexOf(46) != -1) {
                    extension = attachmentFileName.substring(attachmentFileName.lastIndexOf(46) + 1).toLowerCase();
                }
                File attachmentFile = Environment.getInstance().uploadPath(currentWiki, attachmentFileName);
                if ("txt".equals(extension) || "asc".equals(extension)) {
                    StringBuffer textFileBuffer = Utilities.readFile((File)attachmentFile);
                    contents.append(" ").append(textFileBuffer);
                }
                if (this.canParseHTML && ("htm".equals(extension) || "html".equals(extension))) {
                    parser = new HTMLParser(attachmentFile);
                    contents.append(" ");
                    inStream = parser.getReader();
                    while ((read = inStream.read()) != -1) {
                        contents.append((char)read);
                    }
                    inStream.close();
                }
                if (!this.canParsePDF || !"pdf".equals(extension)) continue;
                try {
                    Class<?> pdfclass = Class.forName("vqwiki.util.lucene.PDFDocument");
                    Object pdfdocument = pdfclass.newInstance();
                    Method method = pdfclass.getMethod("getContentOfPDFFile", class$java$lang$String == null ? AbstractSearchEngine.class$("java.lang.String") : class$java$lang$String, class$java$io$File == null ? AbstractSearchEngine.class$("java.io.File") : class$java$io$File);
                    Object result = method.invoke(pdfdocument, attachmentFileName, attachmentFile);
                    if (!(result instanceof StringBuffer)) continue;
                    contents.append((StringBuffer)result);
                }
                catch (SecurityException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (ClassNotFoundException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (NoSuchMethodException e) {
                }
                catch (InvocationTargetException e) {}
            }
            if (this.canParseHTML) {
                iter2 = links.iterator();
                while (iter2.hasNext()) {
                    try {
                        String link = (String)iter2.next();
                        HttpClient client = new HttpClient();
                        client.setConnectionTimeout(15000);
                        GetMethod method = new GetMethod(link);
                        method.setFollowRedirects(true);
                        client.executeMethod((HttpMethod)method);
                        parser = new HTMLParser(method.getResponseBodyAsStream());
                        contents.append(" ");
                        inStream = parser.getReader();
                        while ((read = inStream.read()) != -1) {
                            contents.append((char)read);
                        }
                        inStream.close();
                    }
                    catch (HttpException e) {
                    }
                    catch (IOException e) {}
                }
            }
        }
        if ((fileName = this.getFilename(currentWiki, topic)) != null) {
            LOGGER.debug((Object)("Indexing topic " + topic + " in file " + fileName));
        } else {
            LOGGER.debug((Object)("Indexing topic " + topic));
        }
        Document doc = new Document();
        doc.add(Field.Text((String)ITYPE_TOPIC, (Reader)new StringReader(topic)));
        doc.add(Field.Keyword((String)ITYPE_TOPIC_PLAIN, (String)topic));
        if (fileName != null) {
            doc.add(Field.UnIndexed((String)ITYPE_FILE, (String)fileName));
        }
        doc.add(Field.Text((String)ITYPE_CONTENT, (Reader)new StringReader(contents.toString())));
        doc.add(Field.UnIndexed((String)ITYPE_CONTENT_PLAIN, (String)contents.toString()));
        return doc;
    }

    private ArrayList extractByKeyword(StringBuffer contents, String keyword) {
        ArrayList<String> returnList = new ArrayList<String>();
        int attPos = contents.toString().indexOf(keyword);
        while (attPos != -1) {
            int endPos;
            for (endPos = attPos + keyword.length() + 1; endPos < contents.length() && contents.charAt(endPos) != ' ' && contents.charAt(endPos) != '\"' && contents.charAt(endPos) != '\n' && contents.charAt(endPos) != '\r' && contents.charAt(endPos) != '\t'; ++endPos) {
            }
            returnList.add(contents.substring(attPos + keyword.length(), endPos));
            attPos = contents.toString().indexOf(keyword, endPos);
        }
        return returnList;
    }

    protected abstract String getFilename(String var1, String var2);

    public String getSearchIndexPath(String virtualWiki) {
        return indexPath + sep + "index" + virtualWiki;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

