/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.persistence;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDStream;

public class AppendDoc {
    Map clonedVersion = new HashMap();

    public void appendDocument(PDDocument destination, PDDocument source) throws IOException {
        COSBase open;
        if (destination.isEncrypted()) {
            throw new IOException("Error: destination PDF is encrypted, can't append encrypted PDF documents.");
        }
        if (source.isEncrypted()) {
            throw new IOException("Error: destination PDF is encrypted, can't append encrypted PDF documents.");
        }
        PDDocumentInformation destInfo = destination.getDocumentInformation();
        PDDocumentInformation srcInfo = source.getDocumentInformation();
        destInfo.getDictionary().mergeInto(srcInfo.getDictionary());
        COSDictionary destTrailer = destination.getDocument().getTrailer();
        COSDictionary destRoot = (COSDictionary)destTrailer.getDictionaryObject(COSName.ROOT);
        COSDictionary srcTrailer = source.getDocument().getTrailer();
        COSDictionary srcRoot = (COSDictionary)srcTrailer.getDictionaryObject(COSName.ROOT);
        COSName openAction = COSName.getPDFName("OpenAction");
        if (destRoot.getDictionaryObject(openAction) == null && (open = srcRoot.getDictionaryObject(openAction)) != null) {
            destRoot.setItem(openAction, this.copyStreamsIntoDocument(destination, open));
        }
        COSName acroForm = COSName.getPDFName("AcroForm");
        COSDictionary destAcroForm = (COSDictionary)destRoot.getDictionaryObject(acroForm);
        COSDictionary srcAcroForm = (COSDictionary)srcRoot.getDictionaryObject(acroForm);
        if (srcAcroForm != null && destAcroForm == null) {
            destRoot.setItem(acroForm, this.copyStreamsIntoDocument(destination, srcAcroForm));
        }
        COSName threads = COSName.getPDFName("Threads");
        COSArray destThreads = (COSArray)destRoot.getDictionaryObject(threads);
        COSArray srcThreads = (COSArray)srcRoot.getDictionaryObject(threads);
        if (srcThreads != null) {
            if (destThreads == null) {
                destRoot.setItem(threads, this.copyStreamsIntoDocument(destination, srcThreads));
            } else {
                destThreads.addAll((COSArray)this.copyStreamsIntoDocument(destination, srcThreads));
            }
        }
        COSName names = COSName.getPDFName("Names");
        COSDictionary destNames = (COSDictionary)destRoot.getDictionaryObject(names);
        COSDictionary srcNames = (COSDictionary)srcRoot.getDictionaryObject(names);
        if (srcNames != null) {
            if (destNames == null) {
                destRoot.setItem(names, this.copyStreamsIntoDocument(destination, srcNames));
            } else {
                destNames.mergeInto((COSDictionary)this.copyStreamsIntoDocument(destination, srcNames));
            }
        }
        COSName outlines = COSName.getPDFName("Outlines");
        COSDictionary destOutlines = (COSDictionary)destRoot.getDictionaryObject(outlines);
        COSDictionary srcOutlines = (COSDictionary)srcRoot.getDictionaryObject(outlines);
        if (srcOutlines != null && destOutlines == null) {
            destRoot.setItem(outlines, this.copyStreamsIntoDocument(destination, srcOutlines));
        }
        COSName pagemode = COSName.getPDFName("PageMode");
        COSBase srcPageMode = srcRoot.getDictionaryObject(pagemode);
        if (srcOutlines != null && destOutlines == null) {
            destRoot.setItem(pagemode, this.copyStreamsIntoDocument(destination, srcPageMode));
        }
        COSName pageLabels = COSName.getPDFName("PageLabels");
        COSDictionary destLabels = (COSDictionary)destRoot.getDictionaryObject(pageLabels);
        COSDictionary srcLabels = (COSDictionary)srcRoot.getDictionaryObject(pageLabels);
        if (srcLabels != null) {
            int destPageCount = destination.getNumberOfPages();
            COSArray destNums = null;
            if (destLabels == null) {
                destLabels = new COSDictionary();
                destNums = new COSArray();
                destLabels.setItem(COSName.getPDFName("Nums"), (COSBase)destNums);
                destRoot.setItem(pageLabels, (COSBase)destLabels);
            } else {
                destNums = (COSArray)destLabels.getDictionaryObject(COSName.getPDFName("Nums"));
            }
            COSArray srcNums = (COSArray)srcLabels.getDictionaryObject(COSName.getPDFName("Nums"));
            for (int i = 0; i < srcNums.size(); i += 2) {
                COSNumber labelIndex = (COSNumber)srcNums.getObject(i);
                long labelIndexValue = labelIndex.intValue();
                destNums.add(new COSInteger(labelIndexValue + (long)destPageCount));
                destNums.add(this.copyStreamsIntoDocument(destination, srcNums.getObject(i + 1)));
            }
        }
        COSName metadata = COSName.getPDFName("Metadata");
        COSStream destMetadata = (COSStream)destRoot.getDictionaryObject(metadata);
        COSStream srcMetadata = (COSStream)srcRoot.getDictionaryObject(metadata);
        if (destMetadata == null && srcMetadata != null) {
            PDStream newStream = new PDStream(destination, srcMetadata.getUnfilteredStream(), false);
            newStream.getStream().mergeInto(srcMetadata);
            newStream.addCompression();
            destRoot.setItem(metadata, (COSObjectable)newStream);
        }
        List pages = source.getDocumentCatalog().getAllPages();
        Iterator pageIter = pages.iterator();
        while (pageIter.hasNext()) {
            PDPage page = (PDPage)pageIter.next();
            PDPage newPage = new PDPage((COSDictionary)this.copyStreamsIntoDocument(destination, page.getCOSDictionary()));
            destination.addPage(newPage);
        }
    }

    private COSBase copyStreamsIntoDocument(PDDocument destination, COSBase base) throws IOException {
        COSBase retval = (COSBase)this.clonedVersion.get(base);
        if (retval != null) {
            return retval;
        }
        if (base instanceof COSObject) {
            COSObject object = (COSObject)base;
            retval = new COSObject(this.copyStreamsIntoDocument(destination, object.getObject()));
        } else if (base instanceof COSArray) {
            retval = new COSArray();
            COSArray array = (COSArray)base;
            for (int i = 0; i < array.size(); ++i) {
                ((COSArray)retval).add(this.copyStreamsIntoDocument(destination, array.get(i)));
            }
        } else if (base instanceof COSDictionary) {
            COSDictionary dic = (COSDictionary)base;
            List keys = dic.keyList();
            if (base instanceof COSStream) {
                COSStream originalStream = (COSStream)base;
                PDStream stream = new PDStream(destination, originalStream.getFilteredStream(), true);
                this.clonedVersion.put(base, stream.getStream());
                for (int i = 0; i < keys.size(); ++i) {
                    COSName key = (COSName)keys.get(i);
                    stream.getStream().setItem(key, this.copyStreamsIntoDocument(destination, dic.getItem(key)));
                }
                retval = stream.getStream();
            } else {
                retval = new COSDictionary();
                this.clonedVersion.put(base, retval);
                for (int i = 0; i < keys.size(); ++i) {
                    COSName key = (COSName)keys.get(i);
                    ((COSDictionary)retval).setItem(key, this.copyStreamsIntoDocument(destination, dic.getItem(key)));
                }
            }
        } else {
            retval = base;
        }
        this.clonedVersion.put(base, retval);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String in1, String in2, String out) throws IOException, COSVisitorException {
        PDDocument doc1 = null;
        PDDocument doc2 = null;
        try {
            doc1 = PDDocument.load(in1);
            doc2 = PDDocument.load(in2);
            this.appendDocument(doc1, doc2);
            doc1.save(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(doc1);
            this.close(doc2);
        }
    }

    private void close(PDDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }

    public static void main(String[] args) {
        AppendDoc app = new AppendDoc();
        try {
            if (args.length != 3) {
                app.usage();
            } else {
                app.doIt(args[0], args[1], args[2]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-file1> <input-file2> <output-file>");
    }
}

