/*
 * Decompiled with CFR 0.152.
 */
package vqwiki.utils.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import vqwiki.utils.lucene.HTMLParser;
import vqwiki.utils.lucene.TermHighlighter;

public final class LuceneTools {
    private static final Logger log = Logger.getLogger((String)(class$vqwiki$utils$lucene$LuceneTools == null ? (class$vqwiki$utils$lucene$LuceneTools = LuceneTools.class$("vqwiki.utils.lucene.LuceneTools")) : class$vqwiki$utils$lucene$LuceneTools).getName());
    static /* synthetic */ Class class$vqwiki$utils$lucene$LuceneTools;

    private LuceneTools() {
    }

    public static int findAfter(String text, int position) {
        return LuceneTools.findAfter(text, position, 15);
    }

    public static int findAfter(String text, int position, int howmany) {
        int counter = 0;
        int foundPos = -1;
        int lastcharwidth = 1;
        while (position > 0 && position < text.length() && text.charAt(position) == ' ') {
            ++position;
        }
        while (counter <= howmany && position > 0 && position < text.length()) {
            lastcharwidth = 1;
            if (text.charAt(position) == '\r' || text.charAt(position) == '\t' || text.charAt(position) == '\u00a0') break;
            if (text.charAt(position) == ' ' || position + 5 < text.length() && text.charAt(position) == '&' && text.charAt(position + 1) == 'n' && text.charAt(position + 2) == 'b' && text.charAt(position + 3) == 's' && text.charAt(position + 4) == 'p' && text.charAt(position + 5) == ';') {
                if (position + 2 >= text.length() || text.charAt(position + 2) != ' ' || text.charAt(position + 1) < 'A' || text.charAt(position + 1) > 'Z' || text.charAt(position) != ' ') {
                    ++counter;
                }
                if (text.charAt(position) != ' ') {
                    position += 5;
                    lastcharwidth = 6;
                }
            }
            ++position;
        }
        return position -= lastcharwidth;
    }

    public static int findBefore(String text, int position) {
        int counter = 0;
        int foundPos = -1;
        boolean lastspacePos = false;
        while (counter < 16 && position > 0 && position < text.length() && text.charAt(--position) != '\n' && text.charAt(position) != '\t' && text.charAt(position) != '\u00a0') {
            if (text.charAt(position) != ' ' || position - 2 >= 0 && text.charAt(position - 2) == ' ' && text.charAt(position - 1) >= 'A' && text.charAt(position - 1) <= 'Z') continue;
            ++counter;
        }
        if (text.charAt(position) == ' ') {
            ++position;
        }
        return position;
    }

    public static final void getTerms(Query query, HashSet terms, boolean prohibited) throws IOException {
        if (query instanceof BooleanQuery) {
            LuceneTools.getTermsFromBooleanQuery((BooleanQuery)query, terms, prohibited);
        } else if (query instanceof PhraseQuery) {
            LuceneTools.getTermsFromPhraseQuery((PhraseQuery)query, terms);
        } else if (query instanceof TermQuery) {
            LuceneTools.getTermsFromTermQuery((TermQuery)query, terms);
        } else if (query instanceof PrefixQuery) {
            LuceneTools.getTermsFromPrefixQuery((PrefixQuery)query, terms, prohibited);
        } else if (query instanceof RangeQuery) {
            LuceneTools.getTermsFromRangeQuery((RangeQuery)query, terms, prohibited);
        } else if (query instanceof MultiTermQuery) {
            LuceneTools.getTermsFromMultiTermQuery((MultiTermQuery)query, terms, prohibited);
        }
    }

    private static final void getTermsFromBooleanQuery(BooleanQuery query, HashSet terms, boolean prohibited) throws IOException {
        BooleanClause[] queryClauses = query.getClauses();
        for (int i = 0; i < queryClauses.length; ++i) {
            if (!prohibited && queryClauses[i].prohibited) continue;
            LuceneTools.getTerms(queryClauses[i].query, terms, prohibited);
        }
    }

    private static final void getTermsFromMultiTermQuery(MultiTermQuery query, HashSet terms, boolean prohibited) throws IOException {
        LuceneTools.getTerms((Query)query.getQuery(), terms, prohibited);
    }

    private static final void getTermsFromPhraseQuery(PhraseQuery query, HashSet terms) {
        Term[] queryTerms = query.getTerms();
        for (int i = 0; i < queryTerms.length; ++i) {
            terms.add(LuceneTools.getTermsFromTerm(queryTerms[i]));
        }
    }

    private static final void getTermsFromPrefixQuery(PrefixQuery query, HashSet terms, boolean prohibited) throws IOException {
        LuceneTools.getTerms((Query)query.getQuery(), terms, prohibited);
    }

    private static final void getTermsFromRangeQuery(RangeQuery query, HashSet terms, boolean prohibited) throws IOException {
        LuceneTools.getTerms((Query)query.getQuery(), terms, prohibited);
    }

    private static final String getTermsFromTerm(Term term) {
        return term.text().toLowerCase();
    }

    private static final void getTermsFromTermQuery(TermQuery query, HashSet terms) {
        terms.add(LuceneTools.getTermsFromTerm(query.getTerm()));
    }

    public static String highlightTerm(String term) {
        return "<B style=\"color:black;background-color:#ffff66\">" + term + "</B>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String highlightTerms(String text, TermHighlighter highlighter, Query query, Analyzer analyzer) throws IOException {
        String string;
        block11: {
            StringBuffer newText = new StringBuffer();
            TokenStream stream = null;
            try {
                Token token;
                HashSet terms = new HashSet();
                int lastEndOffset = 0;
                LuceneTools.getTerms(query, terms, false);
                boolean foundBodyStart = false;
                stream = analyzer.tokenStream(null, (Reader)new StringReader(text));
                while ((token = stream.next()) != null) {
                    if (!token.termText().equalsIgnoreCase("body") && !foundBodyStart) continue;
                    if (!foundBodyStart) {
                        token = stream.next();
                    }
                    foundBodyStart = true;
                    int startOffset = token.startOffset();
                    int endOffset = token.endOffset();
                    String tokenText = text.substring(startOffset, endOffset);
                    if (startOffset > lastEndOffset) {
                        newText.append(text.substring(lastEndOffset, startOffset));
                    }
                    if (terms.contains(token.termText())) {
                        newText.append(LuceneTools.highlightTerm(tokenText));
                    } else {
                        newText.append(tokenText);
                    }
                    lastEndOffset = endOffset;
                }
                if (lastEndOffset < text.length()) {
                    newText.append(text.substring(lastEndOffset));
                }
                string = newText.toString();
                Object var15_14 = null;
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var15_15 = null;
                    if (stream == null) break block12;
                    try {
                        stream.close();
                    }
                    catch (Exception e) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String[] outputHits(String text, Query query, Analyzer[] analyzer) throws IOException {
        block12: {
            block11: {
                htmlparser = new HTMLParser(new StringReader(text));
                in = htmlparser.getReader();
                buffer = new StringBuffer();
                while ((ch = in.read()) > -1) {
                    buffer.append((char)ch);
                }
                in.close();
                cleanText = buffer.toString();
                stream = null;
                result = new String[]{"", "", ""};
                try {
                    terms = new HashSet<E>();
                    LuceneTools.getTerms(query, terms, false);
                    LuceneTools.log.debug((Object)("Terms: " + terms));
                    for (i = 0; i < analyzer.length; ++i) {
                        stream = analyzer[i].tokenStream("content", (Reader)new StringReader(cleanText));
                        while ((token = stream.next()) != null) {
                            startOffset = token.startOffset();
                            endOffset = token.endOffset();
                            tokenText = cleanText.substring(startOffset, endOffset);
                            if (!terms.contains(token.termText())) continue;
                            tenBeforeOffset = LuceneTools.findBefore(cleanText, startOffset);
                            if (tenBeforeOffset != startOffset && startOffset > tenBeforeOffset && tenBeforeOffset != -1) {
                                result[0] = cleanText.substring(tenBeforeOffset, startOffset);
                            }
                            result[1] = tokenText;
                            tenAfterOffset = LuceneTools.findAfter(cleanText, endOffset);
                            if (tenAfterOffset != endOffset && endOffset < tenAfterOffset && tenAfterOffset != -1) {
                                result[2] = cleanText.substring(endOffset, tenAfterOffset + 1).trim();
                            }
                            stream.close();
                            var18_19 = result;
                            var20_20 = null;
                            if (stream == null) return var18_19;
                            break block11;
                        }
                    }
                    var17_12 = result;
                    break block12;
                }
                catch (Throwable var19_26) {
                    var20_22 = null;
                    if (stream == null) throw var19_26;
                    try {
                        stream.close();
                        throw var19_26;
                    }
                    catch (Exception e) {
                        throw var19_26;
                    }
                }
            }
            ** try [egrp 1[TRYBLOCK] [3 : 356->364)] { 
lbl51:
            // 1 sources

            stream.close();
            return var18_19;
lbl53:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return var18_19;
        }
        var20_21 = null;
        if (stream == null) return var17_12;
        ** try [egrp 1[TRYBLOCK] [3 : 356->364)] { 
lbl60:
        // 1 sources

        stream.close();
        return var17_12;
lbl62:
        // 1 sources

        catch (Exception e) {
            // empty catch block
        }
        return var17_12;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

