/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import vqwiki.AbstractSearchEngine;
import vqwiki.SearchResultEntry;

public class SearchApplet
extends Applet {
    private ArrayList result = null;
    private AbstractSearchEngine se = null;

    public void init() {
        super.init();
        BasicConfigurator.configure();
        Logger.getLogger((String)"org.apache").setLevel(Level.WARN);
        this.se = new AppletSearchEngine();
    }

    public String doSearch(String term) {
        this.result = new ArrayList(this.se.findMultiple("", term, true));
        return String.valueOf(this.result.size());
    }

    public String doSearch(String term, String template) {
        boolean filter = true;
        ArrayList<String> visible = new ArrayList<String>();
        try {
            InputStream in = this.getClass().getResourceAsStream("/lucene/visible.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while (br.ready()) {
                String topic = br.readLine();
                if (topic.trim().equals("")) continue;
                visible.add(topic);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            filter = false;
        }
        this.result = new ArrayList(this.se.findMultiple("", term, true));
        StringBuffer out = new StringBuffer();
        Iterator iter = this.result.iterator();
        while (iter.hasNext()) {
            SearchResultEntry searchresultentry = (SearchResultEntry)iter.next();
            if (filter && !visible.contains(searchresultentry.getTopic())) continue;
            out.append(SearchApplet.replaceString(SearchApplet.replaceString(SearchApplet.replaceString(SearchApplet.replaceString(SearchApplet.replaceString(template, "##FOUNDWORD##", searchresultentry.getFoundWord()), "##TEXTAFTER##", searchresultentry.getTextAfter()), "##TEXTBEFORE##", searchresultentry.getTextBefore()), "##TOPICADAPT##", SearchApplet.adapt(searchresultentry.getTopic())), "##TOPIC##", searchresultentry.getTopic()));
        }
        return out.toString();
    }

    private static String adapt(String topic) {
        if (topic == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < topic.length()) {
            char c;
            char ci = c = topic.charAt(i);
            if (c == ' ') {
                sb.append('+');
            } else if (c == '!' || c == '.' || c == '-' || c == '_') {
                sb.append(c);
            } else if (ci <= '\u001f' || ci >= '!' && ci <= '/' || ci >= ':' && ci <= '@' || ci >= '[' && ci <= '`' || ci >= '{') {
                sb.append("($");
                sb.append(Integer.toHexString(ci).toUpperCase());
                sb.append(")");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public String getTopic(int i) {
        if (this.result == null || i >= this.result.size()) {
            return "";
        }
        return ((SearchResultEntry)this.result.get(i)).getTopic();
    }

    public String getTextBefore(int i) {
        if (this.result == null || i >= this.result.size()) {
            return "";
        }
        return ((SearchResultEntry)this.result.get(i)).getTextBefore();
    }

    public String getTextAfter(int i) {
        if (this.result == null || i >= this.result.size()) {
            return "";
        }
        return ((SearchResultEntry)this.result.get(i)).getTextAfter();
    }

    public String getFoundWord(int i) {
        if (this.result == null || i >= this.result.size()) {
            return "";
        }
        return ((SearchResultEntry)this.result.get(i)).getFoundWord();
    }

    public static String replaceString(String text, String find, String replace) {
        int findLength = find.length();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < text.length() - find.length() + 1) {
            String substring = text.substring(i, i + findLength);
            if (substring.equals(find)) {
                buffer.append(replace);
                i += find.length() - 1;
            } else {
                buffer.append(text.charAt(i));
            }
            ++i;
        }
        buffer.append(text.substring(text.length() - (text.length() - i)));
        return buffer.toString();
    }
}

