/*
 * Decompiled with CFR 0.152.
 */
package JSX;

import JSX.Config;
import JSX.ObjOut;
import JSX.ParseUtilities;
import JSX.SerialPF;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.WriteAbortedException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class XMLSerialize {
    static final boolean defWO_DIRECT = false;
    static final boolean DEBUG = false;
    static final boolean DEBUG_HASH = false;
    static final boolean TESTCIRC = false;
    static final boolean INTERNAL_DEBUG = false;
    static final boolean CACHE_DEBUG = false;
    static final boolean REENTRY_DEBUG = false;
    static final boolean PUT_FIELD_DEBUG = false;
    static final boolean OPT_DEBUG = false;
    static final int ALIAS_INIT = -1;
    private int aliasSerialNumber;
    static final String ALIAS_TAG_TOKEN = "alias-ref";
    static final String ALIAS_ATTR_TOKEN = "alias";
    static final String ALIAS_STRING_TOKEN = "-alias";
    static final String VERSION = "Version: JSX0.8.13 (maybe out of date - sorry! See the name of the jar.)";
    static final String NAME_TOKEN = "obj-name";
    static final String CLASSNAME_TOKEN = "className";
    static final String ARRAY_TOKEN = "ArrayOf-";
    static final String ARRAY_PRIMITIVE_INDEX_TOKEN = "a";
    static final String INTERNAL_PRIMITIVE_TOKEN = "_.";
    static final String LENGTH_TOKEN = "length";
    static final String VALUE_TOKEN = "valueOf";
    static final String BINARY_DATA_TOKEN = "binary-data";
    static final String NULL_TOKEN = "null";
    static final String SUPER_TOKEN = "sub-class";
    static final String OPT_DATA_TOKEN = "opt-data";
    static final String OPT_PRIM_DATA_TOKEN = "opt-prim-data";
    static final String ALIAS_ID_TOKEN = "alias-ID";
    static final String SPACER = "  ";
    static final String JSX_HEADER_TARGET = "jsx";
    static final String XML_HEADER_TARGET = "xml";
    static final int NOT_SERIALIZED = 136;
    private boolean stringAsElement = true;
    private boolean includeAliasID = true;
    private boolean superVersion;
    private boolean optVersion;
    private boolean primOrderVersion = this.optVersion = (this.superVersion = false);
    private PrintWriter out;
    Config cfg = new Config();
    int invocationCount = 0;
    private BooleanCatcher defaultCatcher = new BooleanCatcher();
    private BooleanProtect defaultProtect = new BooleanProtect();
    private MapCatcher putFieldObjectsCatcher = new MapCatcher();
    private MapProtect putFieldObjectsProtect = new MapProtect();
    private Vector primStore;
    Vector objStore;
    private Hashtable aliasHash = new Hashtable();
    boolean areAliasesUsed = true;
    Class[] OOS_ARGS = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = XMLSerialize.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
    Object[] writeObjectArglist;
    ObjectOutputStream thisOut;
    boolean putFieldDiditAll;
    Vector clazzStack = new Vector();
    Vector thisObjectStack = new Vector();
    Vector indentStack = new Vector();
    Vector defaultCache;
    Stack putFieldClassStack = new Stack();
    private boolean formatted = true;
    private String spacer = "  ";
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;

    public static void main(String[] stringArray) {
        System.err.println(VERSION);
    }

    public XMLSerialize(PrintWriter printWriter) throws IOException {
        this(printWriter, new Config());
    }

    public XMLSerialize(PrintWriter printWriter, Config config) throws IOException {
        if (config == null) {
            throw new IOException("Config object must not be null");
        }
        this.cfg = config;
        this.setFormatted(config.formatted);
        this.primOrderVersion = this.optVersion = (this.superVersion = config.superVersion);
        this.stringAsElement = config.aliasID;
        this.includeAliasID = config.aliasID;
        this.out = printWriter;
    }

    public XMLSerialize(Config config) throws IOException {
        this(new PrintWriter((Writer)new OutputStreamWriter(System.out), true), config);
    }

    public XMLSerialize() throws IOException {
        this(new Config());
    }

    public void serialize(Object object, PrintWriter printWriter) throws IOException {
        this.out = printWriter;
        this.commonSer(object);
    }

    public void serialize(Object object) throws IOException {
        this.commonSer(object);
    }

    private void commonSer(Object object) throws IOException {
        if (this.invocationCount != 0) {
            if (this.superVersion) {
                this.serializeObject(object, null, "");
            } else {
                this.objStore.add(object);
            }
            return;
        }
        this.reset();
        ++this.invocationCount;
        String string = this.superVersion ? "2" : "1";
        this.toOutPrintln("<?jsx version=\"" + string + "\"?>");
        this.serializeObject(object, null, "");
        this.toOutPrintln();
        --this.invocationCount;
        if (this.cfg.dtdGenerator != null) {
            this.cfg.dtdGenerator.generate();
        }
    }

    public void reset() {
        if (this.invocationCount != 0) {
            throw new Error("Serialize: Attempt to reset alias table mid-way.");
        }
        this.defaultCatcher.clear();
        this.putFieldObjectsCatcher.clear();
        this.primStore = new Vector();
        this.initAlias();
        this.putFieldClassStack.clear();
    }

    public void defaultWriteObject() throws IOException {
        this.defaultCatcher.set(true);
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.flush();
        this.out.close();
    }

    public void writePrim(String string) {
        if (this.primOrderVersion) {
            this.printOpenTag(OPT_PRIM_DATA_TOKEN, "", false);
            this.printAttr(VALUE_TOKEN, ParseUtilities.encodeXML(string));
            this.toOutPrintln("/>");
        } else {
            this.primStore.add(string);
        }
    }

    private void initAlias() {
        this.aliasSerialNumber = -1;
        this.aliasHash.clear();
    }

    private boolean putAlias(Object object, String string, boolean bl, String string2) {
        if (object == null) {
            return true;
        }
        Object object2 = this.myget(object);
        if (object2 == null) {
            ++this.aliasSerialNumber;
            this.myput(object, this.aliasSerialNumber + "");
            return true;
        }
        if (bl) {
            this.printAttr(string + ALIAS_STRING_TOKEN, object2 + "");
        } else {
            this.printOpenTag(ALIAS_TAG_TOKEN, string2, false);
            if (string != null) {
                this.printAttr(NAME_TOKEN, string);
            }
            this.printAttr(ALIAS_ATTR_TOKEN, object2 + "");
            this.toOutPrintln("/>");
        }
        return false;
    }

    private void removeAlias(Object object) {
        if (!this.areAliasesUsed) {
            try {
                Object v = this.aliasHash.remove(new IdObject(object));
                if (v == null) {
                    throw new Exception("Try to remove an object not in aliasHash: " + object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Object myput(Object object, Object object2) {
        if (this.cfg.dtdGenerator != null) {
            this.cfg.dtdGenerator.populate(object);
        }
        return this.aliasHash.put(new IdObject(object), object2);
    }

    public Object myget(Object object) {
        return this.aliasHash.get(new IdObject(object));
    }

    public boolean mycontainsKey(Object object) {
        return this.aliasHash.containsKey(new IdObject(object));
    }

    public void setArg(Object[] objectArray) {
        this.writeObjectArglist = objectArray;
        this.thisOut = (ObjectOutputStream)objectArray[0];
    }

    private void serializeObject(Object object, String string, String string2) throws IOException {
        if (object == null) {
            this.serializeObject(true, object, null, -1, string, string2);
        } else {
            Class[] classArray = null;
            classArray = this.superVersion ? (object.getClass() == (class$java$lang$Object == null ? (class$java$lang$Object = XMLSerialize.class$("java.lang.Object")) : class$java$lang$Object) || object.getClass() == (class$java$util$Vector == null ? (class$java$util$Vector = XMLSerialize.class$("java.util.Vector")) : class$java$util$Vector) || object.getClass() == (class$java$util$Hashtable == null ? (class$java$util$Hashtable = XMLSerialize.class$("java.util.Hashtable")) : class$java$util$Hashtable) || object.getClass() == (class$java$lang$Class == null ? (class$java$lang$Class = XMLSerialize.class$("java.lang.Class")) : class$java$lang$Class) || object.getClass() == (class$java$lang$String == null ? (class$java$lang$String = XMLSerialize.class$("java.lang.String")) : class$java$lang$String) ? new Class[]{object.getClass()} : XMLSerialize.getReversedSuperClasses(object.getClass())) : new Class[]{object.getClass()};
            this.serializeObject(true, object, classArray, 0, string, string2);
        }
    }

    private void serializeObject(boolean bl, Object object, Class[] classArray, int n, String string, String string2) throws IOException {
        Class clazz = null;
        if (object != null) {
            clazz = classArray[n];
        }
        if (object == null) {
            this.printOpenTag(NULL_TOKEN, string2, false);
            if (string != null) {
                this.printAttr(NAME_TOKEN, string);
            }
            this.toOutPrintln("/>");
            return;
        }
        String string3 = ParseUtilities.escapeDollar(clazz.getName());
        if (clazz.isArray()) {
            this.serializeArrayReferences(object, string, string2);
        } else if (clazz == (class$java$lang$Class == null ? (class$java$lang$Class = XMLSerialize.class$("java.lang.Class")) : class$java$lang$Class)) {
            this.serializeClass((Class)object, string, string2);
        } else if (clazz == (class$java$lang$String == null ? (class$java$lang$String = XMLSerialize.class$("java.lang.String")) : class$java$lang$String)) {
            this.serializeWrapper(object, string, string2);
        } else if (clazz == (class$java$util$Vector == null ? (class$java$util$Vector = XMLSerialize.class$("java.util.Vector")) : class$java$util$Vector)) {
            if (clazz != classArray[0] || this.putAlias(object, string, false, string2)) {
                this.printOpenTag(string3, string2, true);
                if (string != null) {
                    this.printAttr(NAME_TOKEN, string);
                }
                if (((Vector)object).size() > 0) {
                    this.toOutPrintln(">");
                    this.serializeVectorReferences((Vector)object, string2);
                    this.printCloseTag(string3, string2);
                } else {
                    this.toOutPrintln("/>");
                }
                if (clazz == object.getClass()) {
                    this.removeAlias(object);
                }
            }
        } else if (clazz == (class$java$util$Hashtable == null ? (class$java$util$Hashtable = XMLSerialize.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
            if (clazz != classArray[0] || this.putAlias(object, string, false, string2)) {
                this.printOpenTag(string3, string2, true);
                if (string != null) {
                    this.printAttr(NAME_TOKEN, string);
                }
                if (((Hashtable)object).size() > 0) {
                    this.toOutPrintln(">");
                    this.serializeHashtableReferences((Hashtable)object, string2);
                    this.printCloseTag(string3, string2);
                } else {
                    this.toOutPrintln("/>");
                }
                if (clazz == classArray[0]) {
                    this.removeAlias(object);
                }
            }
        } else {
            if (!this.superVersion || this.superVersion && clazz == classArray[0]) {
                object = this.writeReplace(object);
                classArray = this.superVersion ? (object.getClass() == (class$java$lang$Object == null ? (class$java$lang$Object = XMLSerialize.class$("java.lang.Object")) : class$java$lang$Object) ? new Class[]{object.getClass()} : XMLSerialize.getReversedSuperClasses(object.getClass())) : new Class[]{object.getClass()};
                n = 0;
                clazz = classArray[n];
                string3 = ParseUtilities.escapeDollar(clazz.getName());
            }
            boolean bl2 = false;
            bl2 = this.superVersion ? (bl ? this.putAlias(object, string, false, string2) : true) : this.putAlias(object, string, false, string2);
            if (bl2) {
                if (this.superVersion && n == 0 && bl) {
                    String string4 = ParseUtilities.escapeDollar(classArray[classArray.length - 1].getName());
                    this.printOpenTag(string4, string2, true);
                    if (string != null) {
                        this.printAttr(NAME_TOKEN, string);
                    }
                    this.toOutPrintln(">");
                    this.serializeObject(false, object, classArray, 0, SUPER_TOKEN, string2 + this.spacer);
                    this.printCloseTag(string4, string2);
                } else {
                    this.printOpenTag(string3, string2, true);
                    if (string != null) {
                        this.printAttr(NAME_TOKEN, string);
                    }
                    if (this.optVersion) {
                        this.serializeFields(object, clazz, string2);
                    } else {
                        this.serializeFields(object, clazz, string2);
                        this.serializeOptAttr(object, clazz, string2);
                    }
                    boolean bl3 = false;
                    Object var11_12 = null;
                    if (this.superVersion && n + 1 < classArray.length) {
                        bl3 = true;
                    }
                    if (!this.putFieldDiditAll) {
                        try {
                            bl3 = bl3 || this.hasChildren(object, clazz);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new WriteAbortedException("", illegalAccessException);
                        }
                        if (this.optVersion) {
                            bl3 = true;
                        }
                        if (bl3) {
                            Object object2;
                            this.toOutPrintln(">");
                            if (this.optVersion) {
                                this.serializeReferences(object, clazz, string2);
                            }
                            Vector vector = this.objStore;
                            Vector vector2 = this.defaultCache;
                            boolean bl4 = false;
                            if (this.optVersion && (bl4 = this.doesOwnSer(clazz))) {
                                this.printOpenTag(OPT_DATA_TOKEN, string2 + this.spacer, false);
                                this.toOutPrintln(">");
                                this.internalSer(clazz, object);
                                if (this.primStore.size() > 0) {
                                    this.printOpenTag(OPT_PRIM_DATA_TOKEN, string2 + this.spacer + this.spacer, false);
                                    this.serializeOptAttr(object, clazz, string2);
                                    this.toOutPrintln("/>");
                                }
                            }
                            if (!this.superVersion) {
                                Enumeration enumeration = vector.elements();
                                while (enumeration.hasMoreElements()) {
                                    object2 = enumeration.nextElement();
                                    this.serializeObject(object2, null, string2 + this.spacer + this.spacer);
                                }
                            }
                            if (this.optVersion && bl4) {
                                this.printCloseTag(OPT_DATA_TOKEN, string2 + this.spacer);
                            }
                            this.defaultCache = vector2;
                            if (this.superVersion && n + 1 < classArray.length) {
                                this.serializeObject(false, object, classArray, n + 1, SUPER_TOKEN, string2 + this.spacer);
                            }
                            if (!this.optVersion) {
                                for (int i = 0; i < this.putFieldObjectsProtect.value().length; ++i) {
                                    object2 = this.putFieldObjectsProtect.value()[i];
                                    if (object2 == null) continue;
                                    Iterator iterator = object2.entrySet().iterator();
                                    while (iterator.hasNext()) {
                                        Map.Entry entry = iterator.next();
                                        this.serializeObject(entry.getValue(), entry.getKey().toString(), string2 + this.spacer);
                                    }
                                }
                                this.serializeReferences(object, clazz, string2);
                                this.finalizeGetAllFields();
                            }
                            this.printCloseTag(string3, string2);
                        } else {
                            this.finalizeGetAllFields();
                            this.toOutPrintln("/>");
                        }
                    } else {
                        this.printCloseTag(string3, string2);
                        this.putFieldDiditAll = false;
                    }
                }
                if (clazz == classArray[0]) {
                    this.removeAlias(object);
                }
            }
        }
    }

    private void printOpenTag(String string, String string2, boolean bl) {
        this.out.print(string2 + "<" + string);
        if (bl && this.includeAliasID) {
            this.printAttr(ALIAS_ID_TOKEN, this.aliasSerialNumber + "");
        }
    }

    private void printCloseTag(String string, String string2) {
        this.toOutPrintln(string2 + "</" + string + ">");
    }

    Object writeReplace(Object object) throws ObjectStreamException {
        try {
            Class<?> clazz = object.getClass();
            Method method = null;
            try {
                method = clazz.getDeclaredMethod("writeReplace", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getMethod("writeReplace", new Class[0]);
            }
            method.setAccessible(true);
            Object object2 = method.invoke(object, new Object[0]);
            return object2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("IllegalAccessException - this shouldn't happen, since we did setAccessible().  Perhaps security on the JVM precludes it?");
            illegalAccessException.printStackTrace();
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("JSX InvocationTargetException:");
            try {
                throw (ObjectStreamException)invocationTargetException.getTargetException();
            }
            catch (ClassCastException classCastException) {
                throw new Error("writeReplace() of " + object.getClass() + " threw an '" + invocationTargetException.getTargetException() + "'. It should only be of type ObjectStreamException");
            }
        }
    }

    private void serializeArrayReferences(Object object, String string, String string2) throws IOException {
        Class<?> clazz;
        if (object == null || !(clazz = object.getClass()).isArray()) {
            this.serializeWrapperOrObject(object, string2);
            return;
        }
        if (!this.putAlias(object, string, false, string2)) {
            return;
        }
        String string3 = ParseUtilities.escapeDollar(object.getClass().getName());
        if (clazz == (array$B == null ? (array$B = XMLSerialize.class$("[B")) : array$B)) {
            this.printOpenTag(BINARY_DATA_TOKEN, string2, true);
            if (string != null) {
                this.printAttr(NAME_TOKEN, string);
            }
            this.printAttr(VALUE_TOKEN, ParseUtilities.encodeHex((byte[])object, this.formatted));
            this.toOutPrintln("/>");
        } else {
            string3 = XMLSerialize.getArrayType(clazz);
            this.printOpenTag(string3, string2, true);
            if (string != null) {
                this.printAttr(NAME_TOKEN, string);
            }
            int n = Array.getLength(object);
            this.printAttr(LENGTH_TOKEN, n + "");
            if (clazz.getComponentType().isPrimitive()) {
                for (int i = 0; i < n; ++i) {
                    if (clazz.getComponentType() != Byte.TYPE) {
                        this.toOutPrintln();
                        this.out.print(string2);
                    }
                    if (clazz.getComponentType() == Character.TYPE) {
                        this.printAttr(ARRAY_PRIMITIVE_INDEX_TOKEN + i, ParseUtilities.encodeXML(Array.get(object, i) + ""));
                        continue;
                    }
                    this.printAttr(ARRAY_PRIMITIVE_INDEX_TOKEN + i, Array.get(object, i) + "");
                }
                this.toOutPrintln("/>");
            } else {
                this.toOutPrintln(">");
                for (int i = 0; i < n; ++i) {
                    this.serializeArrayReferences(Array.get(object, i), null, string2 + this.spacer);
                }
                this.printCloseTag(string3, string2);
            }
        }
        this.removeAlias(object);
    }

    static String getArrayType(Class clazz) {
        String string = "";
        String string2 = ParseUtilities.escapeDollar(clazz.getName());
        int n = 0;
        while (string2.charAt(n) == '[') {
            string = string + ARRAY_TOKEN;
            ++n;
        }
        switch (string2.charAt(n++)) {
            case 'B': {
                string = string + "byte";
                break;
            }
            case 'C': {
                string = string + "char";
                break;
            }
            case 'D': {
                string = string + "double";
                break;
            }
            case 'F': {
                string = string + "float";
                break;
            }
            case 'I': {
                string = string + "int";
                break;
            }
            case 'J': {
                string = string + "long";
                break;
            }
            case 'S': {
                string = string + "short";
                break;
            }
            case 'Z': {
                string = string + "boolean";
                break;
            }
            case 'L': {
                string = string + string2.substring(n, string2.lastIndexOf(59));
            }
        }
        return string;
    }

    private boolean hasChildren(Object object, Class clazz) throws IllegalAccessException, InvalidClassException {
        Object var3_3 = null;
        if (this.objStore.size() > 0) {
            return true;
        }
        for (int i = 0; i < this.putFieldObjectsProtect.value().length; ++i) {
            Map map = this.putFieldObjectsProtect.value()[i];
            if (map == null || map.size() <= 0) continue;
            return true;
        }
        Field[] fieldArray = this.getAllFields(object, clazz, false);
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive() || !this.stringAsElement && field.getType() == (class$java$lang$String == null ? XMLSerialize.class$("java.lang.String") : class$java$lang$String)) continue;
            return true;
        }
        if (var3_3 != null) {
            throw var3_3;
        }
        return false;
    }

    private void serializeFields(Object object, Class clazz, String string) throws InvalidClassException {
        if (object == null) {
            return;
        }
        Field[] fieldArray = this.getAllFields(object, clazz, true);
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                String string2 = this.shadowEncode(field, object.getClass());
                if (Modifier.isStatic(field.getModifiers())) continue;
                Class<?> clazz2 = field.getType();
                if (clazz2.isPrimitive()) {
                    this.toOutPrintln();
                    this.out.print(string);
                    String string3 = field.get(object).toString();
                    if (clazz2 == Character.TYPE) {
                        string3 = ParseUtilities.encodeXML(string3);
                    }
                    this.printAttr(string2, string3);
                    continue;
                }
                if (this.stringAsElement || field.get(object) == null || clazz2 != (class$java$lang$String == null ? XMLSerialize.class$("java.lang.String") : class$java$lang$String)) continue;
                this.toOutPrintln();
                this.out.print(string);
                if (!this.putAlias(field.get(object), this.shadowEncode(field, object.getClass()), true, string)) continue;
                this.printAttr(string2, ParseUtilities.encodeXML(field.get(object) + ""));
                this.removeAlias(field.get(object));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void serializeOptAttr(Object object, Class clazz, String string) {
        int n = 0;
        Enumeration enumeration = this.primStore.elements();
        while (enumeration.hasMoreElements()) {
            this.printAttr(INTERNAL_PRIMITIVE_TOKEN + n, ParseUtilities.encodeXML((String)enumeration.nextElement()));
            ++n;
        }
        this.primStore.clear();
    }

    boolean isShadowed(Field field, Class clazz) {
        Class<?> clazz2 = field.getDeclaringClass();
        while (clazz != clazz2) {
            try {
                Field field2 = clazz.getDeclaredField(field.getName());
                return true;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    String qualField(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName();
    }

    String shadowEncode(Field field, Class clazz) {
        if (this.isShadowed(field, clazz)) {
            return this.qualField(field);
        }
        return field.getName();
    }

    private void printAttr(String string, String string2) {
        this.out.print(" " + ParseUtilities.escapeDollar(string) + "=\"" + string2 + "\"");
    }

    private void serializeReferences(Object object, Class clazz, String string) throws IOException {
        if (object == null) {
            return;
        }
        Field[] fieldArray = this.getAllFields(object, clazz, false);
        for (int i = 0; i < fieldArray.length; ++i) {
            if (Modifier.isStatic(fieldArray[i].getModifiers())) continue;
            Class<?> clazz2 = fieldArray[i].getType();
            try {
                if (clazz2.isPrimitive() || !this.stringAsElement && clazz2 == (class$java$lang$String == null ? XMLSerialize.class$("java.lang.String") : class$java$lang$String)) continue;
                this.serializeObject(fieldArray[i].get(object), this.shadowEncode(fieldArray[i], object.getClass()), string + this.spacer);
                continue;
            }
            catch (Exception exception) {
                System.err.println("References: " + exception);
                System.err.println("i = " + i);
                System.err.println("f.length = " + fieldArray.length);
                exception.printStackTrace();
            }
        }
    }

    private void finalizeGetAllFields() {
        this.defaultProtect.retrieve();
        this.putFieldObjectsProtect.retrieve();
    }

    private Field[] getAllFields(Object object, Class clazz, boolean bl) throws InvalidClassException {
        Vector<Field> vector = new Vector<Field>();
        boolean bl2 = false;
        if (bl) {
            this.objStore = new Vector();
            this.defaultCache = new Vector();
        }
        if (object instanceof Externalizable) {
            if (bl) {
                try {
                    ((Externalizable)object).writeExternal(this.thisOut);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new Field[0];
        }
        Class[] classArray = null;
        classArray = this.superVersion ? new Class[]{clazz} : XMLSerialize.getReversedSuperClasses(object.getClass());
        if (bl) {
            this.defaultProtect.protect(new boolean[classArray.length]);
            this.putFieldObjectsProtect.protect(new Map[classArray.length]);
        }
        for (int i = 0; i < classArray.length; ++i) {
            boolean bl3;
            Class clazz2 = classArray[i];
            if (bl && !this.optVersion) {
                this.defaultCatcher.newCatcher();
                this.putFieldObjectsCatcher.newCatcher();
                this.internalSer(clazz2, object);
                this.putFieldObjectsProtect.value()[i] = this.putFieldObjectsCatcher.freeCatcher();
                this.defaultProtect.value()[i] = bl3 = this.defaultCatcher.freeCatcher();
            }
            bl3 = this.doesOwnSer(clazz2);
            if (!this.optVersion && bl3 && (!bl3 || !this.defaultProtect.value()[i])) continue;
            Field[] fieldArray = clazz2.getDeclaredFields();
            Map map = SerialPF.getFieldNameType(clazz2);
            boolean bl4 = SerialPF.areSerializableFieldsValidFor_defWO(map, clazz2);
            if (!bl4) {
                throw new InvalidClassException("unmatched serializable field(s) declared");
            }
            for (int j = 0; j < fieldArray.length; ++j) {
                if (!map.containsKey(fieldArray[j].getName())) continue;
                vector.add(fieldArray[j]);
            }
        }
        Object[] objectArray = new Field[vector.size()];
        vector.copyInto(objectArray);
        Field.setAccessible((AccessibleObject[])objectArray, true);
        return objectArray;
    }

    public static Class[] getReversedSuperClasses(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = XMLSerialize.class$("java.lang.Object")) : class$java$lang$Object)) {
            return new Class[0];
        }
        Class clazz2 = clazz;
        boolean bl = (class$java$io$Serializable == null ? (class$java$io$Serializable = XMLSerialize.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz2);
        int n = 0;
        do {
            if (!bl) {
                ++n;
                continue;
            }
            if (!(class$java$io$Serializable == null ? XMLSerialize.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(clazz)) continue;
            ++n;
        } while ((clazz = clazz.getSuperclass()) != (class$java$lang$Object == null ? XMLSerialize.class$("java.lang.Object") : class$java$lang$Object));
        Class[] classArray = new Class[n];
        clazz = clazz2;
        int n2 = classArray.length - 1;
        do {
            if (!bl) {
                classArray[n2--] = clazz;
                continue;
            }
            if (!(class$java$io$Serializable == null ? XMLSerialize.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(clazz)) continue;
            classArray[n2--] = clazz;
        } while ((clazz = clazz.getSuperclass()) != (class$java$lang$Object == null ? XMLSerialize.class$("java.lang.Object") : class$java$lang$Object));
        return classArray;
    }

    private boolean internalSer(Class clazz, Object object) {
        this.defaultCatcher.set(false);
        Method method = XMLSerialize.getDeclaredMethod(clazz, "writeObject", this.OOS_ARGS, 2, 8);
        if (method != null) {
            try {
                this.putFieldClassStack.push(clazz);
                method.invoke(object, this.writeObjectArglist);
                this.putFieldClassStack.pop();
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    RuntimeException runtimeException = (RuntimeException)invocationTargetException.getTargetException();
                    throw runtimeException;
                }
                catch (ClassCastException classCastException) {
                    classCastException.printStackTrace();
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
            return true;
        }
        this.defaultCatcher.set(true);
        return false;
    }

    private boolean doesOwnSer(Class clazz) {
        return XMLSerialize.getDeclaredMethod(clazz, "writeObject", this.OOS_ARGS, 2, 8) != null;
    }

    private void serializeVectorReferences(Vector vector, String string) throws IOException {
        String string2 = string + this.spacer;
        if (vector == null) {
            throw new RuntimeException("impossible; redundant safety");
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.serializeWrapperOrObject(e, string2);
        }
    }

    private void serializeWrapperOrObject(Object object, String string) throws IOException {
        if (object == null) {
            this.printOpenTag(NULL_TOKEN, string, false);
            this.toOutPrintln("/>");
            return;
        }
        Class<?> clazz = object.getClass();
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = XMLSerialize.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = XMLSerialize.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = XMLSerialize.class$("java.lang.Short")) : class$java$lang$Short) || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = XMLSerialize.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = XMLSerialize.class$("java.lang.Long")) : class$java$lang$Long) || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = XMLSerialize.class$("java.lang.Float")) : class$java$lang$Float) || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = XMLSerialize.class$("java.lang.Double")) : class$java$lang$Double)) {
            this.serializeWrapper(object, null, string);
        } else if (clazz == (class$java$lang$String == null ? (class$java$lang$String = XMLSerialize.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = XMLSerialize.class$("java.lang.Character")) : class$java$lang$Character)) {
            this.serializeWrapper(object, null, string);
        } else {
            this.serializeObject(object, null, string);
        }
    }

    private void serializeHashtableReferences(Hashtable hashtable, String string) throws IOException {
        if (hashtable == null) {
            throw new RuntimeException("impossible; redundant safety");
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            Object[] objectArray = new Object[]{k, v};
            String[] stringArray = new String[]{string + this.spacer, string + this.spacer};
            for (int i = 0; i < objectArray.length; ++i) {
                Class<?> clazz = objectArray[i].getClass();
                if (clazz == (class$java$lang$Boolean == null ? XMLSerialize.class$("java.lang.Boolean") : class$java$lang$Boolean) || clazz == (class$java$lang$Byte == null ? XMLSerialize.class$("java.lang.Byte") : class$java$lang$Byte) || clazz == (class$java$lang$Short == null ? XMLSerialize.class$("java.lang.Short") : class$java$lang$Short) || clazz == (class$java$lang$Integer == null ? XMLSerialize.class$("java.lang.Integer") : class$java$lang$Integer) || clazz == (class$java$lang$Long == null ? XMLSerialize.class$("java.lang.Long") : class$java$lang$Long) || clazz == (class$java$lang$Float == null ? XMLSerialize.class$("java.lang.Float") : class$java$lang$Float) || clazz == (class$java$lang$Double == null ? XMLSerialize.class$("java.lang.Double") : class$java$lang$Double)) {
                    this.serializeWrapper(objectArray[i], null, stringArray[i]);
                    continue;
                }
                if (clazz == (class$java$lang$String == null ? XMLSerialize.class$("java.lang.String") : class$java$lang$String) || clazz == (class$java$lang$Character == null ? XMLSerialize.class$("java.lang.Character") : class$java$lang$Character)) {
                    this.serializeWrapper(objectArray[i], null, stringArray[i]);
                    continue;
                }
                this.serializeObject(objectArray[i], null, stringArray[i]);
            }
            if (!enumeration.hasMoreElements()) continue;
            this.toOutPrintln();
        }
    }

    private void serializeWrapper(Object object, String string, String string2) {
        String string3 = ParseUtilities.escapeDollar(object.getClass().getName());
        if (this.putAlias(object, string, false, string2)) {
            this.printOpenTag(string3, string2, true);
            if (string != null) {
                this.printAttr(NAME_TOKEN, string);
            }
            if (object.getClass() == (class$java$lang$String == null ? (class$java$lang$String = XMLSerialize.class$("java.lang.String")) : class$java$lang$String)) {
                this.printAttr(VALUE_TOKEN, ParseUtilities.encodeXML((String)object));
            } else if (object.getClass() == (class$java$lang$Character == null ? (class$java$lang$Character = XMLSerialize.class$("java.lang.Character")) : class$java$lang$Character)) {
                this.printAttr(VALUE_TOKEN, ParseUtilities.encodeXML(object + ""));
            } else {
                this.printAttr(VALUE_TOKEN, object + "");
            }
            this.out.print("/>");
            this.toOutPrintln();
            this.removeAlias(object);
        }
    }

    private void serializeClass(Class clazz, String string, String string2) {
        String string3 = "java.lang.Class";
        if (this.putAlias(clazz, string, false, string2)) {
            this.printOpenTag(string3, string2, true);
            if (string != null) {
                this.printAttr(NAME_TOKEN, string);
            }
            this.printAttr(CLASSNAME_TOKEN, clazz.getName());
            this.out.print("/>");
            this.toOutPrintln();
            this.removeAlias(clazz);
        }
    }

    static Method getDeclaredMethod(Class clazz, String string, Class[] classArray, int n, int n2) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(string, classArray);
            if (method != null) {
                int n3 = method.getModifiers();
                if ((n3 & n2) != 0 || (n3 & n) != n) {
                    method = null;
                } else {
                    method.setAccessible(true);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    private void invokeObjectWriter(Method method, Object object) throws IOException {
        try {
            method.invoke(object, this.writeObjectArglist);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("internal error");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError("Unable to access writeObject method");
        }
    }

    public void setFormatted(boolean bl) {
        this.formatted = bl;
        this.spacer = bl ? SPACER : "";
    }

    private void toOutPrint(String string) {
        this.out.print(string);
    }

    private void toOutPrintln() {
        if (this.formatted) {
            this.out.println();
        }
    }

    private void toOutPrintln(String string) {
        if (this.formatted) {
            this.out.println(string);
        } else {
            this.out.print(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class PutFieldImpl
    extends ObjectOutputStream.PutField {
        Map objMap = null;
        Map primMap = null;
        Class holdingClass;
        Map serialMap;

        public PutFieldImpl() {
            this.holdingClass = (Class)XMLSerialize.this.putFieldClassStack.peek();
            this.serialMap = SerialPF.getFieldNameType(this.holdingClass);
            try {
                this.objMap = (Map)Class.forName("java.util.LinkedHashMap").newInstance();
                this.primMap = (Map)Class.forName("java.util.LinkedHashMap").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (this.objMap == null || this.primMap == null) {
                this.objMap = new HashMap();
                this.primMap = new HashMap();
            }
            Iterator iterator = this.serialMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Class clazz = (Class)entry.getValue();
                String string = (String)entry.getKey();
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        this.primMap.put(string, "false");
                        continue;
                    }
                    this.primMap.put(string, "0");
                    continue;
                }
                this.objMap.put(string, null);
            }
        }

        public void write(ObjectOutput objectOutput) throws IOException {
            Object object;
            XMLSerialize xMLSerialize = ((ObjOut)objectOutput).s;
            String string = " ";
            Iterator iterator = this.primMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                xMLSerialize.printAttr(object.getKey() + "", ParseUtilities.encodeXML(object.getValue() + ""));
            }
            int n = 0;
            object = xMLSerialize.primStore.elements();
            while (object.hasMoreElements()) {
                xMLSerialize.toOutPrintln();
                xMLSerialize.toOutPrint(string + xMLSerialize.spacer);
                xMLSerialize.printAttr(XMLSerialize.INTERNAL_PRIMITIVE_TOKEN + n, ParseUtilities.encodeXML((String)object.nextElement()));
                ++n;
            }
            xMLSerialize.primStore.clear();
            XMLSerialize.this.putFieldObjectsCatcher.set(this.objMap);
        }

        private void check(String string, Class clazz) {
            if (!this.serialMap.containsKey(string)) {
                throw new IllegalArgumentException("no such field - " + string + " is not a valid 'Serializable Field' of " + this.holdingClass);
            }
            if (!((Class)this.serialMap.get(string)).isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("no such field - " + string + " expects a " + this.serialMap.get(string) + " and cannot be assigned to from '" + clazz + "'");
            }
        }

        public void put(String string, boolean bl) {
            this.check(string, Boolean.TYPE);
            this.primMap.put(string, bl + "");
        }

        public void put(String string, char c) {
            this.check(string, Character.TYPE);
            this.primMap.put(string, c + "");
        }

        public void put(String string, byte by) {
            this.check(string, Byte.TYPE);
            this.primMap.put(string, by + "");
        }

        public void put(String string, short s) {
            this.check(string, Short.TYPE);
            this.primMap.put(string, s + "");
        }

        public void put(String string, int n) {
            this.check(string, Integer.TYPE);
            this.primMap.put(string, n + "");
        }

        public void put(String string, long l) {
            this.check(string, Long.TYPE);
            this.primMap.put(string, l + "");
        }

        public void put(String string, float f) {
            this.check(string, Float.TYPE);
            this.primMap.put(string, f + "");
        }

        public void put(String string, double d) {
            this.check(string, Double.TYPE);
            this.primMap.put(string, d + "");
        }

        public void put(String string, Object object) {
            this.check(string, object.getClass());
            this.objMap.put(string, object);
        }
    }

    class IdObject {
        Object o;

        public int hashCode() {
            return System.identityHashCode(this.o);
        }

        public boolean equals(Object object) {
            return ((IdObject)object).o == this.o;
        }

        public IdObject(Object object) {
            this.o = object;
        }
    }

    static class BooleanCatcher
    extends Stack {
        static final boolean DEBUG = false;

        BooleanCatcher() {
        }

        void newCatcher() {
            this.push(Boolean.FALSE);
        }

        void set(boolean bl) {
            Boolean bl2 = new Boolean(bl);
            this.pop();
            this.push(bl2);
        }

        boolean is() {
            return (Boolean)this.peek();
        }

        boolean freeCatcher() {
            return (Boolean)this.pop();
        }

        public String toString() {
            if (this.size() == 0) {
                return "0";
            }
            return this.size() + ", " + this.peek().toString();
        }
    }

    static class BooleanProtect
    extends Stack {
        BooleanProtect() {
        }

        void protect(boolean[] blArray) {
            this.push(blArray);
        }

        boolean[] retrieve() {
            return (boolean[])this.pop();
        }

        boolean[] value() {
            return (boolean[])this.peek();
        }
    }

    static class MapCatcher
    extends Stack {
        static final boolean DEBUG = false;

        MapCatcher() {
        }

        void newCatcher() {
            this.push(null);
        }

        void set(Map map) {
            this.pop();
            this.push(map);
        }

        Map freeCatcher() {
            return (Map)this.pop();
        }

        public String toString() {
            if (this.size() == 0) {
                return "0";
            }
            return this.size() + ", " + this.peek().toString();
        }
    }

    static class MapProtect
    extends Stack {
        MapProtect() {
        }

        void protect(Map[] mapArray) {
            this.push(mapArray);
        }

        Map[] retrieve() {
            return (Map[])this.pop();
        }

        Map[] value() {
            return (Map[])this.peek();
        }
    }
}

