/*
 * Decompiled with CFR 0.152.
 */
package JSX;

import java.io.InvalidClassException;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SerialPF {
    private static final int NOT_SERIALIZED = 136;
    private static final boolean DEBUG = false;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            stringArray = new String[]{"java.math.BigInteger"};
            System.err.println("USAGE: java SerialPF className [" + stringArray[0] + "]");
            System.err.println();
        }
        Class<?> clazz = Class.forName(stringArray[0]);
        Map map = SerialPF.getFieldNameType(clazz);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Class clazz2 = (Class)entry.getValue();
            System.err.println("\t" + clazz2.getName() + " " + string);
        }
    }

    public static boolean areSerializableFieldsValidFor_defWO(Map map, Class clazz) {
        boolean bl = true;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Class clazz2 = (Class)entry.getValue();
            try {
                Field field = null;
                try {
                    field = clazz.getDeclaredField(string);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new InvalidClassException("unmatched serializable field(s) declared - '" + string + "' is not defined in " + clazz);
                }
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new InvalidClassException("unmatched serializable field(s) declared - '" + string + "' in " + clazz + " is static (necessarily declared in 'serialPersistentFields')");
                }
                if (field.getType() == clazz2) continue;
                throw new InvalidClassException("unmatched serializable field(s) declared - '" + string + "' in " + clazz + " is of type " + field.getType().getName() + ", but the serializable field was declared to be of type " + clazz2.getName() + " (necessarily declared in 'serialPersistentFields')");
            }
            catch (InvalidClassException invalidClassException) {
                System.err.println(invalidClassException);
                bl = false;
            }
        }
        return bl;
    }

    public static Map getFieldNameType(Class clazz) {
        try {
            Field field = clazz.getDeclaredField("serialPersistentFields");
            field.setAccessible(true);
            return SerialPF.getSerialPersistentFields(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return SerialPF.getDefaultDefinedFields(clazz);
        }
    }

    public static boolean isFieldSerializable(Field field) {
        Class<?> clazz = field.getDeclaringClass();
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        try {
            Field field2 = clazz.getDeclaredField("serialPersistentFields");
            field2.setAccessible(true);
            Map map = SerialPF.getSerialPersistentFields(field2);
            return map.containsKey(field.getName());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return !Modifier.isTransient(field.getModifiers());
        }
    }

    static Map getSerialPersistentFields(Field field) {
        HashMap hashMap = new HashMap();
        ObjectStreamField[] objectStreamFieldArray = null;
        try {
            objectStreamFieldArray = (ObjectStreamField[])field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.toString());
        }
        for (int i = 0; i < objectStreamFieldArray.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            hashMap.put(objectStreamField.getName(), objectStreamField.getType());
        }
        return hashMap;
    }

    static HashMap getDefaultDefinedFields(Class clazz) {
        HashMap hashMap = new HashMap();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            hashMap.put(field.getName(), field.getType());
        }
        return hashMap;
    }
}

