/*
 * Decompiled with CFR 0.152.
 */
package JSX;

public class ParseUtilities {
    static final String DOLLAR = "_-";
    static final String EOL_SEP = System.getProperty("line.separator");

    public static boolean parseBoolean(String string) {
        String string2 = string.trim();
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalArgumentException("Boolean must be 'true' or 'false'; not '" + string2 + "')");
    }

    public static float parseFloat(String string) {
        String string2 = string.trim();
        if (string2.equals("NaN")) {
            return Float.NaN;
        }
        if (string2.equals("Infinity")) {
            return Float.POSITIVE_INFINITY;
        }
        if (string2.equals("-Infinity")) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(string2);
    }

    public static double parseDouble(String string) {
        if (string.equals("NaN")) {
            return Double.NaN;
        }
        if (string.equals("Infinity")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-Infinity")) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(string);
    }

    public static String encodeXML(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block9;
                }
                case '\\': {
                    if (i + 1 == string.length()) {
                        stringBuffer.append("\\\\");
                        ++i;
                        continue block9;
                    }
                    c = string.charAt(i + 1);
                    if (c == '\\') {
                        stringBuffer.append("\\\\\\\\");
                        ++i;
                        continue block9;
                    }
                    if (c == 'u') {
                        stringBuffer.append("\\\\u");
                        ++i;
                        continue block9;
                    }
                    if (c <= '\u001f' || c >= '\u0080' && c <= '\u009f') {
                        stringBuffer.append("\\\\");
                        continue block9;
                    }
                    stringBuffer.append("\\");
                    continue block9;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    stringBuffer.append(c);
                    continue block9;
                }
                default: {
                    if (c <= '\u001f' || c >= '\u0080') {
                        stringBuffer.append("\\u" + Integer.toHexString(c + 65536).substring(1));
                        continue block9;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String decodeXML_JSX2(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        try {
            for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                if (c == '\\') {
                    if (string.charAt(++n) == 'u') {
                        stringBuffer.append((char)Integer.parseInt(string.substring(++n, n + 4), 16));
                        n += 3;
                        continue;
                    }
                    if (string.charAt(n) == '\\') {
                        stringBuffer.append('\\');
                        n += 0;
                        continue;
                    }
                    stringBuffer.append('\\');
                    --n;
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println("Seems to be an incomplete escaped entity or \\unnnn: " + string.substring(n));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("Seems to be an incomplete escaped entity: " + string.substring(string.lastIndexOf(38)));
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Seems to be a faulty \\unnnn escaped control char: " + string.substring(n));
        }
        return stringBuffer.toString();
    }

    public static String decodeXML(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        try {
            for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                if (c == '&') {
                    if (string.startsWith("amp;", ++n)) {
                        stringBuffer.append('&');
                        n += 3;
                        continue;
                    }
                    if (string.startsWith("lt;", n)) {
                        stringBuffer.append('<');
                        n += 2;
                        continue;
                    }
                    if (string.startsWith("gt;", n)) {
                        stringBuffer.append('>');
                        n += 2;
                        continue;
                    }
                    if (string.startsWith("apos;", n)) {
                        stringBuffer.append('\'');
                        n += 4;
                        continue;
                    }
                    if (string.startsWith("quot;", n)) {
                        stringBuffer.append('\"');
                        n += 4;
                        continue;
                    }
                    throw new IllegalArgumentException("malformed XML: " + string.substring(n - 1));
                }
                if (c == '\\') {
                    if (string.charAt(++n) == 'u') {
                        stringBuffer.append((char)Integer.parseInt(string.substring(++n, n + 4), 16));
                        n += 3;
                        continue;
                    }
                    if (string.charAt(n) == '\\') {
                        stringBuffer.append('\\');
                        n += 0;
                        continue;
                    }
                    stringBuffer.append('\\');
                    --n;
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println("Seems to be an incomplete escaped entity or \\unnnn: " + string.substring(n));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("Seems to be an incomplete escaped entity: " + string.substring(string.lastIndexOf(38)));
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Seems to be a faulty \\unnnn escaped control char: " + string.substring(n));
        }
        return stringBuffer.toString();
    }

    public static String escapeDollar(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '$') {
                stringBuffer.append(DOLLAR);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String descapeDollar(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while ((n = string.indexOf(DOLLAR, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n) + '$');
            n2 = n + DOLLAR.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String print(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + byArray[i] + ", ";
        }
        return string;
    }

    public static String encodeHex(byte[] byArray) {
        return ParseUtilities.encodeHex(byArray, true);
    }

    public static String encodeHex(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        if (bl) {
            stringBuffer.append(EOL_SEP);
        }
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(ParseUtilities.toHexChar((byArray[i] & 0xF0) >>> 4));
            stringBuffer.append(ParseUtilities.toHexChar((byArray[i] & 0xF) >>> 0));
            if (!bl) continue;
            if (i % 256 == 0) {
                stringBuffer.append(EOL_SEP + EOL_SEP);
                continue;
            }
            if (i % 16 == 0) {
                stringBuffer.append(EOL_SEP);
                continue;
            }
            if (i % 4 == 0) {
                stringBuffer.append("  ");
                continue;
            }
            stringBuffer.append(' ');
        }
        if (bl) {
            stringBuffer.append(EOL_SEP);
        }
        return stringBuffer.toString();
    }

    static char toHexChar(int n) {
        if (n >= 10) {
            return (char)(n - 10 + 65);
        }
        return (char)(n + 48);
    }

    public static byte[] decodeHex(String string) {
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c;
            if (Character.isWhitespace(c = string.charAt(n2++))) continue;
            byArray[n++] = (byte)((ParseUtilities.fromHexChar(c) & 0xF) << 4 | (ParseUtilities.fromHexChar(string.charAt(n2++)) & 0xF) << 0);
        }
        if (n < string.length() / 2) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        return byArray;
    }

    static int fromHexChar(char c) {
        if (Character.isUpperCase(c)) {
            return (char)(c - 65 + 10);
        }
        if (Character.isLowerCase(c)) {
            return (char)(c - 97 + 10);
        }
        if (Character.isDigit(c)) {
            return (char)(c - 48);
        }
        throw new NumberFormatException("'" + c + "' is not a valid hex character");
    }

    static class Hex {
        Hex() {
        }

        public static void main(String[] stringArray) {
            if (stringArray.length > 0) {
                byte[] byArray = ParseUtilities.decodeHex(stringArray[0]);
                System.err.print(ParseUtilities.print(byArray));
                System.err.print(ParseUtilities.encodeHex(byArray));
            } else {
                byte[] byArray = new byte[512];
                int n = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    int n2 = n;
                    n = (byte)(n + 1);
                    byArray[i] = n2;
                }
                System.err.print(ParseUtilities.print(byArray) + " -> ");
                String string = ParseUtilities.encodeHex(byArray);
                System.err.print(string + " -> ");
                System.err.print(ParseUtilities.print(ParseUtilities.decodeHex(string)));
                System.err.println();
            }
        }
    }

    static class Dollar {
        Dollar() {
        }

        public static void main(String[] stringArray) {
            if (stringArray.length == 0) {
                stringArray = new String[]{"$a$a$"};
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string = ParseUtilities.escapeDollar(stringArray[i]);
                System.err.println(stringArray[i] + " -> " + string + " -> " + ParseUtilities.descapeDollar(string));
            }
        }
    }
}

