/*
 * Decompiled with CFR 0.152.
 */
package de.tisje.java2html;

import de.java2html.converter.JavaSource2XmlConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.util.IoUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;

public class XsltTask {
    private static final JavaSource2XmlConverter converter = new JavaSource2XmlConverter();
    private static JavaSource source = null;
    private static boolean xhtml = false;

    public static void setOptions(boolean lineNumbers, boolean pre, boolean xhtml) {
        converter.setOptions(lineNumbers, pre, xhtml);
        XsltTask.xhtml = xhtml;
    }

    public static String getStyle() {
        return converter.getStyle();
    }

    public static void setSource(String javaSource) {
        source = new JavaSourceParser().parse(javaSource);
    }

    public static void readFile(String javaFile) throws IOException {
        source = new JavaSourceParser().parse(new File(javaFile));
    }

    public static String getSource() throws IOException {
        StringWriter writer = new StringWriter();
        writer.write(converter.getDocumentHeader());
        converter.convert(source, writer);
        writer.write(converter.getDocumentFooter());
        return writer.getBuffer().toString();
    }

    public static void writeFile(String filename) throws IOException {
        XsltTask.writeFile(new File(filename));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFile(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        try {
            fileWriter.write(converter.getDocumentHeader());
            converter.convert(source, fileWriter);
            fileWriter.write(converter.getDocumentFooter());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            IoUtilities.close(fileWriter);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        IoUtilities.close(fileWriter);
    }

    public static void main(String[] args) {
        String ext = ".xhtml";
        if (!xhtml) {
            ext = ".xml";
        }
        int i = 0;
        while (args.length > i) {
            try {
                XsltTask.readFile(args[i]);
                XsltTask.writeFile(String.valueOf(args[i]) + ext);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

