/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.plugin.jspwiki;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.AttachmentManager;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.net.URL;

public class PluginSecurityManager {
    private static final String FILE_URL_PROPERTY = "de.java2html.file.url.enabled";
    private static final String HTTP_URL_PROPERTY = "de.java2html.http.url.enabled";
    private WikiContext context;

    public PluginSecurityManager(WikiContext context) {
        this.context = context;
    }

    public void checkUrlAccessEnabled(URL url) throws PluginException {
        if ("file".equals(url.getProtocol())) {
            if (!this.isPropertySetTrue(this.context, FILE_URL_PROPERTY)) {
                throw new PluginException("File URLs are disabled in this Wiki (property 'de.java2html.file.url.enabled' is not set to true).");
            }
        } else if ("http".equals(url.getProtocol())) {
            if (!this.isPropertySetTrue(this.context, HTTP_URL_PROPERTY)) {
                throw new PluginException("Http URLs are disabled in this Wiki (property 'de.java2html.http.url.enabled' is not set to true).");
            }
        } else {
            throw new PluginException("Unsupported protocol: '" + url.getProtocol() + "'");
        }
    }

    private boolean isPropertySetTrue(WikiContext context, String key) {
        Object value = context.getEngine().getWikiProperties().get(key);
        return value != null && "true".equals(value);
    }

    public void checkValidAttachmentUrlPart(String attachment) throws PluginException {
        AttachmentManager attachmentManager = this.context.getEngine().getAttachmentManager();
        if (!attachmentManager.attachmentsEnabled()) {
            throw new PluginException("Attachments are not enabled in this Wiki.");
        }
        if (!attachmentManager.hasAttachments(this.context.getPage())) {
            throw new PluginException("The current page does not have any attachments.");
        }
        Attachment attachmentInfo = null;
        try {
            attachmentInfo = attachmentManager.getAttachmentInfo(this.context, attachment);
        }
        catch (ProviderException providerException) {
            throw new PluginException("The current page does not have an attachment '" + attachment + "'");
        }
        if (attachmentInfo == null) {
            throw new PluginException("The current page does not have an attachment '" + attachment + "'");
        }
    }
}

