/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.gui;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.util.StringTokenizer;

public class GLabel
extends Canvas {
    protected String[] lines;
    protected int lineHeight;
    protected int blockWidth;
    protected int blockHeight;
    protected int fontAscent;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int alignment = 0;

    public GLabel(String text) {
        this(text, 0);
    }

    public GLabel(String text, int alignment) {
        this.alignment = alignment;
        this.setText(text);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(text, "\t", true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.charAt(0) == '\t') {
                sb.append("      ");
                continue;
            }
            sb.append(s);
        }
        text = sb.toString();
        int l = 1;
        int i1 = text.indexOf(10);
        while (i1 != -1) {
            ++l;
            i1 = text.indexOf(10, i1 + 1);
        }
        this.lines = new String[l];
        int lineIndex = 0;
        i1 = 0;
        int i2 = text.indexOf(10);
        while (i2 != -1) {
            this.lines[lineIndex++] = text.substring(i1, i2);
            i1 = i2 + 1;
            i2 = text.indexOf(10, i1);
        }
        this.lines[lineIndex] = text.substring(i1);
        this.blockWidth = 0;
        this.invalidate();
        Container parent = this.getParent();
        if (parent != null) {
            ((Component)parent).validate();
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.blockWidth != 0 && this.blockHeight != 0) {
            return new Dimension(this.blockWidth, this.blockHeight);
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.blockWidth = 0;
        this.blockHeight = 0;
        int i = 0;
        while (i < this.lines.length) {
            int l = fm.stringWidth(this.lines[i]);
            if (l > this.blockWidth) {
                this.blockWidth = l;
            }
            ++i;
        }
        this.fontAscent = fm.getAscent();
        this.lineHeight = fm.getHeight();
        this.blockHeight = this.lines.length * this.lineHeight;
        return new Dimension(this.blockWidth, this.blockHeight);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        if (this.isEnabled()) {
            g.setColor(SystemColor.controlText);
            this.draw(g, 0, 0);
        } else {
            g.setColor(SystemColor.controlLtHighlight);
            this.draw(g, 1, 1);
            g.setColor(SystemColor.controlShadow);
            this.draw(g, 0, 0);
        }
    }

    protected void draw(Graphics g, int x0, int y0) {
        block4: {
            block5: {
                block3: {
                    if (this.alignment != 0) break block3;
                    int i = 0;
                    while (i < this.lines.length) {
                        g.drawString(this.lines[i], x0, y0 + this.fontAscent + i * this.lineHeight);
                        ++i;
                    }
                    break block4;
                }
                if (this.alignment != 2) break block5;
                Dimension d = this.getSize();
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int i = 0;
                while (i < this.lines.length) {
                    int l = fm.stringWidth(this.lines[i]);
                    g.drawString(this.lines[i], x0 + d.width - l, y0 + this.fontAscent + i * this.lineHeight);
                    ++i;
                }
                break block4;
            }
            if (this.alignment != 1) break block4;
            Dimension d = this.getSize();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int i = 0;
            while (i < this.lines.length) {
                int l = fm.stringWidth(this.lines[i]);
                g.drawString(this.lines[i], x0 + (d.width - l) / 2, y0 + this.fontAscent + i * this.lineHeight);
                ++i;
            }
        }
    }
}

