/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;

public class GBorderedPanel
extends Panel {
    public static final int NONE = -1;
    public static final int DOWN = 0;
    public static final int UP = 1;
    public static final int SIMPLE_DOWN = 2;
    public static final int SIMPLE_UP = 3;
    public static final int SIMPLE3 = 4;
    protected int borderStyle;
    protected String label;

    public GBorderedPanel() {
        this(null, 2);
    }

    public GBorderedPanel(int borderStyle) {
        this(null, borderStyle);
    }

    public GBorderedPanel(String label) {
        this(label, 2);
    }

    public GBorderedPanel(String label, int borderStyle) {
        this.borderStyle = borderStyle;
        this.label = label;
    }

    public Insets insets() {
        if (this.label == null) {
            if (this.borderStyle == -1) {
                return new Insets(0, 0, 0, 0);
            }
            if (this.borderStyle == 2 || this.borderStyle == 3) {
                return new Insets(10, 9, 10, 9);
            }
            if (this.borderStyle == 4) {
                return new Insets(8, 7, 8, 7);
            }
            return new Insets(2, 2, 2, 2);
        }
        if (this.borderStyle == 2 || this.borderStyle == 3) {
            return new Insets(15, 9, 10, 9);
        }
        if (this.borderStyle == 4) {
            return new Insets(20, 9, 8, 9);
        }
        if (this.borderStyle == -1) {
            return new Insets(14, 0, 0, 0);
        }
        return new Insets(14, 2, 2, 2);
    }

    protected void drawLabel(Graphics g, int x, int y) {
        if (this.isEnabled()) {
            g.drawString(this.label, x, y);
        } else {
            g.setColor(SystemColor.controlLtHighlight);
            g.drawString(this.label, x + 1, y + 1);
            g.setColor(SystemColor.controlShadow);
            g.drawString(this.label, x, y);
        }
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.borderStyle == 2) {
            if (this.label != null) {
                this.drawLabel(g, 12, 12);
                int w = this.getFontMetrics(this.getFont()).stringWidth(this.label);
                int y1 = 7;
                g.setColor(SystemColor.controlShadow);
                g.drawLine(2, y1, 9, y1);
                g.drawLine(14 + w, y1, d.width - 4, y1);
                g.drawLine(2, d.height - 4, d.width - 4, d.height - 4);
                g.drawLine(2, y1 + 1, 2, d.height - 5);
                g.drawLine(d.width - 4, y1 + 1, d.width - 4, d.height - 5);
                g.setColor(SystemColor.controlLtHighlight);
                g.drawLine(3, y1 + 1, 9, y1 + 1);
                g.drawLine(14 + w, y1 + 1, d.width - 5, y1 + 1);
                g.drawLine(2, d.height - 3, d.width - 3, d.height - 3);
                g.drawLine(3, y1 + 2, 3, d.height - 5);
                g.drawLine(d.width - 3, y1, d.width - 3, d.height - 3);
            } else {
                g.setColor(SystemColor.controlShadow);
                g.drawLine(2, 2, d.width - 4, 2);
                g.drawLine(2, d.height - 4, d.width - 4, d.height - 4);
                g.drawLine(2, 3, 2, d.height - 5);
                g.drawLine(d.width - 4, 3, d.width - 4, d.height - 5);
                g.setColor(SystemColor.controlLtHighlight);
                g.drawLine(3, 3, d.width - 5, 3);
                g.drawLine(2, d.height - 3, d.width - 3, d.height - 3);
                g.drawLine(3, 4, 3, d.height - 5);
                g.drawLine(d.width - 3, 2, d.width - 3, d.height - 3);
            }
        } else if (this.borderStyle == 3) {
            if (this.label != null) {
                this.drawLabel(g, 12, 12);
                int w = this.getFontMetrics(this.getFont()).stringWidth(this.label);
                int y1 = 7;
                g.setColor(SystemColor.controlLtHighlight);
                g.drawLine(2, y1, 9, y1);
                g.drawLine(14 + w, y1, d.width - 4, y1);
                g.drawLine(2, d.height - 4, d.width - 4, d.height - 4);
                g.drawLine(2, y1 + 1, 2, d.height - 5);
                g.drawLine(d.width - 4, y1 + 1, d.width - 4, d.height - 5);
                g.setColor(SystemColor.controlShadow);
                g.drawLine(3, y1 + 1, 9, y1 + 1);
                g.drawLine(14 + w, y1 + 1, d.width - 5, y1 + 1);
                g.drawLine(2, d.height - 3, d.width - 3, d.height - 3);
                g.drawLine(3, y1 + 2, 3, d.height - 5);
                g.drawLine(d.width - 3, y1, d.width - 3, d.height - 3);
            } else {
                g.setColor(SystemColor.controlLtHighlight);
                g.drawLine(2, 2, d.width - 4, 2);
                g.drawLine(2, d.height - 4, d.width - 4, d.height - 4);
                g.drawLine(2, 3, 2, d.height - 5);
                g.drawLine(d.width - 4, 3, d.width - 4, d.height - 5);
                g.setColor(SystemColor.controlShadow);
                g.drawLine(3, 3, d.width - 5, 3);
                g.drawLine(2, d.height - 3, d.width - 3, d.height - 3);
                g.drawLine(3, 4, 3, d.height - 5);
                g.drawLine(d.width - 3, 2, d.width - 3, d.height - 3);
            }
        } else if (this.borderStyle == 0) {
            int h = 0;
            if (this.label != null) {
                h = 12;
                this.drawLabel(g, 0, 10);
            }
            g.setColor(SystemColor.controlDkShadow);
            g.drawLine(1, h + 1, d.width - 1, h + 1);
            g.drawLine(1, h + 2, 1, d.height - 1);
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, h, d.width - 1, h);
            g.drawLine(0, h + 1, 0, d.height - 1);
            g.setColor(SystemColor.controlHighlight);
            g.drawLine(1, d.height - 2, d.width - 2, d.height - 2);
            g.drawLine(d.width - 2, d.height - 3, d.width - 2, h + 1);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(0, d.height - 1, d.width - 1, d.height - 1);
            g.drawLine(d.width - 1, d.height - 2, d.width - 1, h);
        } else if (this.borderStyle == 1) {
            int h = 0;
            if (this.label != null) {
                h = 12;
                this.drawLabel(g, 0, 10);
            }
            g.setColor(SystemColor.controlHighlight);
            g.drawLine(1, h + 1, d.width - 1, h + 1);
            g.drawLine(1, h + 2, 1, d.height - 1);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(0, h, d.width - 1, h);
            g.drawLine(0, h + 1, 0, d.height - 1);
            g.setColor(SystemColor.controlShadow);
            g.drawLine(1, d.height - 2, d.width - 2, d.height - 2);
            g.drawLine(d.width - 2, d.height - 1, d.width - 2, h + 1);
            g.setColor(SystemColor.controlDkShadow);
            g.drawLine(0, d.height - 1, h + d.width - 1, d.height - 1);
            g.drawLine(d.width - 1, h + d.height - 1, d.width - 1, h + 0);
        } else if (this.borderStyle == 4) {
            if (this.label != null) {
                this.drawLabel(g, 1, 11);
                g.drawRect(2, 14, d.width - 1 - 2 - 2, d.height - 1 - 14 - 2);
            } else {
                g.drawRect(2, 2, d.width - 5, d.height - 5);
            }
        } else if (this.borderStyle == -1 && this.label != null) {
            this.drawLabel(g, 0, 11);
        }
    }

    public void setEnabled(boolean what) {
        super.setEnabled(what);
        Component[] c = this.getComponents();
        if (c == null || c.length == 0) {
            return;
        }
        int i = 0;
        while (i < c.length) {
            c[i].setEnabled(what);
            ++i;
        }
    }
}

