/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.commandline.test;

import de.java2html.commandline.IJava2HtmlConversion;
import de.java2html.commandline.IllegalCommandlineParametersException;
import de.java2html.commandline.Java2HtmlCommandline;
import de.java2html.options.Java2HtmlConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.test.BasicTestCase;
import junit.framework.Assert;

public class Java2HtmlCommandlineTest
extends BasicTestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public void testCreateDirectoryConverter() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcdir", "d:/src"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.java2html.commandline.Java2HtmlDirectoryConversion");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertInstanceOf(clazz, conversion);
    }

    public void testCreateFileConverter() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("de.java2html.commandline.Java2HtmlFileConversion");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertInstanceOf(clazz, conversion);
    }

    public void testHtmlIsDefaultConverter() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("de.java2html.converter.JavaSource2HTMLConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertInstanceOf(clazz, conversion.getConverter());
    }

    public void testUsesSpecifiedConverter() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-converter", "TeX"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("de.java2html.converter.JavaSource2TeXConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertInstanceOf(clazz, conversion.getConverter());
    }

    public void testUnknwonConverterThrowsException() {
        final String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-converter", "UnknownConverterName"};
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                Java2HtmlCommandline.createCommandlineConversion(arguments);
            }
        });
    }

    public void testUsesCorrectDefaultStyle() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Assert.assertEquals((Object)JavaSourceStyleTable.getDefault(), (Object)conversion.getConverter().getConversionOptions().getStyleTable());
    }

    public void testUsesSpecifiedStyle() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-style", "Monochrome"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Assert.assertEquals((Object)JavaSourceStyleTable.getPredefinedTable("Monochrome"), (Object)conversion.getConverter().getConversionOptions().getStyleTable());
    }

    public void testUnknownStyleThrowsException() {
        final String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-style", "UnknownStyleName"};
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                Java2HtmlCommandline.createCommandlineConversion(arguments);
            }
        });
    }

    public void testUsesDefaultTabs() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Assert.assertEquals((int)Java2HtmlConversionOptions.getDefault().getTabSize(), (int)conversion.getConverter().getConversionOptions().getTabSize());
    }

    public void testUsesSpecifiedTabs() throws IllegalCommandlineParametersException {
        String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-tabs", "5"};
        IJava2HtmlConversion conversion = Java2HtmlCommandline.createCommandlineConversion(arguments);
        Assert.assertEquals((int)5, (int)conversion.getConverter().getConversionOptions().getTabSize());
    }

    public void testIllegalTabsThrowsException() {
        final String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-tabs", "illegal"};
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                Java2HtmlCommandline.createCommandlineConversion(arguments);
            }
        });
    }

    public void testNegativeTabsThrowsException() {
        final String[] arguments = new String[]{"-srcfile", "d:/src/test.java", "-tabs", "-3"};
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                Java2HtmlCommandline.createCommandlineConversion(arguments);
            }
        });
    }

    public void testUnsupportedArgumentThrowsException() {
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-anUnsupportedArgument"});
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-srcfile"});
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-srcfile", "d:/src/test.java", "-filemask", "*.txt"});
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-srcfile", "d:/src/test.java", "-copytotargetunprocessedfiles"});
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-srcdir", "d:/src", "-copytotargetunprocessedfiles", "true"});
        Java2HtmlCommandlineTest.assertIsIllegalCommandLineArguments(new String[]{"-srcdir", "d:/src", "-copytotargetunprocessedfiles", "-anything"});
    }

    private static void assertIsIllegalCommandLineArguments(final String[] arguments) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                Java2HtmlCommandline.createCommandlineConversion(arguments);
            }
        });
    }
}

