/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.anttasks;

import de.java2html.converter.JavaSourceConverter;
import de.java2html.converter.JavaSourceConverterProvider;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.ConversionOptionsUtilities;
import de.java2html.options.HorizontalAlignment;
import de.java2html.options.Java2HtmlConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.util.IoUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Java2HtmlTask
extends MatchingTask {
    private String style = "kawa";
    private File srcDir;
    private File destDir;
    private boolean overwrite = false;
    private String outputFormat = "html";
    private int tabs = 2;
    private boolean showLineNumbers = true;
    private boolean addLineAnchors = false;
    private String lineAnchorPrefix = "";
    private boolean showTableBorder = false;
    private boolean showFileName = false;
    private boolean includeDocumentHeader = true;
    private boolean includeDocumentFooter = true;
    private boolean useShortFileName = false;
    private String horizontalAlignment = HorizontalAlignment.LEFT.getName();

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    private File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    private String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void execute() throws BuildException {
        String[] sourceFilesToProcess;
        if (this.srcDir == null) {
            this.srcDir = this.project.resolveFile(".");
        }
        DirectoryScanner dirScanner = this.getDirectoryScanner(this.srcDir);
        String[] allSourceFiles = dirScanner.getIncludedFiles();
        JavaSourceConverter converter = this.getConverter();
        Java2HtmlConversionOptions options = this.getConversionOptions();
        converter.setConversionOptions(options);
        SourceFileScanner sourceScanner = new SourceFileScanner((Task)this);
        if (this.isOverwrite()) {
            sourceFilesToProcess = allSourceFiles;
        } else {
            GlobPatternMapper sourceToOutMapper = new GlobPatternMapper();
            sourceToOutMapper.setFrom("*");
            sourceToOutMapper.setTo("*." + converter.getDefaultFileExtension());
            sourceFilesToProcess = sourceScanner.restrict(allSourceFiles, this.srcDir, this.destDir, (FileNameMapper)sourceToOutMapper);
        }
        if (sourceFilesToProcess.length > 0) {
            String files = sourceFilesToProcess.length == 1 ? " file" : " files";
            this.log("Converting " + sourceFilesToProcess.length + files, 2);
        }
        int i = 0;
        while (i < sourceFilesToProcess.length) {
            this.process(sourceFilesToProcess[i], options, converter);
            ++i;
        }
    }

    private Java2HtmlConversionOptions getConversionOptions() {
        Java2HtmlConversionOptions options = Java2HtmlConversionOptions.getDefault();
        options.setTabSize(this.getTabs());
        options.setShowFileName(this.isShowFileName());
        options.setShowTableBorder(this.isShowTableBorder());
        options.setShowLineNumbers(this.isShowLineNumbers());
        options.setAddLineAnchors(this.isAddLineAnchors());
        options.setLineAnchorPrefix(this.getLineAnchorPrefix());
        JavaSourceStyleTable table = JavaSourceStyleTable.getPredefinedTable(this.getStyle());
        if (table == null) {
            throw new BuildException("Specified style table '" + this.getStyle() + "' does not exist " + " - valid values are: " + ConversionOptionsUtilities.getPredefinedStyleTableNameString());
        }
        options.setStyleTable(table);
        HorizontalAlignment alignment = HorizontalAlignment.getByName(this.getHorizontalAlignment());
        if (alignment == null) {
            throw new BuildException("Specified alignment '" + this.getHorizontalAlignment() + "'does not exist - valid values are: " + ConversionOptionsUtilities.getAvailableHorizontalAlignmentNames());
        }
        options.setHorizontalAlignment(alignment);
        return options;
    }

    private JavaSourceConverter getConverter() throws BuildException {
        JavaSourceConverter converter = JavaSourceConverterProvider.getJavaSourceConverterByName(this.getOutputFormat());
        if (converter == null) {
            throw new BuildException("unknown output file format: " + this.outputFormat);
        }
        return converter;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void process(String sourcefileName, Java2HtmlConversionOptions options, JavaSourceConverter converter) throws BuildException {
        JavaSource source;
        this.log("Converting '" + sourcefileName + "'", 3);
        JavaSourceParser parser = new JavaSourceParser(options);
        File inFile = new File(this.srcDir, sourcefileName);
        try {
            source = parser.parse(inFile);
        }
        catch (IOException e1) {
            throw new BuildException("Unable to parse file " + inFile.getName(), (Throwable)e1);
        }
        File outFile = this.createOutputFile(sourcefileName, converter);
        this.ensureDirectoryFor(outFile);
        FileWriter writer = null;
        try {
            writer = new FileWriter(outFile);
        }
        catch (Exception e) {
            throw new BuildException("Error opening output file " + outFile.getName(), (Throwable)e);
        }
        try {
            try {
                if (this.isIncludeDocumentHeader()) {
                    writer.write(converter.getDocumentHeader());
                }
                converter.convert(source, writer);
                if (this.isIncludeDocumentFooter()) {
                    writer.write(converter.getDocumentFooter());
                }
            }
            catch (Exception e) {
                throw new BuildException("Error writing output to " + outFile.getName(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            IoUtilities.close(writer);
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        IoUtilities.close(writer);
        this.log("Output: " + outFile, 3);
    }

    private File createOutputFile(String sourcefileName, JavaSourceConverter converter) {
        int index;
        String fileNamePrefix = sourcefileName;
        if (this.isUseShortFileName() && (index = sourcefileName.lastIndexOf(46)) != -1) {
            fileNamePrefix = sourcefileName.substring(0, index);
        }
        return new File(this.getDestDir(), String.valueOf(fileNamePrefix) + "." + converter.getDefaultFileExtension());
    }

    private int getTabs() {
        return this.tabs;
    }

    public void setTabs(int tabs) {
        this.tabs = tabs;
    }

    private String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    private void ensureDirectoryFor(File targetFile) throws BuildException {
        File directory = new File(targetFile.getParent());
        if (!directory.exists() && !directory.mkdirs()) {
            throw new BuildException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    private boolean isShowFileName() {
        return this.showFileName;
    }

    private boolean isShowLineNumbers() {
        return this.showLineNumbers;
    }

    private boolean isShowTableBorder() {
        return this.showTableBorder;
    }

    public void setShowFileName(boolean showFileName) {
        this.showFileName = showFileName;
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        this.showLineNumbers = showLineNumbers;
    }

    public void setShowTableBorder(boolean showTableBorder) {
        this.showTableBorder = showTableBorder;
    }

    private boolean isIncludeDocumentFooter() {
        return this.includeDocumentFooter;
    }

    private boolean isIncludeDocumentHeader() {
        return this.includeDocumentHeader;
    }

    public void setIncludeDocumentFooter(boolean includeDocumentFooter) {
        this.includeDocumentFooter = includeDocumentFooter;
    }

    public void setIncludeDocumentHeader(boolean includeDocumentHeader) {
        this.includeDocumentHeader = includeDocumentHeader;
    }

    private boolean isAddLineAnchors() {
        return this.addLineAnchors;
    }

    public void setAddLineAnchors(boolean addLineAnchors) {
        this.addLineAnchors = addLineAnchors;
    }

    private String getLineAnchorPrefix() {
        return this.lineAnchorPrefix;
    }

    public void setLineAnchorPrefix(String string) {
        this.lineAnchorPrefix = string;
    }

    private String getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(String horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    private boolean isUseShortFileName() {
        return this.useShortFileName;
    }

    public void setUseShortFileName(boolean useShortFileName) {
        this.useShortFileName = useShortFileName;
    }

    private boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

